!+
!KWIC chex.f
!
!$Id: chex.f,v 1.2 2004/03/17 21:23:31 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-27[T. Gaetz]
!      . change dimension of LSW to (10, 21) for consistency w/ other routines
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 9/1/88 TO DELETE STOP CHECKS IF THE SURFACE IS AN
!  OBSCURATION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE CHEX (J, KX, MODE, KODE) !*** SLASHES TAKEN OFF KX
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    CHEX FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 04/17/80
C    *
C    *    UPDATE:   10/22/80
C    *    TIME:     15:15:05
C    *
C    ******************************************/
C
C  CHECK A RAY INTERSECTION POINT VS SURFACE LIMITS
C  CHEX WILL TEST AND POSSIBLY REDEFINE KODE, THE RAY TRACE STATUS CODE
C
C  INPUT ARGUMENTS:
C    J    : I*4  SURFACE NUMBER (BETWEEN 1 AND NS)
C    KX   : IV#  INTERSECTION OF THE RAY & THE SURFACE
C    MODE : I*4  CONDITION CODE AS FOLLOWS
C         : 2 - INTERNAL REFLECTION
C         : 4 - EXTERNAL REFLECTION
C    KODE : I*4  CONDITION CODE AS FOLLOWS
C         : 0 - INCONSISTENT OR TAUTOLOGICAL DISTANCE EQUATION
C         : 1 - INTERNAL REFRACTION
C         : 2 - INTERNAL REFLECTION
C         : 3 - EXTERNAL REFRACTION
C         : 4 - EXTERNAL REFLECTION
C         : 7 - NEGATIVE DISTANCE
C         : 8 - EXCESSIVE ROUND OFF ERROR
C         : 9 - TOO MANY ITERATIONS
C         : 10 - RAY MISSED SURFACE
C         : 11 - UNDETERMINED ERROR ON INPUT TO RAY INTERSECTION PROGRAM
C         : 12 - UNDETERMINED ERROR IN RAY INTERSECTION PROGRAM
C
C  INPUT VIA LABELED COMMON /PARM/:
C    SURF (9, J) : INNER RADIUS OF CONVENTIONAL SURFACE
C    SURF (10,J) : OUTER RADIUS OF CONV. OR LENGTH OF XRAY SURFACE
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    LSW(2,J) : T - SURFACE DEFORMATIONS, F - NO DEFORMATIONS
C    LSW(3,J) : T - PLANAR SURFACE, F - CONIC SURFACE
!    LSW(5,J) : T - ANNULAR OBSCURATION
!    LSW(6,J) : T - RECTANGULAR OBSCURATION
!    LSW (9, J) : T - XRAY,  F - CONVENTIONAL
C
C  OUTPUT ARGUMENT:
C    KODE : I*4 - CONDITION CODE AS FOLLOWS
C         : -J - INCONSISTENT OR TAUTOLOGICAL DISTANCE EQUATION
C         : 0 < KODE < 5 = SAME AS INPUT.  OTHERWISE , KODE = 10 * J + K
C         WHERE J IS THE SURFACE NUMBER & K IS CODED AS FOLLOWS :
C         : 5 - INNER OR LEFT STOP ERROR
C         : 6 - OUTER OR RIGHT STOP ERROR
C         : 7 - NEGATIVE DISTANCE ERROR
C         : 8 - EXCESSIVE ROUND OFF ERROR
C         : 9 - TOO MANY ITERATIONS ERROR
C         : 10 - RAY MISSED SURFACE ERROR
C         : 11 - UNDETERMINED ERROR ON INPUT TO RAY INTERSECTION PROGRAM
C         : 12 - UNDETERMINED ERROR IN RAY INTERSECTION PROGRAM
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N) 

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays
C
CBUG  KOD = KODE
      IF (MODE .LE. 4 .AND. MODE .GT. 0) GO TO 10
C
C   MODE > 4 OR MODE < 1 : UNEXPLAINED ERROR
      CALL INCLIN (1)
      WRITE (8, 500) MODE, J
      GO TO 95
C
C  SELECT THE CASE USING KODE
C
10    IF (KODE .EQ. MODE) GO TO 40
      IF (KODE .LE. 10 .AND. KODE .GT. 0) GO TO 20
      IF (KODE .EQ. 0) GO TO 30
C
C  CASE 1, UNDETERMINED ERROR WITH KODE
      CALL INCLIN (1)
      WRITE (8, 550) MODE, KODE, J
      GO TO 95
C
C  CASE 2, KODE .NE. MODE :  KODE > 0 AND KODE < 10
C  FAILURE DETECTED BY RAY INTERSECTION PROGRAM
20    KODE = 10 * J + KODE
      GO TO 99
C
C  CASE 2A, KODE .NE. MODE : KODE = 0
30    KODE = -J
      GO TO 99
C
C  CASE 3,  KODE = MODE
C
C  CHECK TO SEE IF THE SURFACE IS PLANAR
40    IF (LSW (3, J)) GO TO 99
C  CHECK TO SEE IF THE SURFACE IS OFF AXIS
      IF (LSW (4, J)) GO TO 99
!  CHECK TO SEE IF THE SURFACE IS AN OBSCURATION
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 99
C  CHECK TO SEE IF IT IS AN X - RAY SURFACE
      IF (LSW (9, J)) GO TO 60
C
C  A CONVENTIONAL SYSTEM, H: = RADIUS  **2, T: = INNER TEST LIMIT
      H = XV (KX) ** 2 + YV (KX) ** 2
      T = SURF (9, J) ** 2
      IF (H .GE. T) GO TO 50
C
C  RAY FAILS INNER RADIUS TEST
      KODE = 10 * J + 5
      GO TO 99
C
C  T: = OUTER TEST LIMIT
50    T = SURF (10, J) ** 2
      IF (H .LE. T) GO TO 99
C  RAY FAILS OUTER RADIUS TEST
      KODE = 10 * J + 6
      GO TO 99
C
C  AN X - RAY SYSTEM, H: = 2 * Z COORDINATE, T: = LENGTH OF S#J
60    H = ZV (KX) + ZV (KX)
      T = SURF (10, J)
      IF (H .GE.  - T) GO TO 70
C
C  RAY FAILS LEFT STOP TEST
      KODE = 10 * J + 5
      GO TO 99
C
70    IF (H .LE. T) GO TO 99
C  RAY FAILS RIGHT STOP TEST
      KODE = 10 * J + 6
      GO TO 99
C
C  RAY SUCCEEDS AT S#J
C
95    STOP 8
99    CONTINUE
CBUG  WRITE (8, 800) J, KX, MODE, KOD, KODE, H, T
      RETURN
500   FORMAT ('- CHEX ERROR : MODE < 1 OR MODE > 10, MODE = ', I10,
     1       '  KODE = ', I10, ' AT S# ', I5)
550   FORMAT ('- CHEX ERROR IN KODE : MODE = ', I10, '   KODE = ', I10,
     1        ' AT S# ', I5)
CBUG800   FORMAT ('-CHEX:  S#',I5,'  KX =',I5,'  MODE =',I5,'  KOD =',
CBUG 1   I5,'  KODE =',I5,/,'  H =',1P,E15.5,'  TEST =',E15.5)
      END
