!+
!KWIC cnvfil.f
!
!$Id: cnvfil.f,v 1.2 2004/03/17 21:23:31 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate formatted io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE CNVFIL (RPUPIL)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    CNVFIL FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: READ THE GX AND CNV FILES; READ THE OPD FILE HEADER AND
C           COUNT THE NUMBER OF GOOD RAYS; WRITE THE HEADER
C           OF THE DEFDAT FILE; AND DO THE PRINT FILE OUTPUT
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (1): R*8 - X-COORD OF PUPIL CENTER
C    GEN (2): R*8 - Y-COORD OF PUPIL CENTER
C
C  OUTPUT PARAMETERS:
C    RPUPIL: R*8 - OUTER RADIUS OF THE DESIRED PUPIL (INNER RADIUS
C                  CAN BE CALCULATED BY MULTIPLYING RPUPIL BY OBSC,
C                  THE LINEAR OBSCURATION RATIO)
C
C  OUTPUT VIA LABELED COMMON /DEFORM/:
C    NDF: I*4 - NUMBER OF ZERNIKE POLYNOMIALS
C    OBSC: R*8 - LINEAR OBSCURATION RATIO
C
C  OUTPUT VIA LABELED COMMON /IDENT/:
C    RID: CHARACTER*4 - ID LINE FROM OPD FILE
C
C  OUTPUT VIA LABELED COMMON /PARX/:
C    KURF: I*4 - CURRENT SURFACE NUMBER (-1)
C
C  OUTPUT VIA LABELED COMMON /RAIN/:
C    JRAY: I*4 - CURRENT RAY NUMBER (LEFT AT TOTAL NUMBER OF
C                RAYS + 1)
C
C  OUTPUT VIA LABELED COMMON /SUMRY/:
C    JAIL2: I*4 - NUMBER OF FAILED RAYS
C    LEFT2: I*4 - NUMBER OF SUCCESSFUL RAYS
C
C  EXTERNAL REFERENCES: GXIN, INCLIN, REHEAD
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N) 
C      CHARACTER*4 GID,RID
C      CHARACTER*4 DFID
C      CHARACTER*8 GDATE , RDATE !*** WERE DOUBLE PRECISION

       include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
       include 'saosacLib/ident.h'

C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2),
C     2               DFID (16)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries

C
C  READ THE 'GX' FILE
C
      CALL GXIN (7, IER)
      IF (IER .NE. 0) GO TO 2000
C
C  COLLECT TEXT, NO. OF ZERNIKE'S, AND PUPIL DATA FROM THE 'CNV' FILE
C
      READ (3, 7000, END = 2100, ERR = 2110) DFID
      READ (3, *, END = 2100, ERR = 2110) NDF, ROBSC, RPUPIL
      IF (NDF .LT. 3 .OR. ROBSC .LT. 0.D0 .OR. RPUPIL .LE. ROBSC)
     *   GO TO 2120
      OBSC = ROBSC / RPUPIL
C
C  SET EXPECTED SURFACE NUMBER + 1 AND READ 'OPD' FILE HEADER
C
      KURF = - 1
      CALL REHEAD (1, -1, IER)
      IF (IER .NE. 0) GO TO 2200
C
C  READ (AND DISCARD) BEST FOCUS, EFL
C
      READ (1, *, END = 2210, ERR = 2220) DUM
C
C  LOOP THROUGH THE OPD FILE TO CHECK FOR LEGALITY AND TO COUNT
C  GOOD AND BAD RAYS
C
      JRAY = 0
      JAIL2 = 0
      LEFT2 = 0
200   JRAY = JRAY + 1
      READ (1, *, END = 2210, ERR = 2220) KRAY, KING, K2, KODE2,
     1                                    IN102
      IF (KRAY .GT. 0) GO TO 240
      IF (KRAY .EQ. (1 - JRAY)) GO TO 400
      JRAY = 1 - JRAY
      GO TO 2300
240   CONTINUE
      IF (KRAY .NE. JRAY) GO TO 2300
      IF (KODE2 .GT. 4) GO TO 300
      READ (1, *, END = 2210, ERR = 2220) DUM
      READ (1, *, END = 2210, ERR = 2220) DUM
      LEFT2 = LEFT2 + 1
      GO TO 200
300   JAIL2 = JAIL2 + 1
      GO TO 200
C
C  REPOSITION THE OPD FILE AT THE FIRST RAY, WHILE READING THE
C  OPD FILE HEADER FOR DISPLAY IN THE PRINT FILE
C
400   REWIND 1
      READ (1, 7010) RID, RDATE, RTIME (1)
C
C  WRITE THE DEFDAT FILE HEADER
C
      WRITE (2, 7020) RID, LEFT2, NDF, OBSC
C
C  WRITE THE CNV FILE TEXT OUT TO THE TERMINAL AND THE PRINT FILE
C
      CALL INCLIN (3)
      WRITE (8, 7030) DFID
C
C  WRITE THE OTHER CNV AND GX FILE DATA, AND RETURN
C
      CALL INCLIN (8)
      WRITE (8, 7040) LEFT2, NDF, ROBSC, RPUPIL, GEN (1), GEN (2)
      RETURN
C
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000) IER
      STOP 8
2100  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8100)
      STOP 8
2110  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8110)
      STOP 8
2120  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8120) NDF, ROBSC, RPUPIL
      STOP 8
2200  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8200) IER
      STOP 8
2210  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8210)
      STOP 8
2220  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8220)
      STOP 8
2300  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8300) KRAY, JRAY
      STOP 8
2310  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8310) K2, J2
      STOP 8
2320  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8320) KING, J
      STOP 8
C
7000  FORMAT (16A4)
7010  FORMAT (1X, 15A4, A1, 1X, A8, 1X, A8 ///)
7020  FORMAT (16A4 / '     1' / 2I6, F9.6)
7030  FORMAT (/ '  HEADER TEXT FROM CNV FILE INPUT:' / 6X, 16A4)
7040  FORMAT (/ '  NUMBER OF RAYS CONVERTED:     ', I6 /
     *          '  NUMBER OF ZERNIKE POLYNOMIALS:', I6 //
     *          '  RADIUS OF INNER PUPIL OBSCURATION:', 1P,D18.10 /
     *          '  OUTER RADIUS OF PUPIL:            ', 1P,D18.10 /
     *          '  X-COORDINATE OF PUPIL CENTER:     ', 1P,D18.10 /
     *          '  Y-COORDINATE OF PUPIL CENTER:     ', 1P,D18.10)
8000  FORMAT ('  CNVFIL - FATAL ERROR', I3, ' READING GX FILE')
8100  FORMAT ('  CNVFIL - FATAL ERROR - UNEXPECTED EOF ON CNV READ')
8110  FORMAT ('  CNVFIL - FATAL ERROR - UNEXPECTED ERR ON CNV READ')
8120  FORMAT ('  CNVFIL - FATAL ERROR IN CNV FILE PARAMETERS:' /
     *        '           (NDF, ROBSC, RPUPIL) =', I6, 1P,2D12.4)
8200  FORMAT ('  CNVFIL - FATAL ERROR', I3, ' READING OPD FILE HEADER')
8210  FORMAT ('  CNVFIL - FATAL ERROR - UNEXPECTED EOF ON OPD READ')
8220  FORMAT ('  CNVFIL - FATAL ERROR - UNEXPECTED ERR ON OPD READ')
8300  FORMAT ('  CNVFIL - FATAL ERROR -' /
     1  '    RAY NUMBER (ENCOUNTERED, EXPECTED) =', 2I6)
8310  FORMAT ('  CNVFIL - FATAL ERROR -' /
     1  '    SPOKE NUMBER (ENCOUNTERED, EXPECTED) =', 2I6)
8320  FORMAT ('  CNVFIL - FATAL ERROR -' /
     1  '    RING NUMBER (ENCOUNTERED, EXPECTED) =', 2I6)
      END
