!+
!KWIC cosum.f
!
!$Id: cosum.f,v 1.2 2004/03/17 21:23:32 dtn Exp $
!
!Revisions:
!   95-Jan-23[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO ALLOW LEGENDRE POLYNOMIALS FROM ORDER 24 (I.E.,
!        !  25 TERMS) TO ORDER 100 (I.E., 101 TERMS)
!        !  (COMMENTS CHANGED WHERE APPROPRIATE, ALSO)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . change DIMENSION to DOUBLE PRECISION
!   93-Oct-15[T. Gaetz]
!      . elminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 5/9/88 TO PRINT THE OBSCURATION RATIO FOR ZERNIKE'S
!  PAUL GLENN, BAUER ASSOICATES, INC.
!
      SUBROUTINE COSUM (ITYPE, NPTS, NDFI, NDFJ, COORD1, COORD2, DFRM,
     1                  WT, CVEC)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    COSUM FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/26/82
C    *
C    *    UPDATE:   03/11/82
C    *    TIME:     02:18:10
C    *
C    ******************************************/
C
C  WRITE SUMMARY REPRT TO # 6 AND # 8
C
C  INPUT PARAMETERS :
C    ITYPE  : I*4 - 1 MEANS CONVENTIONAL SURFACE, ZERNIKE DEFORMATION
C                   2 MEANS X-RAY SURFACE, LEGENDRE-FOURIER DEFORMATION
C                     IN THE ARRAY 'WT' DESCRIBED BELOW
C    NPTS   : I*4 - NUMBER OF DATA POINTS (CURRENT MAX OF 4096)
C    NDFI   : I*4 - TOTAL NUMBER OF LEGENDRE TERMS FOR X-RAY SYSTEM
C                   TOTAL NUMBER OF DEFORMATION COEFF'S FOR CONV. SYSTEM
C    NDFJ   : I*4 - AZIMUTHAL INDEX LIMIT (HIGHEST DEGREE OF FOURIER
C                   TERMS) FOR X-RAY SYSTEM
C                   (NOT USED FOR CONVENTIONAL SYSTEM)
C                   (NOTE: FOR CONV. SYSTEMS, N (# OF COEFF'S)
C                              IS BOUNDED BY 3 .LE. N .LE. 105,
C                              GIVING 14 RADIAL DEGREES OF FREEDOM.
C                          FOR X-RAY SYSTEMS, NDFI IS BOUNDED BY
C                              1 .LE. NDFI .LE. 101, AND
C                              NDF (# OF COEFF'S) = NDFI * (2*NDFJ + 1)
C                              IS BOUNDED BY 1 .LE. 500)
C    COORD1 : R*4 - ARRAY (NPTS) OF X-COORD FOR CONVENTIONAL SYSTEMS, OR
C                                   Z-COORD FOR X-RAY SYSTEMS
C    COORD2 : R*4 - ARRAY (NPTS) OF Y-COORD FOR CONVENTIONAL SYSTEMS, OR
C                                   THETA-COORD FOR X-RAY SYSTEMS
C                   (ASSUMED USER PRE-SCALING CONVENTIONS:
C                    FOR CONVENTIONAL SYSTEMS, X**2 + Y**2 .LE. 1., AND
C                    FOR X-RAY SYSTEMS, -1. .LE. Z .LE. 1., AND
C                                       0. .LE. THETA .LT. 2PI)
C    DFRM   : R*4 - ARRAY (NPTS) OF ACTUAL DEFORMATION DATA VALUES
C                   (SEE OSAC USERS' MANUAL FOR DEFINITION OF
C                   DIRECTION OF POSITIVE DEFORMATION)
C    WT     : R*4 - ARRAY (NPTS) OF WEIGHTING FACTORS FOR EACH POINT
C                   NOTE: IF EQUAL WEIGHTING IS TO BE USED, THEN EACH
C                         WT (J) SHOULD BE SET EQUAL TO 1.0.
C                         OTHERWISE, EACH WT (J) MUST BE POSITIVE.
C    CVEC   : R*4 - ARRAY (NDF) OF FITTED POLYNOMIAL COEFFICIENTS
C
C  INPUT VIA LABELED COMMON /DEFORM/ :
C    NDF : I*4 - NUMBER OF POLYNOMIALS OR COEFFICIENTS
C
C  OUTPUT VIA # 6 AND # 8 :
C    PRINTED INFORMATION ABOUT THE POLYNOMIAL FIT
C
C  XR : INCLIN, POLGEN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      DOUBLE PRECISION COORD1(4096), COORD2(4096), DFRM(4096), 
     &                 WT(4096)

C********************************************************************
C
C CHANGED BY MARK WILSON, NASA/GSFC, ON OCTOBER 2, 1989
C
C OLD STATEMENT:
C     DIMENSION G (105), WSIGI (105), WSGTOT (105), WSGDIF (105)
C
C NEW STATEMENT:
      DIMENSION G (500), WSIGI (500), WSGTOT (500), WSGDIF (500)
C
C********************************************************************

      DIMENSION CVEC (105)
      CHARACTER*4 BLANK
      DATA BLANK /"    "/
C
C
C  INITIALIZE RUNNING SUMS
      WTOT = 0.
      DO 120 I = 1, NDF
      WSIGI (I) = 0.
      WSGTOT (I) = 0.
120   CONTINUE
C
C  CALCULATE VARIOUS RUNNING SUMS FOR ALL POINTS
      DO 200 J = 1, NPTS
      WTOT = WTOT + WT (J)
      WSGDAT = WSGDAT + WT (J) * DFRM (J) * DFRM (J)
      CO1 = COORD1 (J)
      CO2 = COORD2 (J)
      CALL POLGEN (ITYPE, NDFI, NDFJ, CO1, CO2, G)
C
C  DO INNER LOOP OVER POLYNOMIALS
      DEFORM = 0.
      DO 150 I = 1, NDF
      DEFI = CVEC (I) * G (I)
      DEFORM = DEFORM + DEFI
      DIFF = DFRM (J) - DEFORM
      WSGDIF (I) = WSGDIF (I) + WT (J) * DIFF * DIFF
150   CONTINUE
200   CONTINUE
C
C  CALCULATE RUNNING SUMS FOR POLYNOMIAL COEFFICIENTS ALONE
      WNORM = 1.
      DO 300 I = 1, NDF
      IF (ITYPE .EQ. 1) GO TO 270
      L = MOD (I - 1, NDFI)
      WNORM = 1. / (2. * (L + L + 1.))
      IF (I .LE. NDFI) WNORM = WNORM + WNORM
270   WSIGI (I) = WNORM * CVEC (I) * CVEC (I)
300   CONTINUE
      WSGTOT (1) = WSIGI (1)
      DO 320 I = 2, NDF
      WSGTOT (I) = WSIGI (I) + WSGTOT (I - 1)
320   CONTINUE
C
C  WRITE SUMMARY
      CALL INCLIN (14)
      GO TO (400, 420), ITYPE
!  (SHOW THE OBSCURATION FOR ZERNIKE'S)
400   CONTINUE
      WRITE (8, 9000) NDFI, OBSC
      GO TO 450
420   CONTINUE
      WRITE (8, 9010) NDFI, NDFJ, NDF
450   CONTINUE
      SIGSQ = WSGDAT / WTOT
      WRITE (8, 9020) NPTS, SIGSQ
      GO TO (500, 600), ITYPE
C  (DISPLAY NUMBERS FOR ZERNIKE POLYNOMIALS)
500   IP = 0
      MS = 2
      N = 1
520   LNDX = N - 1
      MS = 3 - MS
      MNDX = MS - 3
      CALL INCLIN (N + 1)
      INIT = 1
      DO 560 M = MS, N, 2
      MNDX = MNDX + 2
      IF (M .GT. 1) GO TO 540
      IP = IP + 1
      IF (IP .GT. NDF) GO TO 700
      WRITE (8, 9030) BLANK
      INIT = -1
      SGDIF = WSGDIF (IP) / WTOT
      WRITE (8, 9040) LNDX, CVEC (IP), WSIGI (IP),
     1  WSGTOT (IP), SGDIF
      GO TO 560
540   IP = IP + 1
      IF (IP .GT. NDF) GO TO 700
      IF (INIT .EQ. -1) GO TO 550
      WRITE (8, 9030) BLANK
      INIT = -1
550   SGDIF = WSGDIF (IP) / WTOT
      WRITE (8, 9050) LNDX, MNDX, CVEC (IP), WSIGI (IP),
     1  WSGTOT (IP), SGDIF
      IP = IP + 1
      IF (IP .GT. NDF) GO TO 700
      SGDIF = WSGDIF (IP) / WTOT
      WRITE (8, 9060) LNDX, MNDX, CVEC (IP), WSIGI (IP),
     1  WSGTOT (IP), SGDIF
560   CONTINUE
      N = N + 1
      GO TO 520
C  (DISPLAY NUMBERS FOR LEGENDRE-FOURIER POLYNOMIALS)
600   IP = 0
      CALL INCLIN (NDFI + 1)
      WRITE (8, 9030) BLANK
      DO 620 I = 1, NDFI
      IP = IP + 1
      SGDIF = WSGDIF (IP) / WTOT
      LNDX = I - 1
      WRITE (8, 9040) LNDX, CVEC (IP), WSIGI (IP),
     1  WSGTOT (IP), SGDIF
620   CONTINUE
      IF (NDFJ .EQ. 0) GO TO 700
      DO 650 J = 1, NDFJ
      MNDX = J
      CALL INCLIN (NDFI + 1)
      WRITE (8, 9030) BLANK
      DO 640 I = 1, NDFI
      IP = IP + 1
      SGDIF = WSGDIF (IP) / WTOT
      LNDX = I - 1
      WRITE (8, 9050) LNDX, MNDX, CVEC (IP), WSIGI (IP),
     1  WSGTOT (IP), SGDIF
640   CONTINUE
650   CONTINUE
      DO 670 J = 1, NDFJ
      MNDX = J
      CALL INCLIN (NDFI + 1)
      WRITE (8, 9030) BLANK
      DO 660 I = 1, NDFI
      IP = IP + 1
      SGDIF = WSGDIF (IP) / WTOT
      LNDX = I - 1
      WRITE (8, 9060) LNDX, MNDX, CVEC (IP), WSIGI (IP),
     1  WSGTOT (IP), SGDIF
660   CONTINUE
670   CONTINUE
C
700   RETURN
C
!  (SHOW THE OBSCURATION FOR ZERNIKE'S)
9000  FORMAT (// T25, 'POLYNOMIAL COEFFICIENT SUMMARY' /
     1           T25, '------------------------------' //
     2                '  TYPE OF POLYNOMIALS:', T40, '     ZERNIKE' /
     3                '  # OF POLY''S, OBSCURATION:', T40, I12, F12.6)
9010  FORMAT (// T25, 'POLYNOMIAL COEFFICIENT SUMMARY' /
     1           T25, '------------------------------' //
     2                '  TYPE OF POLYNOMIALS:', T40, '    LEG/FOUR' /
     3                '  # OF POLY''S (LEG, FOUR, TOT):', T40, 3I4)
9020  FORMAT ('  # OF GOOD DATA POINTS:', T40, I12 /
     1        '  SIGMA**2 OF ACTUAL DATA:', T40, 1P,E12.4 ///
     2  T6, 'INDECES', T20, 'COEFFICIENT', T36, 'SIGMA**2 OF',
     3  T52, 'SIGMA**2 OF', T68, 'SIGMA**2 OF' /
     4  T4, 'L MCOS MSIN', T23, 'VALUE', T38, 'POLY #I',
     5  T51, 'POLY''S 1 TO I', T67, 'DATA - POLY''S' /
     6  T4, '-----------', T20, '-----------', T36, '-----------',
     7  T51, '-------------', T67, '-------------')
9030  FORMAT (A4)
9040  FORMAT (I4, 9X, 1P,4E16.4)
9050  FORMAT (2I4, 5X, 1P,4E16.4)
9060  FORMAT (I4, 4X, I4, 1X, 1P,4E16.4)
      END
