!+
!KWIC csout.f
!
!$Id: csout.f,v 1.2 2004/03/17 21:23:32 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
      SUBROUTINE CSOUT (IVS2, IVBCS)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    CSOUT FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/7/88
C    *
C   /******************************************/
C
C  PURPOSE : CONVERT COMPLEX POLARIZATION AMPLITUDE VECTORS TO STD
C
C  INPUT ARGUMENTS:
C    IVS2:  IV# OF OUTGOING UNIT VECTOR
C    IVBCS: IV# OF START OF ROTATION MATRIX FROM STD TO BCS
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    IV# IVS2, IVBCS-TO-(IVBCS+2)
C
C  OUTPUT VIA LABELED COMMON /RAIN/:
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    IV#'S 100-103: C AND S VECTORS IN BCS (INPUT) AND STD (OUTPUT)
C                   (ORDER: RE(C), IM(C), RE(S), IM(S)
C    IV#'S 104-150: RESERVED, DEFINED AS FOLLOWS:
C          104-107: PING PONG BUFFER "B" FOR C AND S
C          108-111: PING PONG BUFFER "C" FOR C AND S
C          112-113: X1 AND Y1 UNIT VECTORS (NOT USED HERE)
C          114-116: T-MATRIX (XY1-STD) (NOT USED HERE)
C          117: PERPENDICULAR UNIT VECTOR (NOT USED HERE)
C          118-119: PARALLEL UNIT VECTORS 1 AND 2 (NOT USED HERE)
C          120-122: (PERPENDICULAR o PERPENDICULAR) (NOT USED HERE)
C          123-125: (PARALLEL#2 o PARALLEL#1) (NOT USED HERE)
C          126-128: REAL PART OF T-MATRIX (REFL IN BCS) (NOT USED HERE)
C          129-131: IMAG PART OF T-MATRIX (REFL IN BCS) (NOT USED HERE)
C          132-134: T-MATRIX (STD-XY2) (OUTPUT)
C
C  XR: MTVMUL, MVMULT, PZXY, VSTOR
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N) 

      include 'saosacLib/rain.h'      ! 
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

C
C  CONVERT THE BCS RESULTS IN BUFFER A TO STD RESULTS IN BUFFER B
C
      DO 120 I = 100, 103
      CALL MTVMUL (IVBCS, I, I + 4)
120   CONTINUE
C
C  DEFINE THE X2 AND Y2 UNIT VECTORS AND THE T-MATRIX (STD-XY2)
C
      CALL PZXY (IVS2, 132, 133)
      CALL VSTOR (134, 0.D0, 0.D0, 0.D0)
C
C  MULTIPLY C AND S BY THIS T-MATRIX, PUTTING THE RESULTS IN BUFFER A
C
      DO 140 I = 100, 103
      CALL MVMULT (132, I + 4, I)
140   CONTINUE
C
C  WRITE C AND S FROM BUFFER A (IV# 100-103) INTO COMMON
C
      C2COMP (1) = DCMPLX (XV (100), XV (101))
      C2COMP (2) = DCMPLX (YV (100), YV (101))
      S2COMP (1) = DCMPLX (XV (102), XV (103))
      S2COMP (2) = DCMPLX (YV (102), YV (103))
      RETURN
      END
