!+
!KWIC dfrmin.f
!
!$Id: dfrmin.f,v 1.2 2004/03/17 21:23:33 dtn Exp $
!
!Revisions:
!   95-Jan-23[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO ALLOW LEGENDRE POLYNOMIALS FROM ORDER 24 (I.E.,
!        !  25 TERMS) TO ORDER 100 (I.E., 101 TERMS)
!        !  (COMMENTS CHANGED WHERE APPROPRIATE, ALSO)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 2/26/92 TO ALLOW 25,000 DATA POINTS
!        !  MARK WILSON, NASA/GSFC
!        !
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . change DIMENSION to DOUBLE PRECISION
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 5/9/88 TO
!    (1) ALLOW THE FULL 500 COEFFICIENTS FOR X-RAY AND 325 FOR
!        ZERNIKE POLYNOMIALS
!    (2) ALLOW UP TO 10,000 FITTED POINTS
!    (3) ALLOW ANNULAR ZERNIKE POLYNOMIALS
!    (4) IMPROVE THE ERROR FLAGGING
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE DFRMIN (GJD, ITYPE, NPTS, NDFI, NDFJ,
     1                   COORD1, COORD2, DFRM, WT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    DFRMIN FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/26/82
C    *
C    *    UPDATE:   03/11/82
C    *    TIME:     02:03:53
C    *
C    ******************************************/
C
C  COLLECT DEFORMATION DATA FROM 'DEFDAT' FILE
C
C  INPUT VIA # 1 :
C    FILE 'DEFDAT' = USER-CREATED FILE OF SURFACE DEFORMATION DATA
C
C  OUTPUT PARAMETERS
C    GJD    : R*8 - 64 CHARACTER USER IDENTIFICATION LINE
C    ITYPE  : I*4 - 1 MEANS CONVENTIONAL SURFACE, ZERNIKE DEFORMATION
C                   2 MEANS X-RAY SURFACE, LEGENDRE-FOURIER DEFORMATION
C                     IN THE ARRAY 'WT' DESCRIBED BELOW
C    NPTS   : I*4 - NUMBER OF DATA POINTS (CURRENT MAX OF 25000)
C    NDFI   : I*4 - TOTAL NUMBER OF LEGENDRE TERMS FOR X-RAY SYSTEM
C                   TOTAL NUMBER OF DEFORMATION COEFF'S FOR CONV. SYSTEM
C    NDFJ   : I*4 - AZIMUTHAL INDEX LIMIT (HIGHEST DEGREE OF FOURIER
C                   TERMS) FOR X-RAY SYSTEM
C                   (NOT USED FOR CONVENTIONAL SYSTEM)
C                   (NOTE: FOR CONV. SYSTEMS, N (# OF COEFF'S)
C                              IS BOUNDED BY 3 .LE. N .LE. 325,
C                              GIVING 14 RADIAL DEGREES OF FREEDOM.
C                          FOR X-RAY SYSTEMS, NDFI IS BOUNDED BY
C                              1 .LE. NDFI .LE. 101, AND
C                              NDF (# OF COEFF'S) = NDFI * (2*NDFJ + 1)
C                              IS BOUNDED BY 1 .LE. 500)
!    OBSC   : R*8 - LINEAR OBSCURATION RATIO FOR ANNULAR ZERNIKE'S
C    COORD1 : R*8 - ARRAY (NPTS) OF X-COORD FOR CONVENTIONAL SYSTEMS, OR
C                                   Z-COORD FOR X-RAY SYSTEMS
C    COORD2 : R*8 - ARRAY (NPTS) OF Y-COORD FOR CONVENTIONAL SYSTEMS, OR
C                                   THETA-COORD FOR X-RAY SYSTEMS
C                   (ASSUMED USER PRE-SCALING CONVENTIONS:
C                    FOR CONVENTIONAL SYSTEMS, X**2 + Y**2 .LE. 1., AND
C                    FOR X-RAY SYSTEMS, -1. .LE. Z .LE. 1.)
C    DFRM   : R*8 - ARRAY (NPTS) OF ACTUAL DEFORMATION DATA VALUES
C                   (SEE OSAC USERS' MANUAL FOR DEFINITION OF
C                   DIRECTION OF POSITIVE DEFORMATION)
C    WT     : R*8 - ARRAY (NPTS) OF WEIGHTING FACTORS FOR EACH POINT
C                   NOTE: IF EQUAL WEIGHTING IS TO BE USED, THEN EACH
C                         WT (J) SHOULD BE SET EQUAL TO 1.0.
C                         OTHERWISE, EACH WT (J) MUST BE POSITIVE.
C
C  OUTPUT VIA LABELED COMMON /DEFORM / :
C    NDF : I*4 - NUMBER OF DEFORMATION POLYNOMIALS OR COEFFICIENTS
C
C  XR : INCLIN
C
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 
 
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs

      DOUBLE PRECISION DFRM (1), WT (1), COORD1 (1), COORD2 (1)
      CHARACTER*4 GJD(16)
C
C
C  READ ID LINE AND DATA TYPE
      READ (1, 9000, END = 2000, ERR = 2010) (GJD (I), I = 1, 16)
      READ (1, *, END = 2000, ERR = 2010) ITYPE
      GO TO (200, 500), ITYPE
      GO TO 2020
C
C  READ REMAINING PARAMETERS FOR CONVENTIONAL SYSTEM
!
!  CHANGE THE READ STATEMENT TO INCLUDE THE OBSCURATION
!200  READ (1, *, END = 2000, ERR = 2010) NPTSIN, NDFI
!
200   READ (1, *, END = 2000, ERR = 2010) NPTSIN, NDFI, OBSC
      IF (NPTSIN .LT. 3) GO TO 2030
      IF (NDFI .LT. 3 .OR. NDFI .GT. 325) GO TO 2040
!  (FOLLOWING CODE IS FOR A NEW ERROR STATEMENT)
      IF (OBSC .LT. 0.D0 .OR. OBSC .GE. 1.D0) GO TO 2045
      NDFJ = 0 
      NDF = NDFI
      NPTS = 0
      NBAD = 0
!  (ALLOW FOR OBSCURATION CHECK)
      OBSCSQ = OBSC * OBSC
      DO 300 J = 1, NPTSIN
      READ (1, *, END = 2000, ERR = 2010) CO1, CO2, DF, W
      RSQ = CO1 * CO1 + CO2 * CO2
!  (CHECK FOR POINT INSIDE ANNULAR OBSCURATION)
!     IF (RSQ .LE. 1. .AND. W .GT. 0.) GO TO 220
      IF (RSQ .LE. 1. .AND. RSQ. GE. OBSCSQ .AND. W .GT. 0.) GO TO 220
      NBAD = NBAD + 1
      GO TO 300
220   NPTS = NPTS + 1
      IF (NPTS .GT. 25000) GO TO 2050
      COORD1 (NPTS) = CO1
      COORD2 (NPTS) = CO2
      DFRM (NPTS) = DF
      WT (NPTS) = W
300   CONTINUE
      GO TO 900
C
C  READ REMAINING PARAMETERS FOR X-RAY SYSTEM
500   READ (1, *, END = 2000, ERR = 2010) NPTSIN, NDFI, NDFJ
      IF (NPTSIN .LT. 1) GO TO 2060
      NDF = NDFI * (NDFJ + NDFJ + 1)
      IF (NDFI .LT. 1 .OR. NDFI .GT. 25 .OR.
     1    NDFJ .LT. 0 .OR. NDF .GT. 500) GO TO 2070
      NPTS = 0
      NBAD = 0
      DO 600 J = 1, NPTSIN
      READ (1, *, END = 2000, ERR = 2010) CO1, CO2, DF, W
      IF (ABS (CO1) .LE. 1. .AND. W .GT. 0.) GO TO 520
      NBAD = NBAD + 1
      GO TO 600
520   NPTS = NPTS + 1
      IF (NPTS .GT. 10000) GO TO 2050
      COORD1 (NPTS) = CO1
      COORD2 (NPTS) = CO2
      DFRM (NPTS) = DF
      WT (NPTS) = W
600   CONTINUE
C
C  CHECK NPTS AND EXIT
!
!  PROVIDE A SEPARATE ERROR STATEMENT FOR NPTS .LT. NDF
!900  IF (NPTS .LT. NDF) GO TO 2060
!
900   IF (NPTS .LT. NDF) GO TO 2080
      IF (NBAD .EQ. 0) GO TO 950
      CALL INCLIN (7)
      WRITE (8, 9050) NPTSIN, NBAD, NPTS
950   RETURN
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000)
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8010)
      STOP 8
2020  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8020) ITYPE
      STOP 8
2030  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8030) NPTSIN
      STOP 8
2040  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8040) NDFI
      STOP 8
!  (FOLLOWING CODE IS FOR A NEW ERROR STATEMENT)
2045  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8045) OBSC
      STOP 8
2050  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8050) J
      STOP 8
2060  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8060) NPTSIN
      STOP 8
2070  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8070) NDFI, NDFJ, NDF
      STOP 8
!  (FOLLOWING CODE IS FOR A NEW ERROR STATEMENT)
2080  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8080) NPTS, NDF
      STOP 8
C
8000  FORMAT ('  DFRMIN - FATAL ERROR - EOF READING DEFDAT FILE')
8010  FORMAT ('  DFRMIN - FATAL ERROR - ERR READING DEFDAT FILE')
8020  FORMAT ('  DFRMIN - FATAL ERROR - ILLEGAL DATA TYPE', I6,
     1        '(MUST = 1 OR 2)')
8030  FORMAT ('  DFRMIN - FATAL ERROR - ILLEGAL # OF PTS FOR ',
     1        'CONV. SYSTEM (3 .LE. NPTS)')
8040  FORMAT ('  DFRMIN - FATAL ERROR - ILLEGAL # OF POLY''S FOR ',
     1        'CONV. SYSTEM (3 .LE. NDF .LE. 325)')
!  (FOLLOWING CODE IS FOR A NEW ERROR STATEMENT)
8045  FORMAT ('  DFRMIN - FATAL ERROR - ILLEGAL OBSCURATION =',
     1        1P,D12.5 / '  (0 .LE. OBSC .LT. 1)')
8050  FORMAT ('  DFRMIN - FATAL ERROR - MAX # OF GOOD DATA POINTS ',
     1        'ENCOUNTERED AFTER POINT #', I5)
8060  FORMAT ('  DFRMIN - FATAL ERROR - ILLEGAL # OF PTS FOR ',
     1        'X-RAY SYSTEM (1 .LE. NPTS)')
8070  FORMAT ('  DFRMIN - FATAL ERROR - ILLEGAL #''S OF ',
     1        'POLY''S FOR X-RAY SYSTEM: NDF(I,J) =', 2I6 /
     2        '  (1 .LE. NDFI .LE. 101, AND 1 .LE. NDF .LE. 500,',
     3        ' WHERE NDF = NDFI * (2*NDFJ + 1)')
!  (FOLLOWING CODE IS FOR A NEW ERROR STATEMENT)
8080  FORMAT ('  DFRMIN - FATAL ERROR - ILLEGAL # OF ',
     1        'GOOD POINTS: (NPTS,NPOLYS) =', 2I6 /
     2        '  (NPTS .GT. NPOLYS)')
9000  FORMAT (16A4)
9010  FORMAT (I6)
9020  FORMAT (2I6)
9030  FORMAT (4E15.0)
9040  FORMAT (3I6)
9050  FORMAT (// T36, 'WARNING' / T36, '-------' //
     1                '  OUT OF', I5, ' INPUT POINTS, THERE WERE', I5,
     2                ' BAD POINTS' / '  (OUT OF RANGE OR NON-POS ',
     3                'WEIGHT), LEAVING', I5, ' GOOD DATA POINTS')
      END
