!+
!KWIC dfrsns.f
!
!$Id: dfrsns.f,v 1.2 2004/03/17 21:23:33 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . reorder /SENS/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE DFRSNS
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    DFRSNS FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: READ IN ALL THE DEFORM (.DFR) AND OPD (.OPD) FILES,
C           AND CALCULATE THE RESULTING SENSITIVITIES
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW (9, KURF) : LOGICAL*1 - XRAY SURFACE SWITCH
C
C  INPUT VIA FILE #7 (.DFR FILES):
C    DEFORM (I.E., ZERNIKE COEFFICIENT) FILES FOR ALL THE
C    CONSTRUCTIONAL CHANGES.  THIS ROUTINE TAKES CARE OF
C    SUCCESSIVELY NAMING, OPENING, AND CLOSING UNIT 7 FOR
C    THESE FILES.
C
C  INPUT VIA FILE #9 (.OPD FILES):
C    OPD FILES FOR ALL THE CONSTRUCTIONAL CHANGES.  THIS ROUTINE
C    TAKES CARE OF SUCCESSIVELY NAMING, OPENING, AND CLOSING
C    UNIT 9 FOR THESE FILES.
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N) 

      CHARACTER DNAME (10), ONAME (10), DPM, OPM, PLUS, MINUS
      CHARACTER * 10 DNAM10, ONAM10
      CHARACTER * 3 CNUM, DNUM, ONUM
      DIMENSION DEFPLU (325), DEFMIN (325)

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      LOGICAL * 1 LSWSAV

      EQUIVALENCE (DNAME, DNAM10), (ONAME, ONAM10)
      EQUIVALENCE (DNAME (3), DPM), (ONAME (3), OPM)
      EQUIVALENCE (DNAME (4), DNUM), (ONAME (4), ONUM)
      DATA DNAM10, ONAM10 /'WF    .DFR', 'WF    .OPD'/
      DATA PLUS, MINUS /'P', 'M'/
C
C
C  LOOP OVER THE CONSTRUCTIONAL CHANGES
C
      NDF0 = NDF
      OBSC0 = OBSC
      KURF = -1
      DO 400 ICH = 1, NCH
C
C  DO THE FILE NAMING AND OPENING FOR THE POSITIVE CHANGE
C
      DPM = PLUS
      OPM = PLUS
      WRITE (CNUM, 7000) ICH
      DNUM = CNUM
      ONUM = CNUM
      OPEN (7, FILE = DNAM10, STATUS = 'UNKNOWN')
      OPEN (9, FILE = ONAM10, STATUS = 'UNKNOWN')
C
C  CHECK THE DEFORM HEADER INFO AND READ THE COEFFICIENTS
!  (TEMPORARILY SET KURF TO 1, AND THE CORRESPONDING X-RAY FLAG TO
!  FALSE, SO THAT THE NEW REDECO WILL ASSUME A CONVENTIONAL 'SURFACE')
C
      KURF = 1
      LSWSAV = LSW (9, KURF)
      LSW (9, KURF) = .FALSE.
      CALL REDECO (7, 0, IER)
      IF (IER .NE. 0) STOP 8
      KURF = -1
      LSW (9, KURF) = LSWSAV
!
      IF (NDF .NE. NDF0 .OR. DABS (OBSC - OBSC0) .GT. 1.D-5) GO TO 2000
      DO 120 IDF = 1, NDF
      DEFPLU (IDF) = DEFC (IDF)
120   CONTINUE
C
C  CHECK THE OPD HEADER AND READ THE BEST FOCUS INFO
C
      CALL REHEAD (9, -1, IER)
      IF (IER .NE. 0) STOP 8
      READ (9, *, END = 2010, ERR = 2020) XBFPLU, YBFPLU
C
C  REPEAT THE ABOVE STEPS FOR THE NEGATIVE CHANGE
C
      CLOSE (7)
      CLOSE (9)
      DPM = MINUS
      OPM = MINUS
      OPEN (7, FILE = DNAM10, STATUS = 'UNKNOWN')
      OPEN (9, FILE = ONAM10, STATUS = 'UNKNOWN')
!
      KURF = 1
      LSWSAV = LSW (9, KURF)
      LSW (9, KURF) = .FALSE.
      CALL REDECO (7, 0, IER)
      IF (IER .NE. 0) STOP 8
      KURF = -1
      LSW (9, KURF) = LSWSAV
!
      IF (NDF .NE. NDF0 .OR. DABS (OBSC - OBSC0) .GT. 1.D-5) GO TO 2000
      DO 140 IDF = 1, NDF
      DEFMIN (IDF) = DEFC (IDF)
140   CONTINUE
      CALL REHEAD (9, -1, IER)
      IF (IER .NE. 0) STOP 8
      READ (9, *, END = 2010, ERR = 2020) XBFMIN, YBFMIN
C
C  CALCULATE THE APPROPRIATE SENSITIVITIES
C
      DO 220 IDF = 1, NDF
      SNSMAT (IDF, ICH) = (DEFPLU (IDF) - DEFMIN (IDF)) /
     *                    (2.D0 * CHGS (ICH))
220   CONTINUE
      XBFSNS (ICH) = (XBFPLU - XBFMIN) / (2.D0 * CHGS (ICH))
      YBFSNS (ICH) = (YBFPLU - YBFMIN) / (2.D0 * CHGS (ICH))
400   CONTINUE
      CLOSE (7)
      CLOSE (9)
      RETURN
C
2000  CONTINUE
      CALL INCLIN (3)
      WRITE (8, 8000) DNAM10, NDF, NDF0, OBSC, OBSC0
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8010)
      STOP 8
2020  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8020)
      STOP 8
C
7000  FORMAT (I3.3)
8000  FORMAT ('  DFRSNS FATAL ERROR IN FILE ', A10 /
     *        '    NDF (INPUT, EXPECTED) =', 2I6 /
     *        '    OBSC (INPUT, EXPECTED) =', 1P,2D14.6)
8010  FORMAT ('  DFRSNS FATAL ERROR - EOF READING OPD FILE')
8020  FORMAT ('  DFRSNS FATAL ERROR - ERROR READING OPD FILE')
      END
