!+
!KWIC dfrsum.f
!
!$Id: dfrsum.f,v 1.2 2004/03/17 21:23:33 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/: add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE DFRSUM
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    DFRSUM FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 12/08/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:06:55
C    *
C    ******************************************/
C
C  WRITE SUMMARY REPORT TO # 6 AND # 8
C
C  INPUT VIA LABELED COMMON /PARM/ :
C    GEN ( 9) : R*8 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R*8 - OUTER RADIUS OF APERTURE ANNULUS
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /SUMRY/ :
C    WS1   : R*8 - TOTAL RAY WEIGHT IN FOCAL PLANE ARRAY
C    WS2   : R*8 - TOTAL SUCCESSFUL RAY WEIGHT
C    LEFT2 : I*4 - NUMBER OF SUCCESSFUL RAYS
C    WX    : R*8 - RUNNING SUM OF W * X COORD. AT FOCAL PLANE
C    WY    : R*8 - RUNNING SUM OF W * Y COORD. AT FOCAL PLANE
C    WXSQ  : R*8 - RUNNING SUM OF W * X**2 AT FOCAL PLANE
C    WYSQ  : R*8 - RUNNING SUM OF W * Y**2 AT FOCAL PLANE
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW0 (1) : I*1 - X-RAY SYSTEM SWITCH
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/
C    V # 10 : BEST FOCUS POSITION = CENTER OF REFERENCE SPHERE
C
C  INPUT VIA LABELED COMMON /IOPRAM/ :
C    FOGR (1) : R*8 - PIXEL ARRAY CENTER X COORD
C    FOGR (2) : R*8 - PIXEL ARRAY CENTER Y COORD
C    FOGR (3) : R*8 - PIXEL ARRAY X LENGTH
C    FOGR (4) : R*8 - PIXEL ARRAY Y LENGTH
C    FOGR (5) : R*8 - NUMBER OF PIXELS IN X DIRECTION
C    FOGR (6) : R*8 - NUMBER OF PIXELS IN Y DIRECTION
C    ZLAM     : R*4 - WAVELENGTH
C    EFL      : R*4 - EFFECTIVE FOCAL LENGTH
C    RA       : R*4 - INNER RADIUS OF ANNULAR APERTURE
C    RB       : R*4 - OUTER RADIUS OF ANNULAR APERTURE
C    WMAX     : R*4 - MAX DISTANCE BTWN BEST FOCUS AND CORNERS OF FP
C    NX       : I*4 - NX = FOGR (5)
C    NY       : I*4 - NY = FOGR (6)
C    NN       : I*4 - NUMBER OF POINTS IN THE FFT ARRAYS
C
C
C  OUTPUT VIA # 6 AND # 8 :
C    POINT SPREAD FUNCTION CALCULATION SUMMARY REPORT
C
C  XR : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /IOPRAM/ FOGR (6), ZLAM, EFL, RA, RB, WMAX, NX, NY, MM, NN
      DOUBLE PRECISION FOGR
      DOUBLE PRECISION XPOS, YPOS, RMSX, RMSY, RMSR
C
C
C  CALCULATE AND WRITE SYSTEM INFORMATION
      CALL INCLIN (16)
      WRITE (8, 8000)
120   NORIG = MING * M2
      IF (GEN (9) .EQ. 0.D0) NORIG = NORIG - M2 + 1
      WRITE (8, 8050) NS, NORIG, LEFT2, WS2, XV (10), YV (10), EFL,
     1  GEN (9), GEN (10)
C
C  CALCULATE AND WRITE RUNTIME INFORMATION
      WAIRY = ZLAM * EFL / (2. * (RB - RA))
      NMAX = INT (4. * WMAX / WAIRY + 1.)
      CALL INCLIN (16)
      WRITE (8, 8060) ZLAM, RA, RB
      WRITE (8, 8070) (FOGR (I), I = 1, 4), NX, NY, NMAX, NN
C
C  CALCULATE AND WRITE IMAGE INFORMATION
      XPOS = WX / WS1
      YPOS = WY / WS1
      RMSX = DSQRT (WXSQ / WS1 - XPOS * XPOS)
      RMSY = DSQRT (WYSQ / WS1 - YPOS * YPOS)
      RMSR = DSQRT (RMSX * RMSX + RMSY * RMSY)
      CALL INCLIN (10)
      WRITE (8, 8080) WS1, XPOS, YPOS, RMSX, RMSY, RMSR
      RETURN
C
8000  FORMAT (/ T16, 'POINT SPREAD FUNCTION SUMMARY REPORT' /
     1          T16, '------------------------------------' //
     2          T20, 'SYSTEM INFORMATION :' /
     3          T20, '--------------------' /)
8050  FORMAT ('  NUMBER OF SURFACES IN SYSTEM :', T40, I12 /
     1        '  NUMBER OF TRACED RAYS :', T40, I12 /
     2        '  NUMBER OF SUCCESSFUL RAYS :', T40, I12 /
     3        '  TOTAL RAY WEIGHT :', T40, F12.5 /
     4        '  X COORD OF REF SPHERE (BEST FOCUS) :', T40, 1P,D12.5 /
     5        '  Y COORD OF REF SPHERE (BEST FOCUS) :', T40, 1P,D12.5 /
     6        '  EFFECTIVE FOCAL LENGTH :', T40, 1P,D12.5 /
     7        '  INNER RADIUS OF TRACED ANNULUS :', T40, 1P,D12.5 /
     8        '  OUTER RADIUS OF TRACED ANNULUS :', T40, 1P,D12.5)
8060  FORMAT (// T20, 'PSF RUNTIME PARAMETERS :' /
     1           T20, '------------------------' //
     2        '  SYSTEM WAVELENGTH :', T40, 1P,E12.5 /
     3        '  INNER RADIUS OF PUPIL ANNULUS :', T40, 1P,E12.5 /
     4        '  OUTER RADIUS OF PUPIL ANNULUS :', T40, 1P,E12.5)
8070  FORMAT ('  PIXEL ARRAY CENTER X COORD :', T40, 1P,D12.5 /
     1        '  PIXEL ARRAY CENTER Y COORD :', T40, 1P,D12.5 /
     2        '  PIXEL ARRAY X LENGTH :', T40, 1P,D12.5 /
     3        '  PIXEL ARRAY Y LENGTH :', T40, 1P,D12.5 /
     4        '  NUMBER OF PIXELS IN X DIRECTION :', T40, 0P,I12 /
     5        '  NUMBER OF PIXELS IN Y DIRECTION :', T40, 0P,I12 /
     6        '  NUMBER OF FFT-IMPLIED PIXELS :', T40, 0P,I12 /
     7        '  NUMBER OF ELEMENTS IN FFT ARRAYS :', T40, 0P,I12)
8080  FORMAT (// T20, 'DIFFRACTION IMAGE INFORMATION :' /
     1           T20, '-------------------------------' /
     2        '  TOTAL WEIGHT IN FOCAL PLANE :', T40, 0P,F12.5 /
     3        '  X COORD OF IMAGE CENTROID :', T40, 1P,D12.5 /
     4        '  Y COORD OF IMAGE CENTROID :', T40, 1P,D12.5 /
     5        '  RMS X-WIDTH OF IMAGE :', T40, 1P,D12.5 /
     6        '  RMS Y-HEIGHT OF IMAGE :', T40, 1P,D12.5 /
     7        '  RMS IMAGE SIZE :', T40, 1P,D12.5)
      END
