!+
!KWIC eeval.f
!
!$Id: eeval.f,v 1.2 2004/03/17 21:23:33 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   95-Mar-21[T. Gaetz]
!      . /PARM/: add save stmt; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO ADD EXPONENTIAL-EXPONENTIAL, EXPONENTIAL-
!        !  GAUSSIAN, AND GAUSSIAN-GAUSSIAN AUTOCOVARIANCE FUNCTIONS, WITH
!        !  EVERY TERM BEING MULTIPLIED BY A COSINE.
!        !  ALSO, CHANGED SINGLE PRECISION CONSTANTS (0., ETC.) TO DOUBLE
!        !  PRECISION TO PROVIDE FUTURE COMPATIBILITY WITH OTHER COMPILERS
!        !  AND SYSTEMS.
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 2/12/90 TO CORRECT DERIVATIVE CALCULATIONS FOR METHODS
!        !  102 AND 104 (EXP(-BR)/SQRT(BR))
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!        !  LORENTZIAN PSD (METHOD 110)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . initialize PI1, PI2, PI3, PI32 with PARAMETER
!-
!
!  UPDATED 2/26/88 TO DISABLE THE REFLECTIVITY EVALUATION,
!  SINCE IT IS NO LONGER USED
!
      SUBROUTINE EEVAL (METH, X, NDER, VAL, VAL1, VAL2, VAL3)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    EEVAL FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/11/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:10:22
C    *
C    ******************************************/
C
C  EVALUATE THE NDER'TH DERIVATIVE OF FUNCTION #METH
C
C  INPUT ARGUMENTS :
C    METH : I*4 - METHOD NUMBER OF FUNCTION
C                 -1                = REFLECTIVITY  !! NO MORE !!
C                 -2                = (1. - EXP (- X)) / X
!                 1-100             = G(V**2) FOR METHOD #METH
!                 101 OR GREATER = PROPORTIONAL TO THE FIRST
!                        DERIVATIVE OF R*G(R) FOR METH #(MOD(METH,100))
!                        AND PROCESS #(INT(METH/100))
!                        (THE PROCESS # IS 1 FOR THE FIRST PROCESS
!                        HAVING A VARIABLE AND TRANSCENDENTAL EXPRESSION
!                        FOR MAXIMIZING R*G(R); 2 FOR THE SECOND SUCH
!                        PROCESS; ETC.  CURRENTLY, THE ONLY SUCH
!                        PROCESSES ARE EXPONENTIALS AND GAUSSIANS
!                        MULTIPLIED BY COSINES, AND THE AUTOCOVARIANCE
!                        FUNCTION FOR A MODIFIED LORENTZIAN PSD.)
!                    IF G (R) = E * EXP (-D * R) * COS (F * R)),
!                       DERIV = (COS FR)(1-DR) + (SIN FR)(-FR)
!                         2ND DERIV = - (COS FR)(D+(F**2)R) +
!                                       (SIN FR)(DFR-2F)
!                    IF G (R) = E * EXP (-D * R**2) * COS (F * R)),
!                       DERIV = (COS FR)(1-2DR**2) + (SIN FR)(-FR)
!                         2ND DERIV = (COS FR)(-(4D+F**2)R) +
!                                     (SIN FR)(2F)(DR**2-1)
!                    IF G (R) CORRESPONDS TO
!                    PSD (F) = const(A) / (F**2 + C**2) ** (B/2),
!                    AND WE DEFINE NU = B/2 - 1
!                              AND Z  = 2 PI C R
!                       DERIV = Z ** NU * K(NU) (Z) -
!                               Z ** (NU + 1) * K(NU-1) (Z)
!                         2ND DERIV = (2 PI C) *
!                                     (-3 * Z ** NU * K(NU-1) (Z) +
!                                     Z ** (NU + 1) * K(NU-2) (Z))
!    X    : R*4 - ARGUMENT: SIN-THETA-GRAZING FOR METH = -1,
!                           X FOR (1.-EXP(-X))/X FOR METH = -2,
!                           V**2 FOR G(V**2) FOR METH = 1-100,
!                           R FOR R*G(R) FOR METH = 101 OR GREATER
C    NDER : I*4 - DERIVATIVE NUMBER (0=FUNCTION, 1=1ST DERIVATIVE)
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : PARAMETERS FOR METHOD #J
C
C  OUTPUT ARGUMENTS :
C    VAL  : R*4 - FUNCTION (OR 1ST DERIVATIVE IF NDER = 1) VALUE
C    VAL1 : R*4 - COMPONENT OF VAL FROM SCATTER PROCESS #1
C                 (VAL1, VAL2, AND VAL3 ARE EVALUATED ONLY IF
C                  0 .LT. METH .LT. 100)
C    VAL2 : R*4 - COMPONENT OF VAL FROM SCATTER PROCESS #2
C    VAL3 : R*4 - COMPONENT OF VAL FROM SCATTER PROCESS #3
C
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      DOUBLE PRECISION PI1
      PARAMETER      ( PI1      = 3.1415 92653 58979 32384 62643 D+0 )
      DOUBLE PRECISION PI2
      PARAMETER      ( PI2      = 2.D0*PI1                           )
      DOUBLE PRECISION PI3
      PARAMETER      ( PI3      = 3.D0*PI1                           )
      DOUBLE PRECISION PI32
      PARAMETER      ( PI32     = 5.5683 27996 83170 78452 84818 D+0 )

      DIMENSION BK (9)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)

      COMMON /SDEFCO/ SDEF (20, 1)
!
!  COMPLEX VARIABLES NO LONGER NEEDED
!      COMPLEX YS, AC, RPLUS, RMINUS, TPLUS, TMINUS, DF, DFVSQ
!      COMPLEX DF1, DFVSQ1, DF2, DFVSQ2
!
!      IF (METH .EQ. -1) GO TO 50
!
      IF (METH .EQ. -2) GO TO 2000
      IF (METH .GT. 100) GO TO 1900
C
C  CHOOSE WHICH POWER SPECTRUM OR DERIVATIVE TO EVALUATE
      NSYS = SDEF (1, METH)
!
!  ALLOW THREE MORE USER METHODS, AND THEN ONE MORE AGAIN
!  (NOTE - THIS ROUTINE IS NEVER CALLED WITH METH=8, WHICH
!  EXPLAINS THE JUMP TO STATEMENT 5000 FOR METH=8)
!        GO TO (100, 200, 300, 400, 500, 600, 700), NSYS
!
        GO TO (100, 200, 300, 400, 500, 600, 700, 5000,
     *         900, 1000, 1100, 1200), NSYS
!
!C
!C  CASE: REFLECTIVITY
!50    YS = CMPLX (DBLE (GEN (5)), DBLE (GEN (6)))
!      STSQ = X * X
!      CTSQ = 1. - STSQ
!      AC = CSQRT (YS - CMPLX(CTSQ) )   !*** 
!      RPLUS = (YS * X - AC) / (YS * X + AC)
!      RMINUS = (X - AC) / (X + AC)
!      IF (NDER .EQ. 1) GO TO 70
!C  (EVALUATE VALUE)
!      VAL = 0.5 * (REAL (RMINUS) * REAL (RMINUS) +
!     1             AIMAG (RMINUS) * AIMAG (RMINUS) +
!     2             REAL (RPLUS) * REAL (RPLUS) +
!     3             AIMAG (RPLUS) * AIMAG (RPLUS))
!      GO TO 5000
!C  (EVALUATE 1ST DERIVATIVE)
!70    TPLUS = YS / (YS * X + AC) ** 2
!      TMINUS = 1. / (X + AC) ** 2
!      VAL = 2. * REAL (CONJG (AC - STSQ / AC) *
!     1  (RPLUS * CONJG (TPLUS) + RMINUS * CONJG (TMINUS)))
!      GO TO 5000
!
C
C  CASE: NSYS = 1 (METHOD #101)
C
100   BV = SDEF (3, METH) * SDEF (3, METH) + X
      DVSQ = SQRT (SDEF (5, METH) * SDEF (5, METH) + X)
      IF (NDER .EQ. 1) GO TO 150
C  (EVALUATE VALUE)
      VAL1 = PI2 * SDEF (2, METH) / BV
      VAL2 = PI2 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 3
      VAL = VAL1 + VAL2
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE)
150   VAL = - PI1 * (2.D0 * SDEF (2, METH) / BV ** 2 +
     1  3. * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 5)
      GO TO 5000
C
C  CASE: NSYS = 2 (METHOD #102)
C
200   IF (X .EQ. 0.D0) GO TO 280
      BSQ = SDEF (3, METH) * SDEF (3, METH)
      BV = BSQ + X
      IF ((X / BSQ) .LT. 1.D-4) GO TO 210
      Z1 = 0.5D0 * (1.D0 - SDEF (3, METH) / SQRT (BV))
      GO TO 220
210   Z1 = 0.25D0 * X / BSQ
      IF (Z1 .LT. 1.D-15) Z1 = 1.D-15
220   ERRMUL = 0.0001D0 * (1.D0 - Z1) / Z1
      DVSQ = SQRT (SDEF (5, METH) * SDEF (5, METH) + X)
      IF (NDER .EQ. 1) GO TO 250
C  (EVALUATE VALUE FOR NON-ZERO X)
      TERMN = -0.75D0 * Z1
      SN = 1.D0 + TERMN
      RN = 1.D0
240   RN = RN + 1.D0
      TERMN = TERMN * ((RN + 0.5D0) * (RN - 1.5D0) / (RN * RN)) * Z1
      SN = SN + TERMN
      IF (ABS (TERMN) .GT. (ERRMUL * SN)) GO TO 240
      VAL1 = PI32 * SDEF (2, METH) * SN /
     1    (SQRT (SDEF (3, METH)) * BV ** 0.75D0)
      VAL2 = PI2 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 3
      VAL = VAL1 + VAL2
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR NON-ZERO X)
250   TERMAN = -0.75D0 * Z1
      TERMBN = 0.625D0 * Z1
!
!  CORRECT SIGN IN DERIVATIVE CALCULATION
!
!      BMULT = -0.25D0 * SDEF (3, METH) / SQRT (BV)
!
      BMULT = +0.25D0 * SDEF (3, METH) / SQRT (BV)
      TERMCN = TERMAN + BMULT * TERMBN
      SN = 1.D0 + BMULT + TERMCN
      RN = 1.D0
260   RN = RN + 1.D0
      TERMAN = TERMAN * ((RN + 0.5D0) * (RN - 1.5D0) / (RN * RN)) * Z1
      TERMBN = TERMBN * ((RN + 1.5D0) * (RN - .5D0) /
     *                  ((RN + 1.D0) * RN)) * Z1
      TERMCN = TERMAN + BMULT * TERMBN
      SN = SN + TERMCN
      IF (ABS (TERMCN) .GT. (ERRMUL * SN)) GO TO 260
      VAL = -0.75D0 * PI32 * SDEF (2, METH) * SN /
     1  (SQRT (SDEF (3, METH)) * BV ** 1.75D0) -
     2  PI3 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 5
      GO TO 5000
280   IF (NDER .EQ. 1) GO TO 290
C  (EVALUATE VALUE FOR ZERO X)
      VAL1 = PI32 * SDEF (2, METH) / SDEF (3, METH) ** 2
      VAL2 = PI2 * SDEF (4, METH) / SDEF (5, METH) ** 2
      VAL = VAL1 + VAL2
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR ZERO X)
!
!  CORRECT THE DERIVATIVE CALCULATION
!
!290   VAL = -0.5625D0 * PI32 * SDEF (2, METH) / SDEF (4, METH) ** 4 -
!     1  PI3 * SDEF (4, METH) / SDEF (5, METH) ** 4
!
290   VAL = -0.9375D0 * PI32 * SDEF (2, METH) / SDEF (3, METH) ** 4 -
     1  PI3 * SDEF (4, METH) / SDEF (5, METH) ** 4
      GO TO 5000
C
C  CASE: NSYS = 3 (METHOD #103)
C
300   BV = SDEF (3, METH) * SDEF (3, METH) + X
      DVSQ = SQRT (SDEF (5, METH) * SDEF (5, METH) + X)
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!      DF = CMPLX (SDEF (5, METH), - SDEF (7, METH))
!      DFVSQ = CSQRT (DF * DF + cmplx(X) ) !***
!
      D = SDEF (5, METH)
      F = SDEF (7, METH)
      DFSQ = DSQRT (D * D + F * F)
      DFV = D * D - F * F + X
      ARGMAG = DFV * DFV + 4.D0 * (D * F) ** 2
      ATN1 = DATAN (- F / D)
      ATN2 = DATAN (- 2.D0 * D * F / DFV)
      IF (NDER .EQ. 1) GO TO 350
C  (EVALUATE VALUE)
      VAL1 = PI2 * SDEF (2, METH) / BV
      VAL2 = PI2 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 3
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!      VAL3 = PI2 * SDEF (6, METH) * REAL (DF / DFVSQ ** 3)
!
      VAL3 = PI2 * SDEF (6, METH) *
     *       DFSQ * ARGMAG ** (-0.75D0) * DCOS (ATN1 - 1.5D0 * ATN2)
      VAL = VAL1 + VAL2 + VAL3
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE)
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!350   VAL = - PI1 * (2.D0 * SDEF (2, METH) / BV ** 2 +
!     1  3.D0 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 5 +
!     2  3.D0 * SDEF (6, METH) * REAL (DF / DFVSQ ** 5))
!
350   VAL = - PI1 * (2.D0 * SDEF (2, METH) / BV ** 2 +
     1  3.D0 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 5 +
     2  3.D0 * SDEF (6, METH) *
     *  DFSQ * ARGMAG ** (-1.25D0) * DCOS (ATN1 - 2.5D0 * ATN2))
      GO TO 5000
C
C  CASE: NSYS = 4 (METHOD #104)
C
!
!  FIRST DO THE (NO-COMPLEX-SQUARE-ROOTS) CALCULATIONS FOR THE
!  EXPONENTIAL-COSINE, REGARDLESS OF X
!400   IF (X .EQ. 0.D0) GO TO 480
!
400   D = SDEF (5, METH)
      F = SDEF (7, METH)
      DFSQ = DSQRT (D * D + F * F)
      DFV = D * D - F * F + X
      ARGMAG = DFV * DFV + 4.D0 * (D * F) ** 2
      ATN1 = DATAN (- F / D)
      ATN2 = DATAN (- 2.D0 * D * F / DFV)
      IF (X .EQ. 0.D0) GO TO 480
!
      BSQ = SDEF (3, METH) * SDEF (3, METH)
      BV = BSQ + X
      IF ((X / BSQ) .LT. 1.D-4) GO TO 410
      Z1 = 0.5D0 * (1.D0 - SDEF (3, METH) / SQRT (BV))
      GO TO 420
410   Z1 = 0.25D0 * X / BSQ
      IF (Z1 .LT. 1.D-15) Z1 = 1.D-15
420   ERRMUL = 0.0001D0 * (1.D0 - Z1) / Z1
      DVSQ = SQRT (SDEF (5, METH) * SDEF (5, METH) + X)
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!      DF = CMPLX (SDEF (5, METH), - SDEF (7, METH))
!      DFVSQ = CSQRT (DF * DF + cmplx(X) ) !***
!
      IF (NDER .EQ. 1) GO TO 450
C  (EVALUATE VALUE FOR NON-ZERO X)
      TERMN = -0.75D0 * Z1
      SN = 1.D0 + TERMN
      RN = 1.D0
440   RN = RN + 1.D0
      TERMN = TERMN * ((RN + 0.5D0) * (RN - 1.5D0) / (RN * RN)) * Z1
      SN = SN + TERMN
      IF (ABS (TERMN) .GT. (ERRMUL * SN)) GO TO 440
      VAL1 = PI32 * SDEF (2, METH) * SN /
     1    (SQRT (SDEF (3, METH)) * BV ** 0.75D0)
      VAL2 = PI2 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 3
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!      VAL3 = PI2 * SDEF (6, METH) * REAL (DF / DFVSQ ** 3)
      VAL3 = PI2 * SDEF (6, METH) *
     *       DFSQ * ARGMAG ** (-0.75D0) * DCOS (ATN1 - 1.5D0 * ATN2)
      VAL = VAL1 + VAL2 + VAL3
      GO TO 5000
C  (CALCULATE 1ST DERIVATIVE FOR NON-ZERO X)
450   TERMAN = -0.75D0 * Z1
!
!  CORRECT SIGN IN DERIVATIVE CALCULATION
!
!      TERMBN = -0.625D0 * Z1
!
      TERMBN = 0.625D0 * Z1
!
!  CORRECT SIGN IN DERIVATIVE CALCULATION
!
!      BMULT = -0.25D0 * SDEF (3, METH) / SQRT (BV)
!
      BMULT = +0.25D0 * SDEF (3, METH) / SQRT (BV)
      TERMCN = TERMAN + BMULT * TERMBN
      SN = 1.D0 + BMULT + TERMCN
      RN = 1.D0
460   RN = RN + 1.D0
      TERMAN = TERMAN * ((RN + 0.5D0) * (RN - 1.5D0) / (RN * RN)) * Z1
      TERMBN = TERMBN * ((RN + 1.5D0) * (RN - .5D0) /
     *                  ((RN + 1.D0) * RN)) * Z1
      TERMCN = TERMAN + BMULT * TERMBN
      SN = SN + TERMCN
      IF (ABS (TERMCN) .GT. (ERRMUL * SN)) GO TO 460
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!      VAL = -0.75D0 * PI32 * SDEF (2, METH) * SN /
!     1  (SQRT (SDEF (3, METH)) * BV ** 1.75D0) -
!     2  PI3 * (SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 5 +
!     3         SDEF (6, METH) * REAL (DF / DFVSQ ** 5))
!
      VAL = -0.75D0 * PI32 * SDEF (2, METH) * SN /
     *      (SQRT (SDEF (3, METH)) * BV ** 1.75D0) -
     *      PI3 * (SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 5 +
     *      SDEF (6, METH) * DFSQ * ARGMAG ** (-1.25D0) *
     *      DCOS (ATN1 - 2.5D0 * ATN2))
      GO TO 5000
480   IF (NDER .EQ. 1) GO TO 490
C  (EVALUATE VALUE FOR ZERO X)
      VAL1 = PI32 * SDEF (2, METH) / SDEF (3, METH) ** 2
      VAL2 = PI2 * SDEF (4, METH) / SDEF (5, METH) ** 2
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!      VAL3 = PI2 * SDEF (6, METH) / REAL (DF ** 2)
      VAL3 = PI2 * SDEF (6, METH) *
     *       DFSQ * ARGMAG ** (-0.75D0) * DCOS (ATN1 - 1.5D0 * ATN2)
      VAL = VAL1 + VAL2 + VAL3
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR ZERO X)
!
!  EVALUATE THE EXPONENTIAL-COSINE WITHOUT COMPLEX SQUARE ROOTS
!490   VAL = -0.5625D0 * PI32 * SDEF (2, METH) / SDEF (3, METH) ** 4 -
!     1  PI3 * (SDEF (4, METH) / SDEF (5, METH) ** 4 +
!     2         SDEF (6, METH) / REAL (DF ** 4))
!
!  CORRECT THE DERIVATIVE CALCULATION
!
!490   VAL = -0.5625D0 * PI32 * SDEF (2, METH) / SDEF (3, METH) ** 4 -
!     1  PI3 * (SDEF (4, METH) / SDEF (5, METH) ** 4 +
!     *  DFSQ * ARGMAG ** (-1.25D0) * DCOS (ATN1 - 2.5D0 * ATN2))
!
!  AND ADD THE MISTAKENLY OMITTED COEFFICIENT OF THE COS TERM
!
490   VAL = -0.9375D0 * PI32 * SDEF (2, METH) / SDEF (3, METH) ** 4 -
     *      PI3 * (SDEF (4, METH) / SDEF (5, METH) ** 4 +
     *      SDEF (6, METH) * DFSQ * ARGMAG ** (-1.25D0) *
     *      DCOS (ATN1 - 2.5D0 * ATN2))
      GO TO 5000
C
C  CASE: NSYS = 5 (METHOD #105)
C
500   BVSQ = SQRT (SDEF (3, METH) * SDEF (3, METH) + X)
      DVSQ = SQRT (SDEF (5, METH) * SDEF (5, METH) + X)
      IF (NDER .EQ. 1) GO TO 550
C  (EVALUATE VALUE)
      VAL1 = PI2 * SDEF (2, METH) * SDEF (3, METH) / BVSQ ** 3
      VAL2 = PI2 * SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 3
      VAL = VAL1 + VAL2
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE)
550   VAL = - PI3 * (SDEF (2, METH) * SDEF (3, METH) / BVSQ ** 5 +
     1  SDEF (4, METH) * SDEF (5, METH) / DVSQ ** 5)
      GO TO 5000
C
C  CASE: NSYS = 6 (METHOD #106)
C
600   VAL1 = PI1 * (SDEF (2, METH) / SDEF (3, METH)) *
     1  EXP (-0.25D0 * X / SDEF (3, METH))
      VAL = VAL1
C  (DONE FOR VALUE - SEE IF MODIFICATION NEEDED FOR 1ST DERIVATIVE)
      IF (NDER .EQ. 1) VAL = -0.25D0 * VAL / SDEF (3, METH)
      GO TO 5000
C
C  CASE: NSYS = 7 (METHOD #201)
C
700   V = SQRT (X)
      IF (V .LT. SDEF (3, METH)) GO TO 780
      NSEGS = SDEF (2, METH)
      DO 720 N = 1, NSEGS
      NDX = 3 * N
      V0COMP = SDEF (NDX + 3, METH)
      IF (V .LT. V0COMP) GO TO 730
720   CONTINUE
730   V0 = SDEF (NDX, METH)
      A = SDEF (NDX + 1, METH)
      B = SDEF (NDX + 2, METH)
      IF (NDER .EQ. 1) GO TO 760
C  (EVALUATE VALUE FOR V NOT IN THE CONSTANT LEG)
      VAL = A * V ** (- B)
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR V NOT IN THE CONSTANT LEG)
760   VAL = -0.5D0 * A * B * V ** (- B)
      GO TO 5000
780   IF (NDER .EQ. 1) GO TO 790
C  (EVALUATE VALUE FOR V IN THE CONSTANT LEG)
790   VAL = SDEF (4, METH) * SDEF (3, METH) ** (- SDEF (5, METH))
      GO TO 5000
C
C  CASE: NSYS = 9 (METHOD #107)
C
900   D = SDEF (3, METH)
      F = SDEF (4, METH)
      DFSQ = DSQRT (D * D + F * F)
      DFV = D * D - F * F + X
      ARGMAG = DFV * DFV + 4.D0 * (D * F) ** 2
      ATN1 = DATAN (- F / D)
      ATN2 = DATAN (- 2.D0 * D * F / DFV)
      IF (NDER .EQ. 1) GO TO 920
C  (EVALUATE VALUE FOR THE FIRST PROCESS)
      VAL1 = PI2 * SDEF (2, METH) *
     *       DFSQ * ARGMAG ** (-0.75D0) * DCOS (ATN1 - 1.5D0 * ATN2)
      GO TO 950
C  (EVALUATE 1ST DERIVATIVE FOR THE FIRST PROCESS)
920   VAL = - PI3 * SDEF (2, METH) *
     *        DFSQ * ARGMAG ** (-1.25D0) * DCOS (ATN1 - 2.5D0 * ATN2)
C  (NOW PROCEDE WITH THE SECOND PROCESS)
950   D = SDEF (6, METH)
      F = SDEF (7, METH)
      DFSQ = DSQRT (D * D + F * F)
      DFV = D * D - F * F + X
      ARGMAG = DFV * DFV + 4.D0 * (D * F) ** 2
      ATN1 = DATAN (- F / D)
      ATN2 = DATAN (- 2.D0 * D * F / DFV)
      IF (NDER .EQ. 1) GO TO 970
C  (EVALUATE VALUE FOR THE SECOND PROCESS)
      VAL2 = PI2 * SDEF (5, METH) *
     *       DFSQ * ARGMAG ** (-0.75D0) * DCOS (ATN1 - 1.5D0 * ATN2)
      VAL = VAL1 + VAL2
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR THE FIRST PROCESS)
970   VAL = VAL - PI3 * SDEF (5, METH) *
     *      DFSQ * ARGMAG ** (-1.25D0) * DCOS (ATN1 - 2.5D0 * ATN2)
      GO TO 5000
C
C  CASE: NSYS = 10 (METHOD #108)
C
1000  D = SDEF (3, METH)
      F = SDEF (4, METH)
      DFSQ = DSQRT (D * D + F * F)
      DFV = D * D - F * F + X
      ARGMAG = DFV * DFV + 4.D0 * (D * F) ** 2
      ATN1 = DATAN (- F / D)
      ATN2 = DATAN (- 2.D0 * D * F / DFV)
      IF (NDER .EQ. 1) GO TO 1050
C  (EVALUATE VALUE FOR THE FIRST PROCESS, ADD THE SECOND)
      VAL1 = PI2 * SDEF (2, METH) *
     *       DFSQ * ARGMAG ** (-0.75D0) * DCOS (ATN1 - 1.5D0 * ATN2)
      CALL GCXFM0 (SDEF (6, METH), SDEF (7, METH), X, G02)
      VAL2 = SDEF (5, METH) * G02
      VAL = VAL1 + VAL2
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR THE FIRST PROCESS, ADD THE SECOND)
1050  VAL = - PI3 * SDEF (2, METH) *
     *        DFSQ * ARGMAG ** (-1.25D0) * DCOS (ATN1 - 2.5D0 * ATN2)
      CALL GCXFM1 (SDEF (6, METH), SDEF (7, METH), X, G12)
      VAL = VAL + SDEF (5, METH) * G12
      GO TO 5000
C
C  CASE: NSYS = 11 (METHOD #109)
C
1100  IF (NDER .EQ. 1) GO TO 1150
C  (EVALUATE VALUE)
      CALL GCXFM0 (SDEF (3, METH), SDEF (4, METH), X, G01)
      CALL GCXFM0 (SDEF (6, METH), SDEF (7, METH), X, G02)
      VAL1 = SDEF (2, METH) * G01
      VAL2 = SDEF (5, METH) * G02
      VAL = VAL1 + VAL2
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE)
1150  CALL GCXFM1 (SDEF (3, METH), SDEF (4, METH), X, G11)
      CALL GCXFM1 (SDEF (6, METH), SDEF (7, METH), X, G12)
      VAL = SDEF (2, METH) * G11 +
     *      SDEF (5, METH) * G12
      GO TO 5000
C
C  CASE: NSYS = 12 (METHOD #110)
C
1200  CON = SDEF (2, METH) * ((SDEF (3, METH) - 2.D0) / PI2) *
     *      SDEF (4, METH) ** (SDEF (3, METH) - 2.D0)
      DTERM = SDEF (4, METH) ** 2 + X / PI2 ** 2
      IF (NDER .EQ. 1) GO TO 1250
C  (EVALUATE VALUE)
      VAL1 = CON / DTERM ** (SDEF (3, METH) / 2.D0)
      VAL = VAL1
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE)
1250  VAL = - (CON * SDEF (3, METH) / (8.D0 * PI1 ** 2)) /
     *        DTERM ** (SDEF (3, METH) / 2.D0 + 1.D0)
      GO TO 5000
C
C  CASE: METH .GT. 100 (FIND 1ST OR 2ND DERIVATIVE OF R*G(R))
C
1900  METH2 = MOD (METH, 100)
      IPROC = IDINT (METH / 100.D0)
!  (CHOOSE THE PROPER NSYS NUMBER, SINCE FOUR NEW ONES HAVE BEEN ADDED)
      NSYS = SDEF (1, METH2)
      GO TO (5000, 5000, 1903, 1904, 5000, 5000, 5000, 5000,
     *       1909, 1910, 1911, 1950), NSYS
!  (NSYS = 3; 1 EXPONENTIAL-COSINE)
1903  D = SDEF (5, METH2)
      F = SDEF (7, METH2)
      GO TO 1930
!  (NSYS = 4; 1 EXPONENTIAL-COSINE)
1904  D = SDEF (5, METH2)
      F = SDEF (7, METH2)
      GO TO 1930
!  (NSYS = 9; 2 EXPONENTIAL-COSINES)
1909  IF (IPROC .EQ. 1) THEN
        D = SDEF (3, METH2)
        F = SDEF (4, METH2)
        GO TO 1930
      ELSE
        D = SDEF (6, METH2)
        F = SDEF (7, METH2)
        GO TO 1930
      ENDIF        
!  (NSYS = 10; 1 EXPONENTIAL-COSINE AND 1 GAUSSIAN-COSINE)
1910  IF (IPROC .EQ. 1) THEN
        D = SDEF (3, METH2)
        F = SDEF (4, METH2)
        GO TO 1930
      ELSE
        D = SDEF (6, METH2)
        F = SDEF (7, METH2)
        GO TO 1940
      ENDIF        
!  (NSYS = 11; 2 GAUSSIAN-COSINES)
1911  IF (IPROC .EQ. 1) THEN
        D = SDEF (3, METH2)
        F = SDEF (4, METH2)
        GO TO 1940
      ELSE
        D = SDEF (6, METH2)
        F = SDEF (7, METH2)
        GO TO 1940
      ENDIF        
!  (D AND F REFER TO EXP(-DR) COS(FR))
1930  IF (NDER .EQ. 1) GO TO 1935
      VAL = DCOS (F * X) * (1.D0 - D * X) -
     *      DSIN (F * X) * F * X
      GO TO 5000
1935  VAL = - DCOS (F * X) * (D + F * F * X) +
     *        DSIN (F * X) * (D * F * X - 2.D0 * F)
      GO TO 5000
!  (D AND F REFER TO EXP(-DR**2) COS(FR))
1940  IF (NDER .EQ. 1) GO TO 1945
      VAL = DCOS (F * X) * (1.D0 - 2.D0 * D * X * X) -
     *      DSIN (F * X) * F * X
      GO TO 5000
1945  VAL = - DCOS (F * X) * X * (4.D0 * D + F * F) +
     *        DSIN (F * X) * 2.D0 * F * (D * X * X - 1.D0)
      GO TO 5000
!  (NSYS = 12; ACV FOR MODIFIED LORENTZIAN PSD)
1950  Z = PI2 * SDEF (4, METH2) * X
      DNU = SDEF (3, METH2) / 2.D0 - 1.D0
      IF (Z .LT. 1.D-6) THEN
        IF (NDER .EQ. 0) THEN
          VAL = 2.D0 ** (DNU - 1.D0) * DGAMMA (DNU)
        ELSE
          VAL = 0.D0
        ENDIF
        GO TO 5000
      ENDIF
      IF (Z .GT. 60.D0) THEN
        VAL = 0.D0
        GO TO 5000
      ENDIF
      IF (NDER .EQ. 1) GO TO 1955
      NIN = 2 + IDINT (DNU)
      XNU = DMOD (DNU, 1.D0) - 1.D0
      IF (DNU .EQ. DFLOAT (IDINT (DNU))) THEN
        NIN = 1 + IDINT (DNU)
        XNU = 0.D0
      ENDIF
      CALL DBESKS (XNU, Z, NIN, BK)
      VAL = Z ** DNU * (BK (NIN) - Z * BK (NIN - 1))
      GO TO 5000
1955  IF (DNU .LT. 2.D0) THEN
        NIN = -2
        XNU = DNU - 1.D0
        IF (DABS (XNU) .LT. 1.D-10) XNU = 1.D-10
        CALL DBESKS (XNU, Z, NIN, BK)
        VAL = (PI2 * SDEF (4, METH2)) * Z ** DNU *
     *        (-3.D0 * BK (1) + Z * BK (2))
      ELSE
        NIN = IDINT (DNU)
        XNU = DMOD (DNU, 1.D0)
        CALL DBESKS (XNU, Z, NIN, BK)
        VAL = (PI2 * SDEF (4, METH2)) * Z ** DNU *
     *        (-3.D0 * BK (NIN) + Z * BK (NIN - 1))
      ENDIF
      GO TO 5000
C
C  CASE: METH = -2 (EVALUATE (1.D0 - EXP (- X)) / X))
C
2000  IF (X .EQ. 0.D0) GO TO 2050
      IF (NDER .EQ. 1) GO TO 2020
C  (EVALUATE VALUE FOR NON-ZERO X)
      VAL = (1.D0 - EXP (- X)) / X
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR NON-ZERO X)
2020  VAL = (EXP (- X) * (1.D0 + X) - 1.D0) / (X * X)
      GO TO 5000
2050  IF (NDER .EQ. 1) GO TO 2070
C  (EVALUATE VALUE FOR ZERO X)
      VAL = 1.D0
      GO TO 5000
C  (EVALUATE 1ST DERIVATIVE FOR ZERO X)
2070  VAL = -0.5D0
      GO TO 5000
5000  RETURN
      END
