!+
!KWIC ffill.f
!
!$Id: ffill.f,v 1.2 2004/03/17 21:23:34 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/: add save stmt; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO FIX BUG THAT PREVENTED CALCULATIONS FOR
!        !  SYSTEMS WITH A TRACED ANNULUS WITH AN INNER RADIUS OF ZERO
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE FFILL (W1, OPD1, ITFLGI)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    FFILL FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 12/07/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:06:26
C    *
C    ******************************************/
C
C  READ THE OPD FILE TO FILL THE PROPER RADIAL ARRAYS
C
C  INPUT/OUTPUT VARIABLES :
C    W1   : R*4 - SQRT (RAY WEIGHT) OF RAY AT THE ORIGIN
C    OPD1 : R*4 - OPD OF RAY AT THE ORIGIN
C    (NOTE : THESE VARIABLES USED ONLY IF GEN (9) = RMIN = 0.)
C
C  OUTPUT VARIABLE :
C    ITFLGI : LOGICAL*1 - .TRUE.  = AT LEAST 1 GOOD RAY IN THIS SPOKE
C                         .FALSE. = NO GOOD RAYS IN THIS SPOKE
C
C  INPUT VIA # 1 :
C    PUPIL OPD INFORMATION FROM 'OPD' FILE
C
C  INPUT VIA LABELED COMMON /PARM/ :
C    GEN (9) : R*8 - INNER RADIUS OF ANNULUS
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C
C  OUTPUT VIA LABELED COMMON /RAIN/ :
C    JRAY : I*4 - RAY NUMBER
C
C  OUTPUT VIA LABELED COMMON /SUMRY/ :
C    WS2   : R*8 - WEIGHT OF SUCCESSFUL RAYS
C    LEFT2 : I*4 - NUMBER OF SUCCESSFUL RAYS
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 1 : PUPIL COORDINATES OF RAY
C    V # 2 : FOCAL PLANE DIRECTION COSINES OF RAY
C
C  OUTPUT VIA LABELED COMMON /RVECTR/ :
C  IF I = RING NUMBER,
C    OPD (I)   : OPD OF POINT IN SPOKE
C    WSQRT (I) : SQRT (RAY WEIGHT) OF POINT IN SPOKE
C
C  XR : INCLIN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
C
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries

      COMMON /RVECTR/ RAD (50), OPD (50), WSQRT (50)
      LOGICAL * 1 ITFLGI
C
C
C  INITIALIZE FLAG FOR NO GOOD DATA POINTS
      ITFLGI = .FALSE.
C
C  DEAL WITH POSSIBLE POINT AT THE ORIGIN
      IF (GEN (9) .NE. 0.D0) GO TO 180
!
!  THE FOLLOWING TEST WAS REVERSED, CAUSING THE BUG MENTIONED 5/17/89
!      IF (J2 .EQ. 1) GO TO 120
      IF (J2 .GT. 1) GO TO 120
      JINC = 0
      GO TO 200
120   JINC = 1
      WSQRT (1) = W1
      OPD (1) = OPD1
      IF (W1 .NE. -1.) ITFLGI = .TRUE.
      GO TO 200
180   JINC = 0
C
C  LOOP OVER EACH RING IN THIS SPOKE
200   JTOP = MING - JINC
      DO 400 J = 1, JTOP
C  (INCREMENT EXPECTED RAYNUMBER AND READ 1ST RECORD FROM 'OPD' FILE)
      JRAY = JRAY + 1
      READ (1, *, END = 2000, ERR = 2010) KRAY, KING, K2, KODE2,
     1                                       IN102
      IF (KRAY .NE. JRAY) GO TO 2020
      IF (K2 .NE. J2) GO TO 2030
      IF (KING .NE. J) GO TO 2040
      IF (KODE2 .GT. 4) GO TO 300
      READ (1, *, END = 2000, ERR = 2010) XV (1), YV(1), ZV (1),
     1                           XV (2), YV (2), ZV (2), OPD (J + JINC)
      WI = 1.E-8 * IN102
      WSQRT (J + JINC) = SQRT (WI)
      WS2 = WS2 + WI
      LEFT2 = LEFT2 + 1
      ITFLGI = .TRUE.
      GO TO 400
300   WSQRT (J + JINC) = -1.
400   CONTINUE
C
C  AFTER SETTING W1 AND OPD1 FOR NEXT ENTRY, EXIT
      W1 = WSQRT (1)
      OPD1 = OPD (1)
      RETURN
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000)
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000)
      STOP 8
2020  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8020) KRAY, JRAY
      STOP 8
2030  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8030) K2, J2
      STOP 8
2040  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8040) KING, J
      STOP 8
C
8000  FORMAT ('  FFILL - FATAL ERROR - UNEXPECTED EOF READING OPD FILE')
8010  FORMAT ('  FFILL - FATAL ERROR - UNEXPECTED ERR READING OPD FILE')
8020  FORMAT ('  FFILL - FATAL ERROR -' /
     1  '    RAY NUMBER (ENCOUNTERED, EXPECTED) =', 2I6)
8030  FORMAT ('  FFILL - FATAL ERROR -' /
     1  '    SPOKE NUMBER (ENCOUNTERED, EXPECTED) =', 2I6)
8040  FORMAT ('  FFILL - FATAL ERROR -' /
     1  '    RING NUMBER (ENCOUNTERED, EXPECTED) =', 2I6)
C9000 FORMAT (5I10)
C9010 FORMAT (1P,3D25.17 / 3F20.17, D20.6)
      END
