!+
!KWIC filchg.f
!
!$Id: filchg.f,v 1.2 2004/03/17 21:23:34 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /PARM/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . reorder /SENS/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE FILCHG (ICH, NLEG0, NFOUR0, NDF0, OBSC0, DEFC0)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    FILCHG FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: CHANGE THE GI AND DEFORM FILES ACCORDING TO THE
C           SPECIFIED CONSTRUCTIONAL CHANGES-OUTPUT THE
C           RESULTS AND ADD TO THE SUMMARY PRINTOUT
C
C  INPUT PARAMETERS:
C    ICH: I*4 - CONSTRUCTIONAL CHANGE NUMBER (1 TO NCH)
C    NLEG0: I*4 - ARRAY OF NLEG VALUES FROM NOMINAL DEFORM FILES
C    NFOUR0: I*4 - ARRAY OF NFOUR VALUES " " " "
C    NDF0: I*4 - ARRAY OF NDF VALUES " " " "
C    OBSC0: R*8 - ARRAY OF OBSC VALUES " " " "
C    DEFC0: R*8 - ARRAYS OF DEFORMATION COEFFICIENTS " " " "
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION NLEG0 (1), NFOUR0 (1), NDF0 (1)
      DIMENSION OBSC0 (1), DEFC0 (500, 1)
      CHARACTER GNAME (10), DNAME (10), GPM, DPM, PLUS, MINUS
      CHARACTER * 10 GNAM10, DNAM10
      CHARACTER * 3 CNUM, GNUM, DNUM
      CHARACTER * 2 SNUM

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      EQUIVALENCE (GNAME, GNAM10), (DNAME, DNAM10)
      EQUIVALENCE (GNAME (3), GPM), (DNAME (3), DPM)
      EQUIVALENCE (GNAME (4), GNUM), (DNAME (4), DNUM)
      EQUIVALENCE (DNAME (9), SNUM)
      DATA GNAM10, DNAM10 /'WF    .GI ', 'WF    .X  '/
      DATA PLUS, MINUS /'P', 'M'/
C
C
C  DETERMINE THE RELEVANT SURFACE AND PARAMETER NUMBERS
C
      IABSCH = IABS (ICHS (ICH))
      KURF = IABSCH / 100
      ITNIDF = MOD (IABSCH, 100)
      IF (ICHS (ICH) .LT. 0) ITNIDF = - ITNIDF
C
C  IF KURF = 0, CHANGE A SYSTEM PARAMETER
C
      IF (KURF .EQ. 0) THEN
        POLD = GEN (ITNIDF)
        GEN (ITNIDF) = POLD + CHGS (ICH)
        PNEW = GEN (ITNIDF)
        GO TO 220
      ENDIF
C
C  IF KURF > 0 AND ITNIDF > 0, CHANGE A SURFACE PARAMETER
C
      IF (KURF .GT. 0 .AND. ITNIDF .GT. 0) THEN
        POLD = SURF (ITNIDF, KURF)
        SURF (ITNIDF, KURF) = POLD + CHGS (ICH)
        PNEW = SURF (ITNIDF, KURF)
        GO TO 220
      ENDIF
C
C  IF KURF > 0 AND ITNIDF < 0, CHANGE A POLYNOMIAL COEFFICIENT
C
      IF (KURF .GT. 0 .AND. ITNIDF .LT. 0) THEN
        POLD = DEFC0 (- ITNIDF, KURF)
        DEFC0 (- ITNIDF, KURF) = POLD + CHGS (ICH)
        PNEW = DEFC0 (- ITNIDF, KURF)
        GO TO 220
      ENDIF
C
C  PRINT THE RESULTS FOR THIS POSITIVE INCREMENT ONLY
C
220   CALL INCLIN (1)
      WRITE (8, 8000) ICH, KURF, ITNIDF, CHGS (ICH), POLD, PNEW
C
C  NAME, OPEN, WRITE, AND CLOSE THE GI FILE
C
      GPM = PLUS
      WRITE (CNUM, 8010) ICH
      GNUM = CNUM
      OPEN (3, FILE = GNAM10, STATUS = 'UNKNOWN')
      CALL WRGI
      CLOSE (3)      
C
C  DITTO FOR ANY REQUIRED DEFORM FILES
C
      DPM = PLUS
      DNUM = CNUM
      DO 240 IS = 1, NS
      IF (.NOT. LSW (2, IS)) GO TO 240
      WRITE (SNUM, 8020) IS
      OPEN (4, FILE = DNAM10, STATUS = 'UNKNOWN')
!     IF (.NOT. LSW0 (1)) WRITE (4, 8030) DFID, NDF0 (IS), OBSC0 (IS)
!     IF (LSW0 (1))       WRITE (4, 8040) DFID, NLEG0 (IS), NFOUR0 (IS)
      IF (.NOT. LSW (9, IS))
     *  WRITE (4, 8030) DFID, NDF0 (IS), OBSC0 (IS)
      IF (LSW (9, IS))
     *  WRITE (4, 8040) DFID, NLEG0 (IS), NFOUR0 (IS)
      WRITE (4, 8050) (DEFC0 (L, IS), L = 1, NDF0 (IS))
      CLOSE (4)
240   CONTINUE
C
C  REPEAT THE ABOVE STEPS FOR THE NEGATIVE CHANGE
C
      IF (KURF .EQ. 0)
     *   GEN (ITNIDF) = POLD - CHGS (ICH)
      IF (KURF .GT. 0 .AND. ITNIDF .GT. 0)
     *   SURF (ITNIDF, KURF) = POLD - CHGS (ICH)
      IF (KURF .GT. 0 .AND. ITNIDF .LT. 0)
     *   DEFC0 (- ITNIDF, KURF) = POLD - CHGS (ICH)
C
      GPM = MINUS
      OPEN (3, FILE = GNAM10, STATUS = 'UNKNOWN')
      CALL WRGI
      CLOSE (3)      
C
      DPM = MINUS
      DO 260 IS = 1, NS
      IF (.NOT. LSW (2, IS)) GO TO 260
      WRITE (SNUM, 8020) IS
      OPEN (4, FILE = DNAM10, STATUS = 'UNKNOWN')
!     IF (.NOT. LSW0 (1)) WRITE (4, 8030) DFID, NDF0 (IS), OBSC0 (IS)
!     IF (LSW0 (1))       WRITE (4, 8040) DFID, NLEG0 (IS), NFOUR0 (IS)
      IF (.NOT. LSW (9, IS))
     *  WRITE (4, 8030) DFID, NDF0 (IS), OBSC0 (IS)
      IF (LSW (9, IS))
     *  WRITE (4, 8040) DFID, NLEG0 (IS), NFOUR0 (IS)
      WRITE (4, 8050) (DEFC0 (L, IS), L = 1, NDF0 (IS))
      CLOSE (4)
260   CONTINUE
C
C  RESET THE CHANGED PARAMETER AND RETURN
C
      IF (KURF .EQ. 0)
     *   GEN (ITNIDF) = POLD
      IF (KURF .GT. 0 .AND. ITNIDF .GT. 0)
     *   SURF (ITNIDF, KURF) = POLD
      IF (KURF .GT. 0 .AND. ITNIDF .LT. 0)
     *   DEFC0 (- ITNIDF, KURF) = POLD
      RETURN
C
8000  FORMAT (I6, I8, I10, 1P,D17.4, 1P,2D16.8)
8010  FORMAT (I3.3)
8020  FORMAT (I2.2)
8030  FORMAT (16A4, 1X, I5, F9.6)
8040  FORMAT (16A4, 1X, 2I5)
8050  FORMAT (1P,5D15.5)
      END
