!+
!KWIC fovel.f
!
!$Id: fovel.f,v 1.2 2004/03/17 21:23:34 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   95-Mar-21[T. Gaetz]
!      . /PARM/: add save stmt; move to include file
!   93-Oct-05[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output
!-

!
!  UPDATED 5/9/88 TO EXCLUDE CHANCE OF SQRT(NEG) NUMERICAL PROBLEMS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE FOVEL (AC, P, SPOT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    FOVEL FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 02/20/80
C    *
C    *    UPDATE:   01/22/82
C    *    TIME:     14:46:14
C    *
C    ******************************************/
C
C  FIND FOCUS & SPOT SIZE OF A COLLECTION OF RAYS
C  USED IN CONJUNCTION WITH VFOCUS (Q.V.)
C
C  INPUT PARAMETERS :
C
C  AC    : R*8 ARRAY OF COEFFICIENTS AS DEFINED BY VFOCUS
C
C  INPUT VIA / PARM / :
C  GEN (3) : R*8 - ZOFF - Z OFFSET OF FOCAL PLANE
C
C  OUTPUT PARAMETERS :
C
C  P     : R*8 GLOBAL OPTIMAL FOCUS OF THE RAY COLLECTION  WRT GFOC
C  SPOT  : R*4 RMS SPOT SIZE AT THE ABOVE FOCUS
C
C  OUTPUT VIA # 6 & # 8 :
C     PLANAR & GLOBAL OPTIMAL FOCI  OF THE RAY COLLECTION  WRT GFOC
C     WITH THEIR RESPECTIVE RMS SPOT SIZES
C
C  OUTPUT VIA #8:
C     AC  : R*8 ARRAY OF COEFFICIENTS OF QUADRATIC FOCUS FUNCTION
C
C  SUBPROGRAMS REQUIRED : LINV3P, VFOCUS
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)

      DOUBLE PRECISION  AC(10), BC(10), P(3)
      DOUBLE PRECISION A11,A12,A21,A22,B1,B2,DETDEN,DET,XX,YY,UU,VV,WW
      DOUBLE PRECISION AA, BB, CC, DD  !*** VARIABLES ADDED 
C
C  WRAY  : TOTAL WEIGHT OF RAYS IN THE COLLECTION
C
      DET (AA, BB, CC, DD) = AA * DD - BB * CC
      WRAY = 0.5D0 * (AC (1) + AC (3) + AC (6))
      write( 8, * ) ' enter fovel'
      DO 10 I  =  1,  10
10    BC (I) = AC (I)
      A11 = AC (1)
      A12 = AC (2)
      A21 = AC (2)
      A22 = AC (3)
      B1 = AC (7) - AC (4) * GEN (3)
      B2 = AC (8) - AC (5) * GEN (3)
      DETDEN = DET (A11, A12, A21, A22)
      XX = DET (B1, A12, B2, A22) / DETDEN
      YY = DET (A11, B1, A21, B2) / DETDEN
      UU = AC(1)*XX + AC(2)*YY + AC(4)*GEN(3) - (AC(7)+AC(7))
      VV = AC(2)*XX + AC(3)*YY + AC(5)*GEN(3) - (AC(8)+AC(8))
      WW = AC(4)*XX + AC(5)*YY + AC(6)*GEN(3) - (AC(9)+AC(9))
      PHI = XX * UU + YY * VV + GEN (3) * WW + AC (10)
!
!  FORGET NEGATIVE VALUES TO AVOID ROUNDOFF WORRIES
      PHI = DMAX1 (0.D0, PHI)
!
      SPOT = DSQRT (PHI / WRAY)
C
      CALL INCLIN (20)
      WRITE (8, 700)
      WRITE (8, 777) WRAY, XX, YY, GEN (3), SPOT
C
      P (1) = AC (7)
      P (2) = AC (8)
      P (3) = AC (9)
      CALL LINV3P (BC, P, 2, 3, IER)
      IF (IER .EQ. 0) GO TO 70
      CALL INCLIN (3)
      WRITE (8, 660)
70    PHI  = AC(10) - (AC(7)*P(1) + AC(8)*P(2) + AC(9)* P(3))
!
!  FORGET NEGATIVE VALUES TO AVOID ROUNDOFF WORRIES
      PHI = DMAX1 (0.D0, PHI)
!
      IF (PHI .GT. 0.0) GO TO 80
      SPOT = 0.0
      IF (-PHI .LE. 0.001 * DBLE (AC (10))) GO TO 90
      CALL INCLIN (3)
      WRITE (8, 670) PHI, AC (10)
      GO TO 90
80    SPOT = DSQRT (PHI / WRAY)
C
90    continue
      WRITE (8, 720)
      WRITE (8, 777) WRAY, P, SPOT
      RETURN
C
660   FORMAT (// ' ERROR FOVEL : MATRIX NOT POS')
670   FORMAT (// ' ERROR FOVEL : NEG SPOT',  1P, 2D20.12)
700   FORMAT (// 31X, 'PLANAR OPTIMAL FOCUS' / 31X, 20(1H-))
720   FORMAT (// 31X, 'GLOBAL OPTIMAL FOCUS' / 31X, 20(1H-))
777   FORMAT (/ 12X,'SUM', T34,'X', T54,'Y', T72,'Z', T91,'SPOT' /
     &  10X,'WEIGHTS', 2(12X, 'LOCATION'), T70, 'PLANE', T91,'SIZE' /
     &  1P,5D20.12)
      END
