!+
!KWIC fplamp.f
!
!$Id: fplamp.f,v 1.2 2004/03/17 21:23:35 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO ADD EXPONENTIAL-EXPONENTIAL, EXPONENTIAL-
!        !  GAUSSIAN, AND GAUSSIAN-GAUSSIAN AUTOCOVARIANCE FUNCTIONS, WITH
!        !  EVERY TERM BEING MULTIPLIED BY A COSINE
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!        !  LORENTZIAN PSD (METHOD 110)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
      SUBROUTINE FPLAMP (STRFAC)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    FPLAMP FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/20/88
C    *
C   /******************************************/
C
C  PURPOSE: IMPLEMENT THE LARGE AMPLITUDE BECKMANN SCATTERING
C           THEORY FOR THE CURRENT RAY AND FOR ALL SURFACES IN
C           THE SYSTEM
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 5 : R*8 - FOCAL PLANE INTERSECTION POSITION VECTOR
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZK : R*4 - SYSTEM WAVENUMBER
C    DP0 (I) : ARRAY OF SINS OF GRAZING ANGLES
C    SFX,SFY,TFX,TFY (I) : ARRAYS OF SUSEQ SCALE FACTORS
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - ARRAY OF SCATTER DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    FOGR (I) : R*4 - ARRAY OF FOCAL PLANE ARRAY DEFINITION PARAMETERS
C    SIGSQ (I, J) : R*4 - ARRAY OF VALUES OF SIGMA ** 2
C
C  INPUT VIA DATA VALUES :
C    CON1 : R*8 - MULTIPLIER OF MIN EXP CORR LENGTH TO GET RMIN
C    CON2 : R*8 - MULTIPLIER OF MIN GAUSSIAN CORR LENGTH TO GET RMIN
C    CON3 : R*8 - MULTIPLIER OF MAX EXP CORR LENGTH TO GET RMAX
C    CON4 : R*8 - MULTIPLIER OF MAX GAUSSIAN CORR LENGTH TO GET RMAX
C    CON5 : R*8 - MULTIPLIER OF RMIN TO GET FRAD0
C    CON6 : R*8 - RATIO BETWEEN SUCCESSIVE FILTER RADII
!    CON7 : R*8 - MULTIPLIER OF (1/F0) TO GET RMIN FOR MOD-LORENTZ
!    CON8 : R*8 - MULTIPLIER OF (1/F0) TO GET RMAX FOR MOD-LORENTZ
C
C  OUTPUT PARAMETER:
C    STRFAC: R*8 - STREHL FACTOR OF THE LEFT OVER SPECULAR RAY
C                  (THIS DOES NOT INCLUDE REFLECTIVITY)
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    NCALC2 (I, J) : I*4 - NUMBER OF RAY-SURFACE CALCULATIONS PERFORMED
C                          USING FULL LARGE AMPLITUDE SCATTER THEORY
C
C  OUTPUT VIA LABELED COMMON /FPGRCO/ :
C    FPGRID (I) : R*4 - ARRAY OF FOCAL PLANE PIXELS
C
C  XR: FLXFRM, SXFRM
C
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      EXTERNAL SXFRM
C
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /FPGRCO/ FPGRID (1)
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DATA CON1, CON2, CON3, CON4, CON5, CON6
     *     /.04D0, .04D0, 1.D0, 1.D0, 6.25D0, 1.5D0/
      DATA CON7, CON8 /0.04D0, 1.D0/
C
C
C  START BY LOOPING OVER THE SURFACES TO FIND MIN/MAX CORR LENGTHS,
C  REFLECTIVITIES, AND STREHL RATIOS
C
      RMIN = 1.D30
      RMAX = 0.D0
      STRFAC = 1.D0
      DO 800 I = 1, NS
      KURF = I
C
C  SKIP THE SURFACE IF THERE IS NO SCATTER, INCREMENT COUNT IF THERE IS
C
      METH = METARR (KURF)
!
!  SINCE WE ARE IN THE LARGE AMPLITUDE ROUTINE, METH AT THIS POINT
!  MUST BE EITHER ZERO (CORRESPONDING TO NO SCATTER), OR A VALUE
!  CORRESPONDING TO A DEFINITION THAT ALLOWS LARGE AMPLITUDE SCATTER.
!  IF METH IS NOT ZERO, THEN THE DEFINITION NUMBER (NSYS) WILL BE ONE
!  OF THE FOLLOWING:
!    NSYS =  5; TWO EXPONENTIALS
!    NSYS =  6; ONE GAUSSIAN
!    NSYS =  9; TWO EXPONENTIAL-COSINES
!    NSYS = 10; ONE EXPONENTIAL-COSINE AND ONE GAUSSIAN-COSINE
!    NSYS = 11; TWO GAUSSIAN-COSINES
!    NSYS = 12; ACV FOR MODIFIED LORENTZIAN PSD
!
      IF (METH .EQ. 0) GO TO 800
      NCALC2 (METH, KURF) = NCALC2 (METH, KURF) + 1
C
C  DEFINE (VZ**2 * SIGMA**2) AND STREHL FOR THE CURRENT SURFACE
C
      NSYS = SDEF (1, METH)
      CTH = DP0 (KURF)
      VZSQ = 4.D0 * ZK * ZK * CTH * CTH
!
!  USE A DIFFERENT APPROACH TO GET SIGMA**2
!      SGSQ = SDEF (2, METH)
!      IF (NSYS .EQ. 5) SGSQ = SGSQ + SDEF (4, METH)
!
      SGSQ = SIGSQ (1, METH) + SIGSQ (2, METH) + SIGSQ (3, METH)
      VZSSQ = VZSQ * SGSQ
      STREHL = 0.D0
      IF (VZSSQ .LT. 40.D0) STREHL = DEXP (- VZSSQ)
C
C  DEFINE THE EFFECTIVE SHRINKING FACTOR OF THE SCATTER TRANSFORM
C  FOR THE LARGE AMPLITUDE CASE
!  (BECAUSE OF THE NEW EXP/GAUSS MODELS, USE TWO SEPARATE FACTORS,
!  ONE FOR EXPONENTIALS AND ONE FOR GAUSSIANS)
!      FACTOR = DSQRT (1.D0 + VZSSQ * VZSSQ)
!      IF (NSYS .EQ. 6) FACTOR = DSQRT (FACTOR)
!
      FACTE = DSQRT (1.D0 + VZSSQ * VZSSQ)
      FACTG = DSQRT (FACTE)
!
!  FOR THE ACV FOR MODIFIED LORENTZIAN PSD'S, USE THE SAME AS FOR
!  EXPONENTIALS
!
      FACTL = FACTE
C
C  UPDATE THE MIN/MAX CORR LENGTHS
C
150   RCEMIN = 1.D30
      RCEMAX = 0.D0
      RCGMIN = 1.D30
      RCGMAX = 0.D0
      RCLMIN = 1.D30
      RCLMAX = 0.D0
C  (DOUBLE-PROCESS EXPONENTIAL AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 5) THEN
        IF ((SDEF (2, METH) / SGSQ) .LT. 1.D-8) GO TO 210
        RCEMIN = (1.D0 / SDEF (3, METH)) / FACTE
        RCEMAX = RCEMIN
210     IF ((SDEF (4, METH) / SGSQ) .LT. 1.D-8) GO TO 320
        RCEMIN = DMIN1 (RCEMIN, (1.D0 / SDEF (5, METH)) / FACTE)
        RCEMAX = DMAX1 (RCEMAX, (1.D0 / SDEF (5, METH)) / FACTE)
        GO TO 320
      ENDIF
C  (SINGLE-PROCESS GAUSSIAN AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 6) THEN
        RCGMIN = (1.D0 / DSQRT (SDEF (3, METH))) / FACTG
        RCGMAX = RCGMIN
        GO TO 320
      ENDIF
C  (DOUBLE-PROCESS EXPONENTIAL-COSINE AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 9) THEN
        IF ((SDEF (2, METH) / SGSQ) .LT. 1.D-8) GO TO 220
        RCEMIN = (1.D0 / SDEF (3, METH)) / FACTE
        RCEMAX = RCEMIN
220     IF ((SDEF (5, METH) / SGSQ) .LT. 1.D-8) GO TO 320
        RCEMIN = DMIN1 (RCEMIN, (1.D0 / SDEF (6, METH)) / FACTE)
        RCEMAX = DMAX1 (RCEMAX, (1.D0 / SDEF (6, METH)) / FACTE)
        GO TO 320
      ENDIF
C  (DOUBLE-PROCESS EXPONENTIAL-COSINE / GAUSSIAN-COSINE 
C  AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 10) THEN
        IF ((SDEF (2, METH) / SGSQ) .LT. 1.D-8) GO TO 230
        RCEMIN = (1.D0 / SDEF (3, METH)) / FACTE
        RCEMAX = RCEMIN
230     IF ((SDEF (5, METH) / SGSQ) .LT. 1.D-8) GO TO 320
        RCGMIN = (1.D0 / DSQRT (SDEF (6, METH))) / FACTG
        RCGMAX = RCGMIN
        GO TO 320
      ENDIF
C  (DOUBLE-PROCESS GAUSSIAN-COSINE AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 11) THEN
        IF ((SDEF (2, METH) / SGSQ) .LT. 1.D-8) GO TO 240
        RCGMIN = (1.D0 / DSQRT (SDEF (3, METH))) / FACTG
        RCGMAX = RCGMIN
240     IF ((SDEF (5, METH) / SGSQ) .LT. 1.D-8) GO TO 320
        RCGMIN = DMIN1 (RCGMIN, (1.D0 / DSQRT (SDEF (6, METH))) / FACTG)
        RCGMAX = DMAX1 (RCGMAX, (1.D0 / DSQRT (SDEF (6, METH))) / FACTG)
        GO TO 320
      ENDIF
C  (SINGLE-PROCESS AUTOCOVARIANCE FUNCTION FOR LORENTZIAN PSD)
      IF (NSYS .EQ. 12) THEN
        RCLMIN = (1.D0 / DSQRT (SDEF (4, METH))) / FACTL
        RCLMAX = RCLMIN
        GO TO 320
      ENDIF
C
C  SELECT THE MIN/MAX FROM THE EXPONENTIAL / GAUSSIAN / LORENTZIAN
C  TYPES (THE NUMERICAL CONSTANTS IN THE FOLLOWING STATEMENTS
C  HAVE BEEN EMPIRICALLY OPTIMIZED FOR GREATEST ACCURACY AND
C  SHORTEST CALCULATION TIME)
!320   RMINKF = DMIN1 (CON1 * RCEMIN, CON2 * RCGMIN)
!      RMAXKF = DMAX1 (CON3 * RCEMAX, CON4 * RCGMAX)
!
320   RMINKF = DMIN1 (CON1 * RCEMIN, CON2 * RCGMIN, CON7 * RCLMIN)
      RMAXKF = DMAX1 (CON3 * RCEMAX, CON4 * RCGMAX, CON8 * RCLMAX)
C
C  CHANGE THE MIN/MAX BY THE MIN/MAX OF THE INVERSE OF THE
C  MATRIX THAT WILL MULTIPLY THE CORRELATION FUNCTION ARGUMENT
C  DURING EVALUATION.
C
      DETSQR = DSQRT (DABS (TFX (KURF) * SFY (KURF) -
     *                      SFX (KURF) * TFY (KURF)))
      RMINKF = RMINKF * CTH / (ZLAM * DETSQR)
      RMAXKF = RMAXKF * CTH / (ZLAM * DETSQR)
      RMIN = DMIN1 (RMIN, RMINKF)
      RMAX = DMAX1 (RMAX, RMAXKF)
C
C  UPDATE THE CUMULATIVE STREHL FACTOR
C
      STRFAC = STRFAC * STREHL
800   CONTINUE
C
C  DEFINE FRAD0 AND RATIO, THE FINAL CALLING PARAMETERS FOR FLXFRM,
C  BY USING CON5 AND CON6 (EMPIRICALLY OPTIMIZED FOR GREATEST
C  ACCURACY AND SHORTEST CALCULATION TIME)
C
      FRAD0 = CON5 * RMIN
      RATIO = CON6
C
C  DEFINE THE SIMPLE DIMENSIONAL AND SCALING CONSTANTS
C
      NX = FOGR (5)
      NY = FOGR (6)
      DXOUT = FOGR (3) / NX
      DYOUT = FOGR (4) / NY
      X0OUT = FOGR (1) + DXOUT * (1.D0 - NX) / 2.D0 - XV (5)
      Y0OUT = FOGR (2) + DYOUT * (1.D0 - NY) / 2.D0 - YV (5)
      CON = DXOUT * DYOUT
C
C  CALL THE ROUTINE TO INCREMENT THE FOCAL PLANE, AND RETURN
C
      CALL FLXFRM (SXFRM, RMIN, RMAX, FRAD0, RATIO,
     *             FPGRID, NX, NX, NY,
     *             X0OUT, Y0OUT, DXOUT, DYOUT, CON)
      RETURN
      END
