!+
!KWIC fpstat.f
!
!$Id: fpstat.f,v 1.2 2004/03/17 21:23:35 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO CHANGE CALL TO EEVAL WHEN USING METH=201 TO
!        !  METH=-2, SO THAT EEVAL CAPABILITIES CAN BE EXPANDED.
!        !  ALSO, ADDED FIVE MORE ENTRIES TO THE NCOMP TABLE TO ACCOMMODATE
!        !  THE NEW EXPONENTIAL-COSINE AND GAUSSIAN-COSINE CAPABILITIES.
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 2/19/90 TO PROVIDE NUMERICAL OVERFLOW PROTECTION WHEN
!        !  USING METHODS 102 AND 104 (EXP(BR)/SQRT(BR)) WITH TOO-SMALL B
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!        !  LORENTZIAN PSD (METHOD 110)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-22[T. Gaetz]
!      . reorganize declarations to comment out variables (currently not
!        used but appearing in commented-out code): 
!        rsq, h0, hj, dp, dpb, dpc, nr, nrold, nrbas, it3flg, irflg2, irflg
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/20/88 TO STOP RECALCULATING REFLECTIVITY AND GEOMETRIC
!  FACTORS ACROSS THE FOCAL PLANE, AND TO MAKE THE CALCULATIONS
!  MORE ROBUST FOR VARIOUS NUMERICAL INPUT VALUES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 2/26/88 TO CHANGE MAX VZ**2*SIG**2 DEFINITION TO BE THE TOTAL
!  FOR ALL PROCESSES IN A GIVEN DEFINITION, RATHER THAN THE
!  MAXIMUM OF ANY SINGLE PROCESS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!      SUBROUTINE FPSTAT (IRFLG, METH, V2, EN, EN1, EN2, EN3,
!     1                  SI, RSQ, VZS, FVS, STR) !*** SLASHES TAKEN OUT
!
      SUBROUTINE FPSTAT (METH, V2, EN, EN1, EN2, EN3,
     1                  SI, VZS, FVS, STR) !*** SLASHES TAKEN OUT
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    FPSTAT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/21/81
C    *
C    *    UPDATE:   03/18/82
C    *    TIME:     09:20:00
C    *
C    ******************************************/
C
C  UPDATE FOCAL PLANE ARRAY AND STREHL FACTOR FOR STATISTICAL SURFACE
C
C  INPUT PARAMETERS :
C    METH    : I*4 - SCATTER DEFINITION NUMBER
C    V2 (I)  : R*4 - ARRAY OF V**2 VALUES FOR TABLE LOOK-UP
C    EN (I)  : R*4 - ARRAY OF G (V**2) VALUES FOR TABLE LOOK-UP
C    EN1 (I) : R*4 - ARRAY OF PROCESS # 1 COMPONENTS OF EN (I)
C    EN2 (I) : R*4 - ARRAY OF PROCESS # 2 COMPONENTS OF EN (I)
C    EN3 (I) : R*4 - ARRAY OF PROCESS # 3 COMPONENTS OF EN (I)
C    SI (I)  : R*4 - ARRAY OF SIN-THETA VALUES FOR TABLE LOOK-UP
C    RSQ (I) : R*4 - ARRAY OF REFL (SIN-THETA) VALUES FOR TABLE LOOK-UP
C    VZS (I) : R*4 - ARRAY OF (VZ**2*SIGMA**2) VALUES FOR TABLE LOOK-UP
C    FVS (I) : R*4 - ARRAY OF F (VZS) VALUES FOR TABLE LOOK-UP
C                    (F (X) = (1. - EXP (- X)) / X))
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C    KURF : I*4 - NUMBER OF CURRENT SURFACE
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 5 : R*8 - FOCAL PLANE INTERSECTION POSITION VECTOR
C
C  INPUT VIA LABELED COMMON /LIMITS/ :
C    NTABG : I*4 - NUMBER OF ENTRIES IN G (V**2) LOOK-UP TABLE
C    NTABR : I*4 - NUMBER OF ENTRIES IN REFL (SIN-THETA) LOOK-UP TABLE
C    NTABF : I*4 - NUMBER OF ENTRIES IN F (VZ**2*SIGMA**2) LOOK-UP TABLE
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZK : R*4 - SYSTEM WAVENUMBER
C    ZW (I) : R*4 - ARRAY OF RAY WEIGHTS
C    DP0 (I) : ARRAY OF SINS OF GRAZING ANGLES
C    DP1S (I) : R*4 - ARRAY OF SAGGITAL DERIVATIVES OF DP0
C    DP1T (I) : R*4 - ARRAY OF TANGENTIAL DERIVATIVES OF DP0
C    SFX,SFY,TFX,TFY (I) : ARRAYS OF SUSEQ SCALE FACTORS
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - ARRAY OF SCATTER DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    FOGR (I) : R*4 - ARRAY OF FOCAL PLANE ARRAY DEFINITION PARAMETERS
C    SIGSQ (I, J) : R*4 - ARRAY OF VALUES OF SIGMA ** 2
C    GR0 (I, J)   : R*4 - ARRAY OF VALUES OF (ACV (R0)) AT R0 .ST.
C                         R0 * ACV (R0) IS MAXIMUM
C    ACCG         : R*4 - DESIRED ACCURACY OF G(V**2) LOOK-UP TABLES
C
C  OUTPUT PARAMETER :
C    STR : R*4 - STREHL FACTOR FOR SCATTER AT CURRENT SURFACE
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    ARGMAX (1, I, J) : R*4 - MAX VALUE OF V**2
C    GRAZMN (J)    : R*4 - MINIMUM SIN OF GRAZING ANGLE
C    GRAZMX (J)    : R*4 - MAXIMUM SIN OF GRAZING ANGLE
C    VZSIMX (I, J) : R*4 - MAXIMUM VALUE OF VZ**2 * SIGMA**2
C    NCALC (I, J)  : I*4 - NUMBER OF RAY-SURFACE CALCULATIONS PERFORMED
C                          USING GRATING METHOD OR TAYLOR APPROX
C    NCALC1 (I, J) : I*4 - NUMBER OF RAY-SURFACE CALCULATIONS PERFORMED
C                          NOT USING TAYLOR APPROXIMATION
C
C  OUTPUT VIA LABELED COMMON /FPGRCO/ :
C    FPGRID (I) : R*4 - ARRAY OF FOCAL PLANE PIXELS
C
C  XR : EEVAL, INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays
 
      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /FPGRCO/ FPGRID (1)
      COMMON /LIMITS/ NAREA, NDEFN, NDTOT, NGRID, NTABG, NTABR, NTABF
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DIMENSION V2 (1), EN (1), EN1 (1), EN2 (1), EN3 (1)
!tjg  DIMENSION SI (1), RSQ (1), VZS (1), FVS (1)
      DIMENSION SI (1),          VZS (1), FVS (1)
!      DIMENSION INIERR (5, 21), NCOMPO (6)
      DIMENSION INIERR (5, 21), NCOMPO (12)
!tjg  DIMENSION DP (21), DPB (21), DPC (21), H0 (21), HJ (21)
!tjg  DIMENSION NROLD (21), NR (21), NRBAS (21),
!tjg 1  NFOLD (3), NF (3), NFBAS (3)
      DIMENSION NFOLD (3), NF (3), NFBAS (3)
      DIMENSION D (3), AZQ (3), BZQ (3), CZQ (3), BZQ0 (3), BZQ1 (3),
     1          CZQ0 (3), CZQ1 (3), CZQ2 (3), CZDEL (3), CZDEL1 (3)
      DIMENSION VZDEL (3), VZDEL1 (3), VZSQS (3), TERM4Z (3), TERM5Z (3)
      DOUBLE PRECISION FOGR
!tjg  LOGICAL * 1 ITRUE, IFALSE, IRFLG, IRFLG2, IT3FLG, IT5FLG, IALLEQ
      LOGICAL * 1 ITRUE, IFALSE,                        IT5FLG, IALLEQ
      DATA PI4SQ, SIN45 /39.47842, 0.70711/
      DATA ITRUE, IFALSE /.TRUE., .FALSE./
!      DATA INIERR /105 * -1/, NCOMPO /2, 2, 3, 3, 2, 1/
      DATA INIERR /105 * -1/
      DATA NCOMPO /2, 2, 3, 3, 2, 1, 0, 0, 2, 2, 2, 1/
C
C
C  CALCULATE BASIC PARAMETERS AND TERM 1
      NX = FOGR (5)
      NY = FOGR (6)
      KURF1 = KURF + 1
      ZKSQ = ZK * ZK
      DETINV = 1. / (SFX (KURF) * TFY (KURF) - SFY (KURF) * TFX (KURF))
      CTH = DP0 (KURF)
      CTHSQ = CTH * CTH
      STHSQ = 1. - CTHSQ
      STH = SQRT (STHSQ)
      TERM1 = FOGR (3) * FOGR (4) * ABS (DETINV) * ZKSQ * ZKSQ /
     1         (FOGR (5) * FOGR (6) * PI4SQ * CTH)
C
C  CALCULATE PARAMETERS TO RELATE DEL-S AND DEL-T TO I AND J
      XCON = FOGR (1) - XV (5) - (FOGR (3) * (FOGR (5) + 1.D0)) /
     1  (2. * FOGR (5))
      YCON = FOGR (2) - YV (5) - (FOGR (4) * (FOGR (6) + 1.D0)) /
     1  (2. * FOGR (6))
      AS0 = DETINV * (TFY (KURF) * XCON - TFX (KURF) * YCON)
      ASI = DETINV * TFY (KURF) * FOGR (3) / FOGR (5)
      ASJ = - DETINV * TFX (KURF) * FOGR (4) / FOGR (6)
      AT0 = DETINV * (- SFY (KURF) * XCON + SFX (KURF) * YCON)
      ATI = - DETINV * SFY (KURF) * FOGR (3) / FOGR (5)
      ATJ = DETINV * SFX (KURF) * FOGR (4) / FOGR (6)
C
C  INITIALIZE FOCAL PLANE PIXEL ARRAY INDEX
      NDXFP = 0
C
C  PERFORM INITIAL CALCULATIONS TO DERIVE V**2
      AQ = ZKSQ * (ATI * ATI * CTHSQ + ASI * ASI)
      BQ0 = 2. * ZKSQ * (AT0 * ATI * CTHSQ + AS0 * ASI)
      BQ1 = 2. * ZKSQ * (ATJ * ATI * CTHSQ + ASJ * ASI)
      CQ0 = ZKSQ * (AT0 * AT0 * CTHSQ + AS0 * AS0)
      CQ1 = 2. * ZKSQ * (AT0 * ATJ * CTHSQ + AS0 * ASJ)
      CQ2 = ZKSQ * (ATJ * ATJ * CTHSQ + ASJ * ASJ)
      NENOLD = 0
!C
!C  PERFORM INIT CALCULATIONS (IF NECESSARY) TO DERIVE SIN-OF-GRAZ-ANG
!      IF (KURF .EQ. NS) GO TO 120
!      IRFLG2 = IRFLG
!      GO TO 130
!120   IRFLG2 = IFALSE
!130   IF (IRFLG2) GO TO 140
!C  (DON'T CALCULATE REFLECTIVITY - SET IT ONCE)
!
!  NEVER CALCULATE REFLECTIVITY MORE THAN ONCE
!
      TERM2 = ZW (NS)
      GO TO 200
!C  (DO CALCULATE REFLECTIVITY - DERIVE COEFFICIENTS)
!140   NPRE = NS * (KURF - 1) - ((KURF - 1) * KURF) / 2
!      DO 180 M = KURF1, NS
!      NDX = NPRE + M - KURF
!      H0 (M) = DP0 (M) + DP1S (NDX) * AS0 + DP1T (NDX) * AT0
!      DPB (M) = DP1S (NDX) * ASI + DP1T (NDX) * ATI
!      HJ (M) = DP1S (NDX) * ASJ + DP1T (NDX) * ATJ
!      NROLD (M) = 0
!180   CONTINUE
C
C  PERFORM INITIAL CALCULATIONS (IF NECESSARY) TO DERIVE VZ**2
C  (FIND METHOD NUMBER OF THIS SCATTER METHOD)
200   NSYS = SDEF (1, METH)
      NCOMP = NCOMPO (NSYS)
C  (FIND VZ**2*SIGMA**2 AT SPEC RAY TO SEE IF CALCULATIONS NECESSARY)
      VZSQ0 = 4. * ZKSQ * CTHSQ
      VZSSPE = VZSQ0 *
     1  (SIGSQ (1, METH) + SIGSQ (2, METH) + SIGSQ (3, METH))
      IF (VZSSPE .LT. 0.01) GO TO 280
C  (TAYLOR APPROXIMATION NOT GOOD ENOUGH)
C  (IF METHOD 7 IS USED, A WARNING IS PRINTED AND TAYLOR APPROX USED)
      IF (NSYS .NE. 7) GO TO 300
      IF (INIERR (METH, KURF) .EQ. 1) GO TO 280
      INIERR (METH, KURF) = 1
      CALL INCLIN (3)
      WRITE (8, 8000) METH, KURF, VZSSPE
C  (USE TAYLOR APPROXIMATION)
280   IT5FLG = IFALSE
      NCALC (METH, KURF) = NCALC (METH, KURF) + 1
      GO TO 400
C  (DON'T USE TAYLOR APPROXIMATION - CALCULATE COEFFICIENTS)
300   IT5FLG = ITRUE
      NCALC1 (METH, KURF) = NCALC1 (METH, KURF) + 1
      DO 310 N = 1, NCOMP
      VS = 0.5 * VZSQ0 * SIGSQ (N, METH)
      VG = 0.5 * VZSQ0 * GR0 (N, METH)
!
!  ALLOW FOR VS BEING TOO LARGE
!      D (N) = (VS / VG) * EXP (- (VS - VG)) * SINH (VG) / SINH (VS)
!
      D (N) = 0.D0
      IF (VS .LT. 34.5388D0)
     *   D (N) = (VS / VG) * EXP (- (VS - VG)) * SINH (VG) / SINH (VS)
!
310   CONTINUE
      DO 320 N = 1, NCOMP
      AZQ (N) = ZKSQ * SIGSQ (N, METH) * ATI * ATI * STHSQ
      BZQ0 (N) = 2. * ZKSQ * SIGSQ (N, METH) *
     1           (AT0 * ATI * STHSQ + 2. * ATI * STH * CTH)
      BZQ1 (N) = 2. * ZKSQ * SIGSQ (N, METH) * ATJ * ATI * STHSQ
      CZQ0 (N) = ZKSQ * SIGSQ (N, METH) *
     1           (4. * CTHSQ + 4. * AT0 * STH * CTH + AT0 * AT0 * STHSQ)
      CZQ1 (N) = ZKSQ * SIGSQ (N, METH) *
     1           (4. * ATJ * STH * CTH + 2. * AT0 * ATJ * STHSQ)
      CZQ2 (N) = ZKSQ * SIGSQ (N, METH) * ATJ * ATJ * STHSQ
      NFOLD (N) = 0
320   CONTINUE
!C
!C  PERFORM INITIAL CALCULATIONS TO DERIVE TERM3
!400   IF (STH .GT. SIN45) GO TO 450
!      T30 = 4. * CTH * CTHSQ * (CTH + 2. * STH * AT0)
!      T3B = 8. * STH * CTH * CTHSQ * ATI
!      T3J = 8. * STH * CTH * CTHSQ * ATJ
!      IT3FLG = IFALSE
!      GO TO 490
!450   DUM1 = 2. * STH * CTH
!      DUM2 = STHSQ - 0.5
!      T3AQ = DUM2 * ATI * ATI + 0.5 * ASI * ASI
!      T3BQ0 = DUM1 * ATI + 2. * DUM2 * AT0 * ATI + AS0 * ASI
!      T3BQ1 = 2. * DUM2 * ATI * ATJ + ASI * ASJ
!      T3CQ0 = 2. * CTHSQ + DUM1 * AT0 + DUM2 * AT0 * AT0 +
!     1                                  0.5 * AS0 * AS0
!      T3CQ1 = DUM1 * ATJ + 2. * DUM2 * AT0 * ATJ + AS0 * ASJ
!      T3CQ2 = DUM2 * ATJ * ATJ + 0.5 * ASJ * ASJ
!      IT3FLG = ITRUE
!490   T3OLD = 1.D30  !*** CHANGED 1.D60 TO 1.D30
!      T3ACC = 0.
!
!  DEFINE TERM3 JUST ONCE
!
400   TERM3 = 4.D0 * CTHSQ * CTHSQ
C
C  DEFINE INCREMENTAL PARAMETERS FOR V**2 FOR J = 1
500   BQ = BQ0 + BQ1
      CQ = CQ0 + CQ1 + CQ2
      CDEL = CQ1 + CQ2
      CDEL1 = CQ2 + CQ2
!C
!C  DEFINE INCREMENTAL PARAMS (IF NECESSARY) FOR SIN-GRAZ-ANG FOR J = 1
!      IF (.NOT. IRFLG2) GO TO 600
!      DO 550 M = KURF1, NS
!      DPC (M) = H0 (M) + HJ (M)
!550   CONTINUE
C
C  DEFINE INCREMENTAL PARAMS (IF NECESSARY) FOR VZ**2 FOR J = 1
600   IF (.NOT. IT5FLG) GO TO 800
      DO 650 N = 1, NCOMP
      BZQ (N) = BZQ0 (N) + BZQ1 (N)
      CZQ (N) = CZQ0 (N) + CZQ1 (N) + CZQ2 (N)
      CZDEL (N) = CZQ1 (N) + CZQ2 (N)
      CZDEL1 (N) = CZQ2 (N) + CZQ2 (N)
650   CONTINUE
!C
!C  DEFINE INCREMENTAL PARAMS FOR TERM3 FOR J = 1
!700   IF (IT3FLG) GO TO 750
!      T3C = T30 + T3J
!      GO TO 800
!750   T3BQ = T3BQ0 + T3BQ1
!      T3CQ = T3CQ0 + T3CQ1 + T3CQ2
!      TCDEL = T3CQ1 + T3CQ2
!      TCDEL1 = T3CQ2 + T3CQ2
C
C  EVALUATE V**2 AND INDEX AT (I,J) = (1,1)
800   V2CRNR = AQ + BQ + CQ
!  CHANGE EEVAL CALL
!      CALL EEVAL (201, VZSCRN, 0, F, DUMA,DUMB,DUMC) !*** was dum,dum,dum
      CALL EEVAL (-2, VZSCRN, 0, F, DUMA,DUMB,DUMC)
      IF (ENER .LT. 1.D-30) ENER = 1.D-30   !*** CHANGED D60 TO D30
      NENBAS = INT (1. + LOG (EN (1) / ENER) / LOG (1. + ACCG))
      NENBAS = MAX0 (1, NENBAS)
      NENBAS = MIN0 (NTABG, NENBAS)
!C
!C  EVALUATE SIN-GRAZ-ANG (IF NECESSARY) AND INDECES AT (I,J) = (1,1)
!900   IF (.NOT. IRFLG2) GO TO 1000
!      DO 950 M = KURF1, NS
!      DPCRNR = DPB (M) + DPC (M)
!      CALL EEVAL (-1, DPCRNR, 0, REFL, DUMA,DUMB,DUMC) !*** was dum,dum,dum 
!      IF (REFL .LT. 1.D-30) REFL = 1.D-30   !*** CHANGED D60 TO D30
!      NRBAS (M) = INT (1. + log (RSQ (2) / REFL) / log (1. + ACCR))
!      NRBAS (M) = MAX0 (2, NRBAS (M))
!      NRBAS (M) = MIN0 (NTABR, NRBAS (M))
!950   CONTINUE
C
C  EVALUATE VZ**2 (IF NECESSARY) AND INDECES AT (I,J) = (1,1)
1000  IF (.NOT. IT5FLG) GO TO 1100
      DO 1050 N = 1, NCOMP
      VZSCRN = AZQ (N) + BZQ (N) + CZQ (N)
      CALL EEVAL (201, VZSCRN, 0, F, DUMA,DUMB,DUMC) !*** was dum,dum,dum 
      IF (F .LT. 1.D-30) F = 1.D-30   !*** CHANGED D60 TO D30
      NFBAS (N) = INT (1. + LOG (FVS (1) / F) / LOG (1. + ACCF))
      NFBAS (N) = MAX0 (1, NFBAS (N))
      NFBAS (N) = MIN0 (NTABF, NFBAS (N))
1050  CONTINUE
C
C  CHOOSE LOOP DEPENDING ON WHETHER TAYLOR APPROX IS TO BE USED
1100  IF (IT5FLG) GO TO 4000
C
C
C  LOOP FOR ALL PIXELS USING TAYLOR APPROXIMATION
C
C  LOOP FOR ALL ROWS
      DO 3000 J = 1, NY
C
C  DEFINE INITIAL PARAMETERS FOR V**2 FOR I = 1
      NEN = NENBAS
      VSQ = AQ + BQ + CQ
      VDEL = AQ + BQ
      VDEL1 = AQ + AQ
!C
!C  DEFINE INITIAL PARAMETERS FOR SIN-GRAZ-ANG (IF NECESSARY) FOR I = 1
!      IF (.NOT. IRFLG2) GO TO 2100
!      DO 2050 M = KURF1, NS
!      NR (M) = NRBAS (M)
!      DP (M) = DPB (M) + DPC (M)
!2050  CONTINUE
!C
!C  DEFINE INITIAL PARAMETERS FOR TERM 3 FOR I = 1
!2100  IF (IT3FLG) GO TO 2150
!      THOLD3 = T3B + T3C
!      GO TO 2200
!2150  T3SQRT = T3AQ + T3BQ + T3CQ
!      T3DEL = T3AQ + T3BQ
!      T3DEL1 = T3AQ + T3AQ
C
C  LOOP FOR ALL COLUMNS
2200  DO 2650 I = 1, NX
      NDXFP = NDXFP + 1
      IALLEQ = ITRUE
C
C  RE-EVALUATE SCATTER PARAMETERS
!C  (RE-EVALUATE TERM 2 PARAMETERS (IF NECESSARY))
!      IF (.NOT. IRFLG2) GO TO 2400
!      DO 2300 M = KURF1, NS
!2210  CONTINUE
!      IF (SI (NR (M)) .LE. DP (M)) GO TO 2220
!      NR (M) = NR (M) - 1
!      GO TO 2210
!2220  CONTINUE
!      IF (SI (NR (M) + 1) .GE. DP (M)) GO TO 2230
!      NR (M) = NR (M) + 1
!      GO TO 2220
!2230  IF (NR (M) .EQ. NROLD (M)) GO TO 2240
!      IALLEQ = IFALSE
!      NROLD (M) = NR (M)
!2240  DP (M) = DP (M) + DPB (M)
!2300  CONTINUE
!      IF (I .NE. 1) GO TO 2320
!      DO 2310 M = KURF1, NS
!      NRBAS (M) = NR (M)
!2310  CONTINUE
!2320  IF (IALLEQ) GO TO 2400
!      TERM2 = ZW (KURF)
!      DO 2330 M = KURF1, NS
!      TERM2 = TERM2 * RSQ (NR (M))
!2330  CONTINUE
C  (RE-EVALUATE TERM 4 PARAMETERS)
2400  CONTINUE
      IF (V2 (NEN) .LE. VSQ) GO TO 2410
      NEN = NEN - 1
      GO TO 2400
2410  CONTINUE
      IF (V2 (NEN + 1) .GE. VSQ) GO TO 2420
      NEN = NEN + 1
      GO TO 2410
2420  IF (NEN .EQ. NENOLD) GO TO 2430
      IALLEQ = IFALSE
      NENOLD = NEN
      TERM4 = EN (NEN)
2430  IF (I .EQ. 1) NENBAS = NEN
      VDEL = VDEL + VDEL1
      VSQ = VSQ + VDEL
!C  (RE-EVALUATE TERM 3 PARAMETERS)
!      IF (IT3FLG) GO TO 2550
!      TERM3 = THOLD3
!      IF (ABS (TERM3 - T3OLD) .LE. T3ACC) GO TO 2510
!      IALLEQ = IFALSE
!      T3ACC = TERM3 * ACCG
!      T3OLD = TERM3
!2510  THOLD3 = THOLD3 + T3B
!      GO TO 2600
!2550  TERM3 = T3SQRT * T3SQRT
!      IF (ABS (TERM3 - T3OLD) .LE. T3ACC) GO TO 2560
!      IALLEQ = IFALSE
!      T3ACC = TERM3 * ACCG
!      T3OLD = TERM3
!2560  T3DEL = T3DEL + T3DEL1
!      T3SQRT = T3SQRT + T3DEL
C
C  CHECK FOR ANY PARAMETERS CHANGED, AND UPDATE FOCAL PLANE ARRAY
2600  IF (.NOT. IALLEQ) DELTA = TERM1 * TERM2 * TERM3 * TERM4
      FPGRID (NDXFP) = FPGRID (NDXFP) + DELTA
2650  CONTINUE
C
C  RE-INITIALIZE PARAMETERS FOR NEXT J
      BQ = BQ + BQ1
      CDEL = CDEL + CDEL1
      CQ = CQ + CDEL
!      IF (.NOT. IRFLG2) GO TO 2720
!      DO 2710 M = KURF1, NS
!      DPC (M) = DPC (M) + HJ (M)
!2710  CONTINUE
!2720  IF (IT3FLG) GO TO 2750
!      T3C = T3C + T3J
!      GO TO 3000
!2750  T3BQ = T3BQ + T3BQ1
!      TCDEL = TCDEL + TCDEL1
!      T3CQ = T3CQ + TCDEL
3000  CONTINUE
      GO TO 6000
C
C
C  LOOP FOR ALL PIXELS NOT USING TAYLOR APPROXIMATION
C
C  LOOP FOR ALL ROWS
4000  DO 5000 J = 1, NY
C
C  DEFINE INITIAL PARAMETERS FOR V**2 FOR I = 1
      NEN = NENBAS
      VSQ = AQ + BQ + CQ
      VDEL = AQ + BQ
      VDEL1 = AQ + AQ
C
C  DEFINE INITIAL PARAMETERS FOR VZ**2*SIGMA**2 FOR I = 1
      DO 4020 N = 1, NCOMP
      NF (N) = NFBAS (N)
      VZSQS (N) = AZQ (N) + BZQ (N) + CZQ (N)
      VZDEL (N) = AZQ (N) + BZQ (N)
      VZDEL1 (N) = AZQ (N) + AZQ (N)
4020  CONTINUE
!C
!C  DEFINE INITIAL PARAMETERS FOR SIN-GRAZ-ANG (IF NECESSARY) FOR I = 1
!      IF (.NOT. IRFLG2) GO TO 4100
!      DO 4050 M = KURF1, NS
!      NR (M) = NRBAS (M)
!      DP (M) = DPB (M) + DPC (M)
!4050  CONTINUE
!C
!C  DEFINE INITIAL PARAMETERS FOR TERM 3 FOR I = 1
!4100  IF (IT3FLG) GO TO 4150
!      THOLD3 = T3B + T3C
!      GO TO 4200
!4150  T3SQRT = T3AQ + T3BQ + T3CQ
!      T3DEL = T3AQ + T3BQ
!      T3DEL1 = T3AQ + T3AQ
C
C  LOOP FOR ALL COLUMNS
4200  DO 4750 I = 1, NX
      NDXFP = NDXFP + 1
      IALLEQ = ITRUE
C
C  RE-EVALUATE SCATTER PARAMETERS
!C  (RE-EVALUATE TERM 2 PARAMETERS (IF NECESSARY))
!      IF (.NOT. IRFLG2) GO TO 4400
!      DO 4300 M = KURF1, NS
!4210  CONTINUE
!      IF (SI (NR (M)) .LE. DP (M)) GO TO 4220
!      NR (M) = NR (M) - 1
!      GO TO 4210
!4220  CONTINUE
!      IF (SI (NR (M) + 1) .GE. DP (M)) GO TO 4230
!      NR (M) = NR (M) + 1
!      GO TO 4220
!4230  IF (NR (M) .EQ. NROLD (M)) GO TO 4240
!      IALLEQ = IFALSE
!      NROLD (M) = NR (M)
!4240  DP (M) = DP (M) + DPB (M)
!4300  CONTINUE
!      IF (I .NE. 1) GO TO 4320
!      DO 4310 M = KURF1, NS
!      NRBAS (M) = NR (M)
!4310  CONTINUE
!4320  IF (IALLEQ) GO TO 4400
!      TERM2 = ZW (KURF)
!      DO 4330 M = KURF1, NS
!      TERM2 = TERM2 * RSQ (NR (M))
!4330  CONTINUE
C  (RE-EVALUATE TERM 4 PARAMETERS)
4400  CONTINUE
      IF (V2 (NEN) .LE. VSQ) GO TO 4410
      NEN = NEN - 1
      GO TO 4400
4410  CONTINUE
      IF (V2 (NEN + 1) .GE. VSQ) GO TO 4420
      NEN = NEN + 1
      GO TO 4410
4420  IF (NEN .EQ. NENOLD) GO TO 4430
      IALLEQ = IFALSE
      NENOLD = NEN
      TERM4Z (1) = EN1 (NEN)
      TERM4Z (2) = EN2 (NEN)
      TERM4Z (3) = EN3 (NEN)
4430  IF (I .EQ. 1) NENBAS = NEN
      VDEL = VDEL + VDEL1
      VSQ = VSQ + VDEL
!C  (RE-EVALUATE TERM 3 PARAMETERS)
!      IF (IT3FLG) GO TO 4550
!      TERM3 = THOLD3
!      IF (ABS (TERM3 - T3OLD) .LE. T3ACC) GO TO 4510
!      IALLEQ = IFALSE
!      T3ACC = TERM3 * ACCR
!4510  THOLD3 = THOLD3 + T3B
!      GO TO 4600
!4550  TERM3 = T3SQRT * T3SQRT
!      IF (ABS (TERM3 - T3OLD) .LE. T3ACC) GO TO 4560
!      IALLEQ = IFALSE
!      T3ACC = TERM3 * ACCR
!4560  T3DEL = T3DEL + T3DEL1
!      T3SQRT = T3SQRT + T3DEL
C  (RE-EVALUATE TERM 5 PARAMETERS)
4600  CONTINUE
      IF (VZS (NF (1)) .LE. VZSQS (1)) GO TO 4610
      NF (1) = NF (1) - 1
      GO TO 4600
4610  CONTINUE
      IF (VZS (NF (1) + 1) .GE. VZSQS (1)) GO TO 4620
      NF (1) = NF (1) + 1
      GO TO 4610
4620  IF (NCOMP .LT. 2) GO TO 4680
4630  CONTINUE
      IF (VZS (NF (2)) .LE. VZSQS (2)) GO TO 4640
      NF (2) = NF (2) - 1
      GO TO 4630
4640  CONTINUE
      IF (VZS (NF (2) + 1) .GE. VZSQS (2)) GO TO 4650
      NF (2) = NF (2) + 1
      GO TO 4640
4650  IF (NCOMP .LT. 3) GO TO 4680
4660  CONTINUE
      IF (VZS (NF (3)) .LE. VZSQS (3)) GO TO 4670
      NF (3) = NF (3) - 1
      GO TO 4660
4670  CONTINUE
      IF (VZS (NF (3) + 1) .GE. VZSQS (3)) GO TO 4680
      NF (3) = NF (3) + 1
      GO TO 4670
C
4680  GO TO (4681, 4682, 4683), NCOMP
4681  IF (NF (1) .EQ. NFOLD (1)) GO TO 4695
      GO TO 4690
4682  IF (NF (1) .EQ. NFOLD (1) .AND.
     1  NF (2) .EQ. NFOLD (2)) GO TO 4695
      GO TO 4690
4683  IF (NF (1) .EQ. NFOLD (1) .AND.
     1  NF (2) .EQ. NFOLD (2) .AND.
     2  NF (3) .EQ. NFOLD (3)) GO TO 4695
4690  IALLEQ = IFALSE
      DO 4692 N = 1, NCOMP
      TERM5Z (N) = D (N) * FVS (NF (N))
      NFOLD (N) = NF (N)
4692  CONTINUE
4695  IF (I .NE. 1) GO TO 4698
      DO 4697 N = 1, NCOMP
      NFBAS (N) = NF (N)
4697  CONTINUE
4698  DO 4699 N = 1, NCOMP
      VZDEL (N) = VZDEL (N) + VZDEL1 (N)
      VZSQS (N) = VZSQS (N) + VZDEL (N)
4699  CONTINUE
C
C  CHECK FOR ANY PARAMETERS CHANGED, AND UPDATE FOCAL PLANE ARRAY
4700  IF (IALLEQ) GO TO 4720
      TERM45 = 0.
      DO 4710 N = 1, NCOMP
      TERM45 = TERM45 + TERM4Z (N) * TERM5Z (N)
4710  CONTINUE
      DELTA = TERM1 * TERM2 * TERM3 * TERM45
4720  FPGRID (NDXFP) = FPGRID (NDXFP) + DELTA
4750  CONTINUE
C
C  RE-INITIALIZE PARAMETERS FOR NEXT J
      BQ = BQ + BQ1
      CDEL = CDEL + CDEL1
      CQ = CQ + CDEL
!      IF (.NOT. IRFLG2) GO TO 4820
!      DO 4810 M = KURF1, NS
!      DPC (M) = DPC (M) + HJ (M)
!4810  CONTINUE
!4820  IF (IT3FLG) GO TO 4850
!      T3C = T3C + T3J
!      GO TO 5000              !! THIS WAS A BUG - GO TO 5000 SHOULD
!                                 HAVE GONE JUST 4 STATEMENTS DOWN!
!4850  T3BQ = T3BQ + T3BQ1
!      TCDEL = TCDEL + TCDEL1
!      T3CQ = T3CQ + TCDEL
      DO 4860 N = 1, NCOMP
      BZQ (N) = BZQ (N) + BZQ1 (N)
      CZDEL (N) = CZDEL (N) + CZDEL1 (N)
      CZQ (N) = CZQ (N) + CZDEL (N)
4860  CONTINUE
5000  CONTINUE
C
C  EVALUATE V**2 AT FOUR CORNERS TO GET MAX VALUES
6000  BQJ1 = BQ0 + BQ1
      BQJNY = BQ0 + BQ1 * NY
      CQJ1 = CQ0 + CQ1 + CQ2
      CQJNY = CQ0 + CQ1* NY + CQ2 * NY * NY
      VSQ1 = AQ + BQJ1 + CQJ1
      VSQ2 = AQ + BQJNY + CQJNY
      VSQ3 = AQ * NX * NX + BQJ1 * NX + CQJ1
      VSQ4 = AQ * NX * NX + BQJNY * NX + CQJNY
      ARGMAX (1, METH, KURF) = MAX (ARGMAX (1, METH, KURF),
     1                             VSQ1, VSQ2, VSQ3, VSQ4)
!C
!C  EVALUATE SIN-GRAZ-ANG (IF NECESSARY) AT FOUR CORNERS TO GET
!C                                       MIN, MAX VALUES
!      IF (.NOT. IRFLG2) GO TO 6100
!      DO 6050 M = KURF1, NS
!      GR1 = DPB (M) + H0 (M) + HJ (M)
!      GR2 = DPB (M) + H0 (M) + HJ (M) * NY
!      GR3 = DPB (M) * NX + H0 (M) + HJ (M)
!      GR4 = DPB (M) * NX + H0 (M) + HJ (M) * NY
!      GRAZMX (M) = MAX (GRAZMX (M), GR1, GR2, GR3, GR4)
!      GRAZMN (M) = MIN (GRAZMN (M), GR1, GR2, GR3, GR4)
!6050  CONTINUE
C
C  EVALUATE VZ**2*SIGMA**2 (IF NECESSARY) AT FOUR CORNERS TO GET
C                                              MAX VALUE
!
!  MODIFY THIS LOOP SO THAT VZ**2*SIGMA**2 IS FOR THE ENTIRE METHOD,
!  NOT JUST FOR THE STRONGEST PROCESS IN THE METHOD
!
      VZSI1 = 0.D0
      VZSI2 = 0.D0
      VZSI3 = 0.D0
      VZSI4 = 0.D0
!
6100  IF (.NOT. IT5FLG) GO TO 6200
      DO 6150 N = 1, NCOMP
      BQJ1 = BZQ0 (N) + BZQ1 (N)
      BQJNY = BZQ0 (N) + BZQ1 (N) * NY
      CQJ1 = CZQ0 (N) + CZQ1 (N) + CZQ2 (N)
      CQJNY = CZQ0 (N) + CZQ1 (N) * NY + CZQ2 (N) * NY * NY
!  (INCREMENT RATHER THAN SET VZSI1-4 BELOW)
      VZSI1 = VZSI1 + AZQ (N) + BQJ1 + CQJ1
      VZSI2 = VZSI2 + AZQ (N) + BQJNY + CQJNY
      VZSI3 = VZSI3 + AZQ (N) * NX * NX + BQJ1 * NX + CQJ1
      VZSI4 = VZSI4 + AZQ (N) * NX * NX + BQJNY * NX + CQJNY
!
!      VZSIMX (METH, KURF) = MAX (VZSIMX (METH, KURF),
!     1                             VZSI1, VZSI2, VZSI3, VZSI4)
!
6150  CONTINUE
!
      VZSIMX (METH, KURF) = MAX (VZSIMX (METH, KURF),
     1                             VZSI1, VZSI2, VZSI3, VZSI4)
!
C
C  SET STREHL FACTOR AND EXIT (FINALLY ] ] ] ] ] ] ] ] ] ] ])
6200  STR = EXP (- VZSSPE)
      RETURN
C
8000  FORMAT (/ '  FPSTAT WARNING - FOR (PSD) METHOD #', I2,
     1  ' AT SURFACE', I3, ', VZ**2*SIGMA**2 =', F6.2 /
     2  '  TAYLOR SERIES APPROXIMATION USED IS PROBABLY INACCURATE')
      END
