!+
!KWIC gxin.f
!
!$Id: gxin.f,v 1.2 2004/03/17 21:23:35 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/: add save stmt; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 2/26/88 TO READ THE MODIFIED, EXPANDED GX FILE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE GXIN (ND, JER)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    GXIN FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 04/25/80
C    *
C    *    UPDATE:   11/30/81
C    *    TIME:     13:35:08
C    *
C    ******************************************/
C
C  PURPOSE: TO READ INTO MEMORY THE 'GX' FILE
C
C  INPUT:
C    FILE 'GX' : GEOMETRY FILE ON UNIT # ND
C
C  OUTPUT ARGUMENT:
C    JER : I*4 ERROR CODE
C        : 0 - NO ERROR
C        : 1 - END OF FILE
C        : 2 - ERROR WHILE READING FILE
C
C  OUTPUT VIA DEVICE # 6 AND DEVICE # 8:
C    ERROR MESSAGES
C
C  OUTPUT VIA LABELED COMMON /IDENT/:
C    GID (1 TO 16) : 64 CHARACTER IDENTIFICATION RECORD
C    GDATE         : CHAR * 8 - 8 CHARACTER GEOMETRY DATE
C    GTIME         : R * 8 - 8 CHARACTER GEOMETRY TIME + 8 CHAR DUMMY
C
C  OUTPUT VIA LABELED COMMON /PARX/:
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    NS   : I*4 - ACTUAL NUMBER OF SURFACES
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKE
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C    H2   : R*4 - NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
C  OUTPUT VIA LABELED COMMON /PARM/  ALL ARE DOUBLE PRECISION:
C    GEN ( 1) : XAP = X OF CENTER OF ANNULAR APERTURE
C    GEN ( 2) : YAP = Y OF CENTER OF ANNULAR APERTURE
C    GEN ( 3) : ZOFF - Z OFFSET OF FOCAL PLANE
C    GEN ( 4) : NS - TOTAL NUMBER OF SURFACES (EXCLUDE FOCAL PLANE)
C    GEN ( 5) : PSI - POLARIZATION MAJOR AXIS ANGLE (WAS EP1)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 6) : E - RATIO OF MINOR TO MAJOR AXIS AMPLITUDE (WAS EP2)
C               (ABS VALUE BETWEEN 0 AND 1)
C               (POSITIVE FOR LEFT HANDED, NEGATIVE FOR RIGHT HANDED)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 7) : AZBU - AZIMUTH ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 8) : ELBU - ELEVATION ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 9) : R1 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R2 - OUTER RADIUS OF APERTURE ANNULUS
C    GEN (11) : MING - NUMBER OF RINGS
C    GEN (12) : M2 - NUMBER OF POINUC IN OUTERMOST RING
C    GEN (13 & 14)  ARE READ IN BUT NOT USED
C
C    IF J = SURFACE NUMBER THEN,
C    SURF (1, J) : X - X COORD. AT SURFACE CENTER
C    SURF (2, J) : Y - Y COORD. AT SURFACE CENTER
C    SURF (3, J) : Z - Z COORD. AT SURFACE CENTER
C    SURF (4, J) : P - CONIC CONSTANT = 1 - ECCEN. ** 2
C    SURF (5, J) : VERTEX RADIUS OF CURV. OR K FACTOR OF XRAY SURFACE
C    SURF (6, J) : P0 - CENTER RADIUS  (USUALLY 0 FOR CONVENTIONAL)
C    SURF (7, J) : AZMIS - AZIMUTH MISALIGNMENT OF SURFACE (DEG.)
C    SURF (8, J) : ELMIS - ELEVATION MISALIGNMENT OF SURFACE (DEG.)
C    SURF (9, J) : INNER RADIUS OF CONV. OR LENGTH OF XRAY SURFACE
C    SURF (10,J) : OUTER RADIUS OF CONV. OR LENGTH OF X-RAY SURFACE OR
C                  OUTER RADIUS OR Y-WIDTH OF OBSCURATION
C    SURF (14,J) : EP1 - REAL PART OF DIELECTRIC CONSTANT
C    SURF (15,J) : EP2 - IMAGINARY PART OF DIELECTRIC CONSTANT
C    SURF (16 - 20,J) : NOT USED
C
C  OUTPUT VIA LABELED COMMON /SWITCH/  ALL ARE LOGICAL * 1:
C    LSW0 (1 TO 10) : GENERAL SYSTEM SWITCHES
C    LSW (1 TO 10, J) : SWITCHES FOR SURFACE J
C
C  EXTERNAL REFERENCES: INCLIN, RDGX
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
C
C  INIT THE ERROR CODE
      JER = 0
C
C  READ THE IDENTIFICATION AND PARX RECORDS
      READ (ND, 500, ERR = 80, END = 90) GID, GDATE, GTIME(1)
      READ (ND, 510, ERR=100, END=110) NS,MING,M2,RZER,DR,H2,GFOC
C
C  READ THE GENERAL SYSTEM INFORMATION
!
!  DON'T READ THE FIRST 4 PARAMETERS SEPARATELY
!
!     READ (ND, 520, ERR = 120, END = 130) (GEN (I), I = 1, 4)
!
!  READ BEGINNING WITH GEN (1), NOT GEN (5)
!
      CALL RDGX (ND, GEN (1), LSW0, IER)
      IF (IER .EQ. 1) GO TO 130
      IF (IER .EQ. 2) GO TO 120
C
C  READ THE SURFACE INFORMATION
      DO 30 J = 1, NS
      CALL RDGX (ND, SURF (1, J), LSW (1, J), IER)
      IF (IER .EQ. 1) GO TO 150
      IF (IER .EQ. 2) GO TO 140
30    CONTINUE
      GO TO 300
C
C  ERROR WHILE READING IDENTIFICATION RECORDS
80    CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 610)
      GO TO 280
C
C  EOF WHILE READING IDENTIFICATION RECORDS
90    CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 620)
      GO TO 290
C
C  ERROR WHILE READING PARX RECORDS
100   CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 630)
      GO TO 280
C
C  EOF WHILE READING PARX RECORDS
110   CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 640)
      GO TO 290
C
C  ERROR WHILE READING GENERAL SYSTEM INFORMATION
120   CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 650)
      GO TO 280
C
C  EOF WHILE READING GENERAL SYSTEM INFORMATION
130   CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 660)
      GO TO 290
C
C  ERROR WHILE READING SURFACE INFORMATION
140   CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 670) J
      GO TO 280
C
C  EOF WHILE READING SURFACE INFORMATION
150   CALL INCLIN (2)
      WRITE (8, 600)
      WRITE (8, 680) J
      GO TO 290
C
C  ERROR WHILE READING
280   JER = 2
      GO TO 300
C
C  END OF FILE
290   JER = 1
      CLOSE(ND) !*** DEDRIQ RUNNING BATCH WAS KEEPING THE GX FILE BUSY
300   RETURN
500   FORMAT (1X, 15A4, A1, 1X, A8, 1X, A8)
510   FORMAT (I5, 5X, 2I5, 1P,3E15.6, D15.8)
520   FORMAT (1P, 4D20.12)
600   FORMAT (' ERROR IN GXIN:')
610   FORMAT (' ERROR WHILE READING IDENTIFICATION RECORD')
620   FORMAT (' EOF WHILE READING IDENTIFICATION RECORD')
630   FORMAT (' ERROR WHILE READING PARX RECORD')
640   FORMAT (' EOF WHILE READING PARX RECORD')
650   FORMAT (' ERROR WHILE READING GENERAL SYSTEM INFORMATION')
660   FORMAT (' EOF WHILE READING GENERAL SYSTEM INFORMATION')
670   FORMAT (' ERROR WHILE READING INFORMATION FOR SURFACE NUM', I5)
680   FORMAT (' EOF WHILE READING INFORMATION FOR SURFACE NUM', I5)
      END
