!+
!KWIC headfr.f
!
!$Id: headfr.f,v 1.2 2004/03/17 21:23:35 dtn Exp $
!
!Revisions:
!   97-May-20[D. Grumm]
!      . changed RTIME to CHARACTER*(8)
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 5/9/88 TO DECLARE RID, DFID CHARACTER*4 FOR PROPER HEADER
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE HEADFR
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    HEADFR FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 12/07/81
C    *
C    *    UPDATE:   02/11/82
C    *    TIME:     10:50:49
C    *
C    ******************************************/
C
C  READ/WRITE ALL HEADERS, AND READ AND CHECK THE DIFFR FILE
C
C  INPUT VIA # 1 :
C    HEADER, BEST FOCUS, AND EFL INFORMATION FROM 'OPD' FILE
C
C  INPUT VIA # 3 :
C    'DIFFR' FILE INFORMATION ON DIFFRACTION CALCULATIONS TO BE DONE
C
C  INPUT VIA LABELED COMMON /IDENT/ :
C    GID   : 64 CHARACTER GI IDENTIFIER LINE
C    GDATE : CHAR*8 - 8 CHARACTER DATE
C    GTIME : R*8 - 8 CHARACTER TIME
C    RID   : 64 CHARACTER IDENTIFICATION RECORD
C    RDATE : 'OPD' FILE DATE
C    RTIME : 'OPD' FILE TIME
C
C  INPUT VIA LABELED COMMON /ILIMIT/ :
C    NR     : I*4 - NUMBER OF RINGS ALLOWED
C    NTHETA : I*4 - NUMBER OF SPOKES ALLOWED
C    MFFT   : I*4 - LOG-BAE-2 OF NUMBER OF FFT POINTS ALLOWED
C    NGRID  : I*4 - NUMBER OF X OR Y PIXELS ALLOWED IN FOCAL PLANE ARRAY
C
C  OUTPUT VIA # 2 :
C    'FPDFR' (BINARY) FILE HEADER
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 10 : COORDINATES OF BEST FOCUS (REF SPHERE CENTER) IN FP
C
C  OUTPUT VIA LABELED COMMON /IOPRAM/ :
C    FOGR (1) : R*8 - PIXEL ARRAY CENTER X COORD
C    FOGR (2) : R*8 - PIXEL ARRAY CENTER Y COORD
C    FOGR (3) : R*8 - PIXEL ARRAY X LENGTH
C    FOGR (4) : R*8 - PIXEL ARRAY Y LENGTH
C    FOGR (5) : R*8 - NUMBER OF PIXELS IN X DIRECTION
C    FOGR (6) : R*8 - NUMBER OF PIXELS IN Y DIRECTION
C    ZLAM     : R*4 - WAVELENGTH
C    EFL      : R*4 - EFFECTIVE FOCAL LENGTH
C    RA       : R*4 - INNER RADIUS OF ANNULAR APERTURE
C    RB       : R*4 - OUTER RADIUS OF ANNULAR APERTURE
C    NX       : I*4 - NX = FOGR (5)
C    NY       : I*4 - NY = FOGR (6)
C
C  TEMPORARY INPUT / OUTPUT VIA LABELED COMMON /PARX/ :
C    KURF : I*4 - CURRENT SURFACE NUMBER
C
C  XR : INCLIN, REHEAD
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
       
      include 'saosacLib/ident.h'

C
C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2),
C     2               DFID (16)

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /ILIMIT/ NR, NTHETA, MFFT, NGRID
      COMMON /IOPRAM/ FOGR (6), ZLAM, EFL, RA, RB, WMAX, NX, NY, MM, NN
      DOUBLE PRECISION FOGR
C      CHARACTER * 4 GID, RID
C      CHARACTER * 4 DFID
C      CHARACTER*8 GDATE , RDATE, RTIME !*** WERE DOUBLE PRECISION
C
C
C  SET EXPECTED SURFACE NUMBER + 1 AND READ OPD FILE HEADER
      KURF = - 1
      CALL REHEAD (1, -1, IER)
      IF (IER .NE. 0) GO TO 2000
C
C  READ BEST FOCUS, EFL
      READ (1, *, END = 2010, ERR = 2020) XV (10), YV (10), EFL
C
C  READ AND CHECK ALL INFORMATION FROM 'DIFFR' FILE
      READ (3, 9010, END = 2010, ERR = 2020) RID
      READ (3, * , END = 2010, ERR = 2020) (FOGR (I), I = 1, 4),
     1                                        NX, NY !*** changed to free 
                                                     !*** format input
      FOGR (5) = NX
      FOGR (6) = NY
      IF (DABS (FOGR (1)) .GT. 1000.D0) GO TO 2030
      IF (DABS (FOGR (2)) .GT. 1000.D0) GO TO 2030
      IF (FOGR (3) .LT. 0.D0 .OR. FOGR (3) .GT. 1000.D0) GO TO 2030
      IF (FOGR (4) .LT. 0.D0 .OR. FOGR (4) .GT. 1000.D0) GO TO 2030
      IF (NX .LT. 1 .OR. NX .GT. NGRID) GO TO 2030
      IF (NY .LT. 1 .OR. NY .GT. NGRID) GO TO 2030
C
C  READ REMAINING DIFFR FILE PARAMETERS
      READ (3, * , END = 2010, ERR = 2020) ZLAM, RA, RB !*** free format input
      IF (ZLAM .LE. 0.) GO TO 2040
      IF (RA .LT. 0. .OR. RB .LE. RA) GO TO 2050
C
C  WRITE FPDFR FILE HEADER
      ITYPE = 2
      WRITE (2) RID, RDATE, RTIME (1)
      WRITE (2) GID, GDATE, GTIME (1)
      WRITE (2) FOGR, ZLAM, ITYPE
      RETURN
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000) IER
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8010)
      STOP 8
2020  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8020)
      STOP 8
2030  CONTINUE
      CALL INCLIN (7)
      WRITE (8, 8030) FOGR
      STOP 8
2040  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8040) ZLAM
      STOP 8
2050  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8050) RA, RB
      STOP 8
C
8000  FORMAT ('  HEADFR - FATAL ERROR', I3, ' READING OPD FILE HEADER')
8010  FORMAT ('  HEADFR - FATAL ERROR - UNEXPECTED EOF ON FILE READ')
8020  FORMAT ('  HEADFR - FATAL ERROR - UNEXPECTED ERR ON FILE READ')
8030  FORMAT ('  HEADFR - FATAL ERROR - FOGR PARAMETERS ILLEGAL',
     1  6 (/ 1P,D12.4))
8040  FORMAT ('  HEADFR - FATAL ERROR - ZLAM =', 1P,D12.4, ' (.LE. 0.)')
8050  FORMAT ('  HEADFR - FATAL ERROR - (RA, RB) =', 1P,2D12.4)
C9000 FORMAT (3D20.12)
 9010 FORMAT (16A4)
C 
C !*** changed input to free format
C   9020  FORMAT (4D15.0, 2I6)
C   9030  FORMAT (3D15.0)
C
      END
