!+
!KWIC icleg4.f
!
!$Id: icleg4.f,v 1.2 2004/03/17 21:23:36 dtn Exp $
!
!Revisions:
!   98-Feb-17[T. Gaetz]
!      . consolidate spline calls to facilitate moving to C for spline stuff
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   97-Feb-25[D. Grumm]
!      . for COMMON /SWITCH/ LSW (10, 21); replace use by dfm_type =
!        0 for Legendre/Fourier deformation only
!        1 for spline deformation only,
!        2 for both spline and Legendre/Fourier deformations 
!   95-Oct-12[T. Gaetz]
!      . add support for scaling of deformation
!   95-Oct-10[T. Gaetz]
!      . repair modifications to support clocking of deformation
!   95-Oct-08[T. Gaetz]
!      . add modifications to support clocking of deformation
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . rename i0_short, i1_short, i2_short to 
!        DFM_VAL, D_DFM_DZ, D_DFM_DTHETA; eliminate parameter i1_long.
!      . remove obsolete commented-out code
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!   93-Aug-11[T. Gaetz]
!      . convert PI from variable initialized in DATA statement to
!        named constant initialized in PARAMETER statement.
!      . new named constants:  
!        . i0_short, i1_short, i2_short (integer*2 versions of 0, 1, 2
!          to be used in place of short(0), short(1), short(2)
!        . i1_long, an integer version of 1 to be used instead of
!          new = long(1).
!   93-Apr-15[T. Gaetz]
!        .     short() was actually a NONSTANDARD function call;
!     fix up source appropriately.
!     93-Apr-14[T. Gaetz]
!     . short() undefined; declare it as integer*2 short(0:2);
!     explicitly initialize to zero.
!     -

      SUBROUTINE ICLEG4 (R2, K, P, TEL, KODE)
C     /****************************************
C     *
C     *    PERKIN-ELMER CORPORATE COMPUTING
C     *      SOFTWARE ENGINEERING SECTION
C     *
C     *    ICLEG4 FORTRAN
C     *    WRITTEN BY PHILIP GRIBOSKY
C     *            ON 07/01/80
C     *
C     *    UPDATE:   11/04/80
C     *    TIME:     14:07:33
C     *
C     ******************************************/
C     
C     ITERATIVELY CORRECT FOR A SURFACE WITH LEGENDRE-FOURIER DEFORMATIONS
C     
C     INPUT ARGUMENTS:
C     R2   : R*8 - CONSTANT TERM IN SURFACE EQUATION
C     K    : R*8 - HALF LINEAR TERM OF SURFACE EQUATION
C     P    : R*8 - CONIC CONSTANT = 1 - ECCENTRICITY ** 2
C     KODE : I*4 - INDICATOR SHOWING HOW RAY IS TO INTERSECT SURFACE
C     (SEE COLEG4)
C     
C     INPUT VIA LABELED COMMON /COMIC/:
C     XD   : R*8 - X COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C     YD   : R*8 - Y COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C     ZD   : R*8 - Z COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C     XL   : R*8 - X COMPONENT OF INPUT DIRECTION
C     YL   : R*8 - Y COMPONENT OF INPUT DIRECTION
C     ZL   : R*8 - Z COMPONENT OF INPUT DIRECTION
C     PHIL : R*8 - 2/L FOR X-RAY SYSTEM (CALCULATED IN VINIT)
C     
C     INPUT VIA LABELED COMMON /DEFORM/:
C     DEFT : R*8 - SQUARE ROOT OF THE SUM OF THE SQUARES OF THE
C     DEFORMATION COEFFICIENTS
C     
C     OUTPUT ARGUMENTS:
C     TEL  : R*8 - TOTAL DISTANCE CORRECTION
C     KODE : I*4 - INDICATOR SHOWING HOW RAY INTERSECTED SURFACE
C     (SEE COLEG4)
C     
C     OUTPUT VIA LABELED COMMON /COMIC/:
C     XD : R*8 - X COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C     YD : R*8 - Y COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C     ZD : R*8 - Z COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C     XG : R*8 - X COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C     YG : R*8 - Y COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C     ZG : R*8 - Z COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C     
C     EXTERNAL REFERENCES: ABLEG4
C     
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DOUBLE PRECISION K
      DOUBLE PRECISION DEL, F, FDOT, Q, QT, QZ, TS, ZN
      DOUBLE PRECISION Q1, QT1, QZ1, Q2, QT2, QZ2
      real * 8 theta
      integer spline_eval

      include 'saosacLib/deform.h' ! fourier-legendre deformation coeffs
      include 'saosacLib/parx.h' ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/srfstuff.h' ! surface parameters
      include 'saosacLib/comic.h' 
      include 'saosacLib/switch.h' 

      double precision ctx

      DOUBLE PRECISION PI
      PARAMETER      ( PI = 3.141592653589793238462643D0 )
C     initialize deformation values for second deformation to correctly
C     handle the single-deformation case.
      Q1 = 0.0D0
      QT1 = 0.0D0
      QZ1 = 0.0D0
      Q2 = 0.0D0
      QT2 = 0.0D0
      QZ2 = 0.0D0
C     
      IER = 0
      RHOS = XD ** 2 + YD ** 2
      RHO = DSQRT (RHOS)
      RC = RHO
      RHIN = 1.0D0 / RHO
      RCIN = RHIN
      ZN = PHIL * ZD
      ZND = PHIL * ZL
      PZK = P * ZD - K
      DEL = DBLE(RHO) + ABS (DBLE(PZK)) + ABS (DBLE(ZD)) + 1.0D09*DEFT
      TS = DEL * 1.0D-14
      TEL = 0.0d0
      RHOD = 0.0D0
C     
      IT = 0
      GO TO 20
 10   CONTINUE
      RHOD = RHIN * (XD * XL + YD * YL)
      RCD = - PZK * ZL * RCIN
      QD = QT * TD + QZ * ZND
      FDOT = QD + DBLE (RCD - RHOD)
      IF (ABS (FDOT * DEL ) .LT. ABS (4.0d0 * F)) GO TO 50
C     
C     FIND THE NEW POINT AND RELATED QUANTITIES
C     
      DEL = F / FDOT
      TEL = TEL + DEL
      XD = XD + DEL * XL
      YD = YD + DEL * YL
      ZD = ZD + DEL * ZL
      PZK = P * ZD - K
      RHOS = XD ** 2 + YD ** 2
C     ESTIMATE RHO
      RHO = RHO + DEL * RHOD
      RHO = 0.5D0 * (RHO + RHOS / RHO)
      RHIN = 1.0D0 / RHO
      RCS = R2 + ZD * (K - PZK)
C     ESTIMATE RC
      RC = RC + DEL * RCD
      RC = 0.5D0 * (RC + RCS / RC)
      RCIN = 1.0D0 / RC
 20   CONTINUE
C     
C     EVALUATE THE SURFACE FUNCTION F FOR THE FIRST DEFORMATION
C     
      CT = XD * RHIN
      ST = YD * RHIN
!---  apply 1st rotation:  theta --> theta + theta0
      ctx = ct
      ct  = ct * costheta0 + st  * sintheta0
      st  = st * costheta0 - ctx * sintheta0
      theta = datan2(ST,CT)
      IF (THETA .LT. 0.0d0) THETA = THETA + 2.0d0*PI
      TD = (XD * YL - YD * XL) * (RHIN ** 2)
      ZN = PHIL * ZD
C     
      IF (DFM_TYPE .EQ. 1) THEN  ! switched from 0 on 11/14/97
C     ...spline only...
         IF(ABS (ZN) .GT. 1) THEN
            ier = 1
         ELSE
            ier = spline_eval( theta, zn, q1, qz1, qt1 ) 
               ! dq, dq/d(z), dq/d(theta)
         ENDIF

C     ... rescale deformation and derivatives...
         q  = q1  * dfm_scale 
         qt = qt1 * dfm_scale
         qz = qz1 * dfm_scale

      ELSE IF (DFM_TYPE .EQ. 0) THEN   ! switched from 1 on 11/14/97
C     ...Legendre/Fourier only... 
         IF ( nfour .eq. 0 ) THEN
            CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
     1      DEFC (NLEG * NFOUR + NLEG + 1), Q1, QT1, QZ1, IER, 1)
         ELSE
            CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
     1      DEFC (NLEG * NFOUR + NLEG + 1), Q1, QT1, QZ1, IER, nfour)
         END IF
   
C     rescale deformation and derivatives..
         q  = q1  * dfm_scale 
         qt = qt1 * dfm_scale
         qz = qz1 * dfm_scale

      ELSE
C      ...(DFM_TYPE .EQ. 2) both spline and Legendre/Fourier...
C      ... do spline first...
         IF(ABS (ZN) .GT. 1) THEN
            ier = 1
         ELSE
            ier = spline_eval( theta, zn, q1, qz1, qt1 )
               ! dq, dq/d(z), dq/d(theta)
         ENDIF
C     ...now do Legendre/Fourier, but first apply rotation 
C     for 2nd deformation (theta02)..
         CT = XD * RHIN
         ST = YD * RHIN
!---  apply rotation:  theta --> theta + theta02
         ctx = ct
         ct  = ct * costheta02 + st  * sintheta02
         st  = st * costheta02 - ctx * sintheta02
         theta = datan2(ST,CT)
         IF (THETA .LT. 0.0d0) THETA = THETA + 2.0d0*PI
         IF ( nfour .eq. 0 ) THEN
            CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
     1      DEFC (NLEG * NFOUR + NLEG + 1), Q2, QT2, QZ2, IER, 1)
         ELSE
            CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
     1      DEFC (NLEG * NFOUR + NLEG + 1), Q2, QT2, QZ2, IER, nfour)
         ENDIF

C     rescale deformation and derivatives..
         q  = q1 * dfm_scale + q2 * dfm2_scale
         qt = qt1 * dfm_scale + qt2 * dfm2_scale 
         qz = qz1 * dfm_scale + qz2 * dfm2_scale 

      ENDIF
C

      IF (IER .GT. 1 .OR. IER .LT. 0) GO TO 60
      IF (IER .EQ. 1) GO TO 40

      F = DBLE (RHO - RC) - Q
      IF(ABS(F) .LT. TS) GO TO 30
      IT = IT + 1
      IF (IT .LE. 5) GO TO 10
C
C  KODE = 9 : TOO MANY ITERATIONS
      KODE = 9
      GO TO 70
C
30    CONTINUE
C  EVALUATE THE GRADIENT
      XG = RHIN * (XD + RHIN * QT * YD)
      YG = RHIN * (YD - RHIN * QT * XD)
      ZG = PZK * RCIN - PHIL * QZ
      GO TO 70
C
40    CONTINUE
      IF (ZN) 45, 60, 47
C
C  KODE = 5: LEFT STOP ERROR
45    KODE = 5
      GO TO 70
C
C  KODE = 6 : RIGHT STOP ERROR
47    KODE = 6
      GO TO 70
C
50    CONTINUE
C  KODE = 8 : EXCESSIVE DEFORMATION OR ZERO DIVIDE
      KODE = 8
      GO TO 70
C
60    CONTINUE
C  KODE = 12 : UNDETERMINED ERROR
      KODE = 12
      WRITE (8, 1000) IER, ZN
      GO TO 70
C
70    CONTINUE
      RETURN
1000  FORMAT (' ICLEG4 ERROR : UNDETERMINED ERROR - IER = ', I5,
     1 ' ZN =', F11.7)
      END



