!+
!KWIC iczern.f
!
!$Id: iczern.f,v 1.2 2004/03/17 21:23:36 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   96-Jun-05[T. Gaetz]
!      . /COMIC/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE ICZERN (R2, K, P, TEL, KODE)
C
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    ICZERN FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 07/01/80
C    *
C    *    UPDATE:   10/22/80
C    *    TIME:     09:01:06
C    *
C    ******************************************/
C
C  ITERATIVELY CORRECT FOR THE ZERNIKE DEFORMATIONS
C  OF AN OPTICAL SURFACE
C
C  INPUT ARGUMENTS:
C    R2   : R*8 - CONSTANT TERM OF SURFACE EQUATION
C    K    : R*8 - 1 / 2 LINEAR TERM IN SURFACE EQUATION
C    P    : R*8 - CONIC CONSTANT = 1 - ECCENTRICITY ** 2
C    KODE : I*4 - INDICATOR SHOWING HOW RAY IS TO INTERSECT SURFACE
C        (SEE COZERN)
C
C  INPUT VIA LABELED COMMON /COMIC/:
C    XD   : R*8 - X COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    YD   : R*8 - Y COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    ZD   : R*8 - Z COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    XL   : R*8 - X COMPONENT OF INPUT DIRECTION
C    YL   : R*8 - Y COMPONENT OF INPUT DIRECTION
C    ZL   : R*8 - Z COMPONENT OF INPUT DIRECTION
C    PHIL : R*8 - 1 / R2S (CALCULATED IN VINIT)
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    DEF2 : R*8 - SUM OF THE SQUARES OF THE DEFORMATION COEFFICIENTS
C
C  OUTPUT ARGUMENTS:
C    TEL  : R*8 - TOTAL DISTANCE CORRECTION
C    KODE : I*4 - INDICATOR SHOWING HOW RAY INTERSECTED SURFACE
C        (SEE COZERN)
C
C  OUTPUT VIA LABELED COMMON /COMIC/:
C    XD : R*8 - X COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    YD : R*8 - Y COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    ZD : R*8 - Z COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    XG : R*8 - X COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C    YG : R*8 - Y COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C    ZG : R*8 - Z COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C
C  EXTERNAL REFERENCES: ABZERN
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DOUBLE PRECISION K
      DOUBLE PRECISION DEL, F, FDOT, TS, XN, YN, ZAP
      DOUBLE PRECISION XAP, YAP

      include 'saosacLib/comic.h'     ! xd,yd,zd,xl,yl,zl,xg,yg,zg,phil
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs

C
      RHOS = XD ** 2 + YD ** 2
      PZK = P * ZD - K
      DEL = DBLE (RHOS) + DBLE (PZK) ** 2 + DBLE (ZD) ** 2 + 1.0
      TS = DEL * 1.0E-14 + DEF2 * 1.0E-05
      TEL = 0.0
C
      IT = 0
      GO TO 20
10    CONTINUE
      FDOT = XG * XL + YG * YL + ZG * ZL
      IF (ABS (FDOT * DEL ) .LT. ABS (F + F)) GO TO 40
C
C  EVALUATE AND USE DEL
C
      DEL = - F / (FDOT + FDOT)
      TEL = TEL + DEL
      XD = XD + DEL * XL
      YD = YD + DEL * YL
      ZD = ZD + DEL * ZL
      RHOS = XD ** 2 + YD ** 2
20    CONTINUE
C
C  EVALUATE THE SURFACE FUNCTION F
C
      XN = XD*PHIL
      YN = YD*PHIL
      CALL ABZERN (XN, YN, ZAP, XAP, YAP, IER)
      IF (IER .GT. 1 .OR. IER .LT. 0) GO TO 50
      IF (IER .EQ. 1) GO TO 30
      ZF = ZD - ZAP
      PZK = P*ZF - K
      XG = XD - XAP * PZK * PHIL
      YG = YD - YAP * PZK * PHIL
      ZG = PZK
      RCS = R2 + ZF * (K - PZK)
      F = RHOS - RCS
      IF(ABS(F) .LT. TS) GO TO 60
      IT = IT + 1
      IF (IT .LE. 5) GO TO 10
C
C  KODE = 9 : TOO MANY ITERATIONS
      KODE = 9
      GO TO 60
C
30    CONTINUE
C  KODE = 6 : (XN, YN) IS OUTSIDE THE UNIT DISK
      KODE = 6
      GO TO 60
C
40    CONTINUE
C  KODE = 8 : EXCESSIVE DEFORMATION OR ZERO DIVIDE
      KODE = 8
      GO TO 60
C
50    CONTINUE
C  KODE = 12 : UNDETERMINED ERROR
      KODE = 12
      WRITE (8, 1000) IER
      GO TO 60
C
60    CONTINUE
      RETURN
1000  FORMAT (' ICZERN ERROR : UNDETERMINED ERROR - IER = ', I5)
      END
