!+
!KWIC legend.f
!
!$Id: legend.f,v 1.1 2004/03/16 15:49:55 dtn Exp $
!
!Revisions:
!   95-Jan-23[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO ALLOW LEGENDRE POLYNOMIALS FROM ORDER 24 (I.E.,
!        !  25 TERMS) TO ORDER 100 (I.E., 101 TERMS)
!        !  (COMMENTS CHANGED WHERE APPROPRIATE, ALSO)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE LEGEND (NP, ZN, PL, QL, IER)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    LEGEND FORTRAN
C    *    WRITTEN BY PHILIP GRIBOSKY
C    *            ON 08/28/80
C    *
C    *    UPDATE:   08/29/80
C    *    TIME:     15:59:11
C    *
C    ******************************************/
C
C  EVALUATE LEGENDRE POLYNOMIALS AND THEIR DERIVATIVES
C
C  INPUT ARGUMENTS:
C    NP : I*4 - NUMBER OF LEGENDRE TERMS DESIRED
C    ZN : R*8 - NORMALIZED Z COORD. = 2*Z/L WHERE L = LENGTH OF SURFACE
C
C  OUTPUT ARGUMENTS:
C    PL  : R*8 - ARRAY (NP) VALUES OF LEGENDRE POLYNOMIALS
C    QL  : R*8 - ARRAY (NP) DERIVATIVES OF PL WRT ZN
C    IER : I*4 - ERROR CODE
C        : 0 - NO ERROR
C        : 2 - NP = 0, WARNING, NP RESET TO 1
C        : 4 - NP > NMAX, WARNING, NP RESET TO NMAX = 101
C        : 6 - NP < 0, FATAL ERROR
C        : IER + 1 - ZN OUTSIDE OF RANGE
C
C  NOTE : THE RECURSION RELATIONS USED IN LEGEND ARE FROM CHAPTER 11 OF
C
C         'AN INTRODUCTION TO LINEAR ANALYSIS'  WRITTEN BY
C         KREIDER, KULLER, OSTBERG, AND PERKINS
C         ADDISON - WESLEY PUBLISHING COMPANY ;  READING, MASS., U.S.A.
C         COPYRIGHT 1966
C
C  EXTERNAL REFERENCES: INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      DIMENSION EN(101), HN(101), PL(NP), QL(NP)
C
      DATA EN /
     * -1.00D+00, 1.00D+00, 3.00D+00, 5.00D+00, 7.00D+00, 9.00D+00,
     *  1.10D+01, 1.30D+01, 1.50D+01, 1.70D+01, 1.90D+01, 2.10D+01,
     *  2.30D+01, 2.50D+01, 2.70D+01, 2.90D+01, 3.10D+01, 3.30D+01,
     *  3.50D+01, 3.70D+01, 3.90D+01, 4.10D+01, 4.30D+01, 4.50D+01,
     *  4.70D+01, 4.90D+01, 5.10D+01, 5.30D+01, 5.50D+01, 5.70D+01,
     *  5.90D+01, 6.10D+01, 6.30D+01, 6.50D+01, 6.70D+01, 6.90D+01,
     *  7.10D+01, 7.30D+01, 7.50D+01, 7.70D+01, 7.90D+01, 8.10D+01,
     *  8.30D+01, 8.50D+01, 8.70D+01, 8.90D+01, 9.10D+01, 9.30D+01,
     *  9.50D+01, 9.70D+01, 9.90D+01, 1.01D+02, 1.03D+02, 1.05D+02,
     *  1.07D+02, 1.09D+02, 1.11D+02, 1.13D+02, 1.15D+02, 1.17D+02,
     *  1.19D+02, 1.21D+02, 1.23D+02, 1.25D+02, 1.27D+02, 1.29D+02,
     *  1.31D+02, 1.33D+02, 1.35D+02, 1.37D+02, 1.39D+02, 1.41D+02,
     *  1.43D+02, 1.45D+02, 1.47D+02, 1.49D+02, 1.51D+02, 1.53D+02,
     *  1.55D+02, 1.57D+02, 1.59D+02, 1.61D+02, 1.63D+02, 1.65D+02,
     *  1.67D+02, 1.69D+02, 1.71D+02, 1.73D+02, 1.75D+02, 1.77D+02,
     *  1.79D+02, 1.81D+02, 1.83D+02, 1.85D+02, 1.87D+02, 1.89D+02,
     *  1.91D+02, 1.93D+02, 1.95D+02, 1.97D+02, 1.99D+02/
C
      DATA HN /
     *0.000000000000000D+00,1.000000000000000D+00,5.000000000000000D-01,
     *3.333333333333333D-01,2.500000000000000D-01,2.000000000000000D-01,
     *1.666666666666667D-01,1.428571428571428D-01,1.250000000000000D-01,
     *1.111111111111111D-01,1.000000000000000D-01,9.090909090909091D-02,
     *8.333333333333333D-02,7.692307692307693D-02,7.142857142857142D-02,
     *6.666666666666667D-02,6.250000000000000D-02,5.882352941176471D-02,
     *5.555555555555555D-02,5.263157894736842D-02,5.000000000000000D-02,
     *4.761904761904762D-02,4.545454545454546D-02,4.347826086956522D-02,
     *4.166666666666666D-02,4.000000000000000D-02,3.846153846153846D-02,
     *3.703703703703703D-02,3.571428571428571D-02,3.448275862068965D-02,
     *3.333333333333333D-02,3.225806451612903D-02,3.125000000000000D-02,
     *3.030303030303030D-02,2.941176470588235D-02,2.857142857142857D-02,
     *2.777777777777778D-02,2.702702702702703D-02,2.631578947368421D-02,
     *2.564102564102564D-02,2.500000000000000D-02,2.439024390243903D-02,
     *2.380952380952381D-02,2.325581395348837D-02,2.272727272727273D-02,
     *2.222222222222222D-02,2.173913043478261D-02,2.127659574468085D-02,
     *2.083333333333333D-02,2.040816326530612D-02,2.000000000000000D-02,
     *1.960784313725490D-02,1.923076923076923D-02,1.886792452830189D-02,
     *1.851851851851852D-02,1.818181818181818D-02,1.785714285714286D-02,
     *1.754385964912281D-02,1.724137931034483D-02,1.694915254237288D-02,
     *1.666666666666667D-02,1.639344262295082D-02,1.612903225806452D-02,
     *1.587301587301587D-02,1.562500000000000D-02,1.538461538461539D-02,
     *1.515151515151515D-02,1.492537313432836D-02,1.470588235294118D-02,
     *1.449275362318841D-02,1.428571428571429D-02,1.408450704225352D-02,
     *1.388888888888889D-02,1.369863013698630D-02,1.351351351351351D-02,
     *1.333333333333333D-02,1.315789473684210D-02,1.298701298701299D-02,
     *1.282051282051282D-02,1.265822784810127D-02,1.250000000000000D-02,
     *1.234567901234568D-02,1.219512195121951D-02,1.204819277108434D-02,
     *1.190476190476190D-02,1.176470588235294D-02,1.162790697674419D-02,
     *1.149425287356322D-02,1.136363636363636D-02,1.123595505617977D-02,
     *1.111111111111111D-02,1.098901098901099D-02,1.086956521739130D-02,
     *1.075268817204301D-02,1.063829787234043D-02,1.052631578947368D-02,
     *1.041666666666667D-02,1.030927835051546D-02,1.020408163265306D-02,
     *1.010101010101010D-02,1.000000000000000D-02/
C
      IF (NP .GE. 0) GO TO 10
      WRITE (8, 100)
      IER = 6
      GO TO 70
C
10    CONTINUE
      IF (NP .GT. 0) GO TO 20
      WRITE (8, 200)
      NP = 1
      IER = 2
      GO TO 40
C
20    CONTINUE
      IF (NP .GT. 101) GO TO 30
      IER = 0
      GO TO 40
C
30    CONTINUE
      WRITE (8, 300)
      NP = 21
      IER = 4
C
40    CONTINUE
      IF (ABS(ZN) .LE. 1.0) GO TO 50
      WRITE (8, 400)
      IER = IER + 1
C
50    CONTINUE
      PN = 1.0
      QN = 0.0
      QM = 0.0
      PL(1) = 1.0
      QL(1) = 0.0
      IF (NP .LT. 2 ) GO TO 70
      DO 60 N = 2, NP
      PM = PN
      QO = QM
      QM = QN
      QN = QO + EN(N) * PM
      PN = (ZN * QN - QM) * HN(N)
      QL(N) = QN
      PL(N) = PN
60    CONTINUE
C
70    CONTINUE
      RETURN
100   FORMAT ('- LEGEND ERROR : NP IS LESS THAN 0 ')
200   FORMAT ('- LEGEND ERROR : NP = 0 ; NP HAS BEEN RESET TO 1 ')
300   FORMAT ('- LEGEND ERROR : NP > 101; NP HAS RESET TO 101')
400   FORMAT ('- LEGEND ERROR : ABS(ZN) IS GREATER THAN 1 ')
      END
