!+
!KWIC linv3p.f
!
!$Id: linv3p.f,v 1.1 2004/03/16 15:49:56 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !
!        !  UPDATED 5/9/88 TO ALLOW FOR 500x500, INSTEAD OF 105x105
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!   93-Nov-10[T. Gaetz]
!      . change a(), b() to assumed size arrays in order to compilation
!        and running with bounds-checking on.
!-

      SUBROUTINE LINV3P (A, B, IJOB, N, IER)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    LINV3P FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 01/28/88
C    *
C   /******************************************/
C
C  PURPOSE: ALLOW A CALL TO THE IMSL ROUTINE LINV3P TO BE REPLACED
C           (TRANSPARENTLY TO THE USER) BY A CALL TO CMLIB ROUTINES,
C           SO THAT THE IMSL LIBRARY NEED NOT BE AVAILABLE
C
C  RESTRICTIONS: THE PARAMETER IJOB MUST EQUAL 2 OR 3, MEANING
C                  THAT THE ROUTINE SOLVES THE EQUATION AX=B, WITH A
C                  REPLACED BY EITHER L S.T. A=(L)(L-TRANSPOSE)
C                  (IJOB=2), OR BY A-INVERSE (IJOB=3).  IN EITHER
C                  CASE, X REPLACES B.
C                ANY OTHER VALUE OF IJOB WILL GIVE AN IER VALUE OF 129.
C                N HAS A LIMIT OF 500.
C                THERE IS NO ERROR CODE FOR NUMERICAL PROBLEMS.
C                FINALLY, A IS NOT REPLACED AT ALL IN THIS VERSION,
C                  AS IT IS IN THE IMSL ROUTINE.
C
C  INPUT PARAMETERS:
C    A = INPUT/OUTPUT VECTOR OF LENGTH N*(N+1)/2.
C        ON INPUT, IT IS A POSITIVE SYMMETRIC MATRIX IN SYMMETRIC
C        STORAGE MODE.
C    B = INPUT/OUTPUT VECTOR OF LENGTH N.
C        ON INPUT, IT IS THE VECTOR B IN THE EQUATION AX=B.
C    IJOB = OPTION FLAG (ONLY 2 OR 3 IS ALLOWED)
C    N = RANK OF THE EQUATION (SEE RESTRICTIONS ABOVE)
C
C  OUTPUT PARAMETERS:
C    A = UNCHANGED (SEE RESTRICTIONS ABOVE)
C    B = THE SOLUTION, X
C    IER = ERROR FLAG (SEE RESTRICTIONS ABOVE)
C          0   = NO PROBLEMS
C          129 = INVALID IJOB
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION A (*), B (*)
      DIMENSION A2D (500, 500), JPVT (500), QRAUX (500), WORK (500)
      DIMENSION X (500), RSD (500)
      DATA LDA /500/
C
C
C  CHECK FOR IJOB = 2 OR 3
C
      IF (IJOB .EQ. 2 .OR. IJOB .EQ. 3) GO TO 120
      IER = 129
      RETURN
C
C  UNPACK THE MATRIX A AND FIND ITS LARGEST ELEMENT
C
120   IER = 0
      NDX = 0
      ALRGST = 0.D0
      DO 190 I = 1, N
      DO 180 J = 1, I
      NDX = NDX + 1
      A2D (I, J) = A (NDX)
      A2D (J, I) = A2D (I, J)
      COMP = DABS (A2D (I, J))
      ALRGST = DMAX1 (ALRGST, COMP)
180   CONTINUE
190   CONTINUE
C
C  DETERMINE THE Q-R FACTORIZATION
C
      TOL = 1.D-12 * ALRGST
      CALL DQRANK (A2D, LDA, N, N, TOL, KR, JPVT, QRAUX, WORK)
C
C  DETERMINE X
C
      CALL DQRLSS (A2D, LDA, N, N, KR, B, X, RSD, JPVT, QRAUX)
C
C  COPY THE RESULTS TO B AND RETURN
C
      DO 250 I = 1, N
      B (I) = X (I)
250   CONTINUE
      RETURN
      END
