!+
!KWIC lkin2.f
!
!$Id: lkin2.f,v 1.1 2004/03/16 15:49:56 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO GO FROM 101x101 TO 1001x1001 PIXELS
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE LKIN2 (IMODE, FOGOUT, IPXOUT, IFLOUT, IB, IT, JB, JT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    LKIN2 FORTRAN
C    *    WRITTEN BY P. GLENN M/S 241 X (203) 797-5768
C    *            ON 02/09/82
C    *
C    *    UPDATE:   03/16/82
C    *    TIME:     13:56:46
C    *
C    ******************************************/
C
C  PURPOSE : TO READ THE LAST TWO OR THREE LINES FROM THE 'LOOK' FILE
C
C  INPUT PARAMETER :
C    IMODE : I*4 - 0 = READ PARAMETERS FROM TERMINAL (FILE 5)
C                  1 = READ PARAMETERS FROM FILE (FILE 1)
C
C  OUTPUT PARAMETERS :
C    FOGOUT : R*8 - OUTPUT PIXEL ARRAY DEFINITION ARRAY
C    IPXOUT : I*4 - 0 = NO PIXEL ENERGY OUTPUT
C                   1 = YES
C    IFLOUT : I*4 - 0 = NO PIXEL ARRAY FILE OUTPUT
C                   1 = YES
C    (NEXT FOUR PARAMETERS OUTPUT ONLY IF IPXOUT = 1)
C    IB : I*4 - LOWER I INDEX OF PIXELS TO BE OUTPUT
C    IT : I*4 - UPPER I INDEX
C    JB : I*4 - LOWER J INDEX
C    JT : I*4 - UPPER J INDEX
C
C  INPUT VIA # 2 :
C    'LOOK' FILE
C
C  INPUT VIA # 5 :
C    TERMINAL INPUT
C
C  XR : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      DOUBLE PRECISION FOGOUT (6)
      COMMON /LIMITS/ NAREA, NDEFN, NDTOT, NGRID, NTABG, NTABR, NTABF
C
C  READ AND CHECK THE PARAMETERS
      IF (IMODE .EQ. 0) GO TO 500
C
C  INPUT FROM TERMINAL
120   CONTINUE
      READ (5, 9010) (FOGOUT (I), I = 1, 4), NXOUT, NYOUT
      FOGOUT (5) = NXOUT
      FOGOUT (6) = NYOUT
      IF (DABS (FOGOUT (1)) .GT. 1000.D0) GO TO 150
      IF (DABS (FOGOUT (2)) .GT. 1000.D0) GO TO 150
      IF (FOGOUT (3) .LE. 0.D0 .OR. FOGOUT (3) .GT. 1000.D0) GO TO 150
      IF (FOGOUT (4) .LE. 0.D0 .OR. FOGOUT (4) .GT. 1000.D0) GO TO 150
!     IF (NXOUT .LT. 1 .OR. NXOUT .GT. 101) GO TO 150
!     IF (NYOUT .LT. 1 .OR. NYOUT .GT. 101) GO TO 150
      IF (NXOUT .LT. 1 .OR. NXOUT .GT. NGRID) GO TO 150
      IF (NYOUT .LT. 1 .OR. NYOUT .GT. NGRID) GO TO 150
      GO TO 200
150   CONTINUE
      GO TO 120
200   CONTINUE
      READ (5, 9040) IPXOUT, IFLOUT
      IF (IPXOUT .NE. 0 .AND. IPXOUT .NE. 1) GO TO 250
      IF (IFLOUT .NE. 0 .AND. IFLOUT .NE. 1) GO TO 250
      GO TO 300
250   CONTINUE
      GO TO 200
300   CONTINUE
      IF (IPXOUT .EQ. 0) GO TO 1000
      READ (5, 9070) IB, IT, JB, JT
      IF (IB .LT. 1 .OR. IB .GT. IT .OR. IT .GT. NXOUT) GO TO 350
      IF (JB .LT. 1 .OR. JB .GT. JT .OR. JT .GT. NYOUT) GO TO 350
      GO TO 1000
350   CONTINUE
      GO TO 300
C
C  INPUT FROM 'LOOK' FILE
500   READ (1, 9010) (FOGOUT (I), I = 1, 4), NXOUT, NYOUT
      FOGOUT (5) = NXOUT
      FOGOUT (6) = NYOUT
      IF (DABS (FOGOUT (1)) .GT. 1000.D0) GO TO 2000
      IF (DABS (FOGOUT (2)) .GT. 1000.D0) GO TO 2000
      IF (FOGOUT (3) .LE. 0.D0 .OR. FOGOUT (3) .GT. 1000.D0) GO TO 2000
      IF (FOGOUT (4) .LE. 0.D0 .OR. FOGOUT (4) .GT. 1000.D0) GO TO 2000
      IF (NXOUT .LT. 1 .OR. NXOUT .GT. 101) GO TO 2000
      IF (NYOUT .LT. 1 .OR. NYOUT .GT. 101) GO TO 2000
      READ (1, 9040) IPXOUT, IFLOUT
      IF (IPXOUT .NE. 0 .AND. IPXOUT .NE. 1) GO TO 2010
      IF (IFLOUT .NE. 0 .AND. IFLOUT .NE. 1) GO TO 2010
      IF (IPXOUT .EQ. 0) GO TO 1000
      READ (1, 9070) IB, IT, JB, JT
      IF (IB .LT. 1 .OR. IB .GT. IT .OR. IT .GT. NXOUT) GO TO 2020
      IF (JB .LT. 1 .OR. JB .GT. JT .OR. JT .GT. NXOUT) GO TO 2020
C
1000  RETURN
C
2000  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 9020) FOGOUT
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 9050) IPXOUT, IFLOUT
      STOP 8
2020  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 9080) IB, IT, JB, JT
      STOP 8
C
9000  FORMAT (/'  ENTER XCEN, YCEN, LX, LY, NX, NY (4 REAL, 2 INTEGER)')
9010  FORMAT (4D15.0, 2I6)
9020  FORMAT ('  LKIN2 ERROR - ILLEGAL FOCAL PLANE PARAMETER(S) :'/
     1  1P,6D12.5)
9030  FORMAT ('  ENTER (0 OR 1) FOR PIXEL OUTPUT AND FILE OUTPUT')
9040  FORMAT (2I6)
9050  FORMAT ('  LKIN2 ERROR - ILLEGAL OUTPUT FLAG(S) :', 2I6)
9060  FORMAT ('  ENTER I-INDEX (BOT, TOP) AND J-INDEX (BOT, TOP)')
9070  FORMAT (4I6)
9080  FORMAT ('  LKIN2 ERROR - ILLEGAL PIXEL INDEX PARAMETER(S) :' /
     1  4I6)
      END
