!+
!KWIC lmult.f
!
!$Id: lmult.f,v 1.2 2004/03/17 21:23:37 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-
      SUBROUTINE LMULT (JV, KV, LV)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    LMULT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/05/81
C    *
C    *    UPDATE:   05/05/81
C    *    TIME:     14:56:05
C    *
C    ******************************************/
C
C  PURPOSE :
C     TO LEFT-MULTIPLY A VECTOR TRANSPOSE BY A MATRIX
C
C  INPUT ARGUMENTS :
C     JV :  V# OF VECTOR TRANSPOSE FOR MULTIPLICATION
C     KV :  V# OF START OF MATRIX ROWS FOR MULTIPLICATION
C     LV :  V# OF RESULTANT VECTOR (TRANSPOSE)
C
C  OUTPUT :
C     VIA V# (LV) :  RESULTANT VECTOR (TRANSPOSE)
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER          JV, KV, LV
C
C  PERFORM ALL CALCULATIONS
      XV (LV) = XV (JV) * XV (KV) + YV (JV) * XV (KV + 1)
     1                            + ZV (JV) * XV (KV + 2)
      YV (LV) = XV (JV) * YV (KV) + YV (JV) * YV (KV + 1)
     1                            + ZV (JV) * YV (KV + 2)
      ZV (LV) = XV (JV) * ZV (KV) + YV (JV) * ZV (KV + 1)
     1                            + ZV (JV) * ZV (KV + 2)
      RETURN
      END
