!+
!KWIC lrgsml.f
!
!$Id: lrgsml.f,v 1.2 2004/03/17 21:23:37 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO FIX A BUG THAT CAUSED PROBLEMS WHEN
!        !  DIVERGENT ACV'S WERE DEFINED ANYWHERE BEFORE THE FINAL SURFACE
!        !    NOTE - THERE WAS A VERSION OF THIS ROUTINE DELIVERED AS A
!        !           MODIFICATION TO VERSION 5.  THE CURRENT MODIFICATION
!        !           IGNORES THE FAULTY MODIFICATIONS MADE THERE, AND WORKS
!        !           WITH THE ORIGINAL VERSION DELIVERED FOR VERSION 4.
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/1/91 TO FIX A BUG THAT CAUSED THE PROGRAM TO USE
!        !  THE FULL LARGE AMPLITUDE THEORY UNNECESSARILY WHEN THERE
!        !  WERE BOTH SURFACES WITH NO SCATTERING AND SURFACES WITH SCATTERING
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!        !  LORENTZIAN PSD (METHOD 110)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-
!
!  UPDATED 12/6/88 TO FIX A BUG THAT CAUSED PROBLEMS WHEN
!  DIVERGENT ACV'S WERE DEFINED ANYWHERE BEFORE THE FINAL SURFACE.
!  THE FIX INVOLVED RESTRUCTURING THE CODE, AND SO CHANGES ARE NOT
!  SHOWN WITH EXCLAMATION POINTS.
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 12/20/88 TO PUT A RETURN STATEMENT IN (COSMETIC CHANGE
!  ONLY - DID NOT CAUSE A PROBLEM)
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE LRGSML (IAMPL)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    LRGSML FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/20/88
C    *
C   /******************************************/
C
C  PURPOSE: DETERMINE WHETHER TO USE THE LARGE OR SMALL AMPLITUDE
C           SCATTER THEORY FOR THE CURRENT RAY (IF THE SMALL
C           AMPLITUDE THEORY IS USED, DEDRIQ CALCULATES AS
C           ORIGINALLY DESIGNED - IF THE LARGE AMPLITUDE THEORY
C           IS USED, IT IS USED FOR EACH SURFACE)
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZK : R*4 - SYSTEM WAVENUMBER
C    ZW (I) : R*4 - ARRAY OF RAY WEIGHTS
C    DP0 (I) : ARRAY OF SINS OF GRAZING ANGLES
C    DP1S (I) : R*4 - ARRAY OF SAGGITAL DERIVATIVES OF DP0
C    DP1T (I) : R*4 - ARRAY OF TANGENTIAL DERIVATIVES OF DP0
C    SFX,SFY,TFX,TFY (I) : ARRAYS OF SUSEQ SCALE FACTORS
C
C  INPUT VIA DATA VALUES :
C    VZLIM : R*8 - VZ**2*SIGMA**2 THRESHHOLD FOR LARGE AMPL THEORY
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - ARRAY OF SCATTER DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    SIGSQ (I, J) : R*4 - ARRAY OF VALUES OF SIGMA ** 2
C
C  OUTPUT PARAMETER:
C    IAMPL: I*4 - 0 = USE THE SMALL AMPLITUDE THEORY
C                 1 = USE THE LARGE AMPLITUDE THEORY
C                 IAMPL IS SET TO 1 IFF
C                  (A) VZ**2*SIGMA**2 IS > VZLIM FOR AT LEAST
C                      ONE SURFACE, AND
C                  (B) NO SURFACE USES A GRATING, A PSD, OR A
C                      DIVERGENT AUTOCOVARIANCE FUNCTION
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    VZSIMX (I, J) : R*8 - MAXIMUM VALUE OF VZ**2 * SIGMA**2 FOR EACH
C                          METHOD I AND SURFACE J
!    (VZSIMX IS UPDATED ONLY FOR NON-DIVERGENT AUTOCOVARIANCE
!     FUNCTIONS, AND ONLY UNTIL IT IS DETERMINED THAT THE SMALL
!     AMPLITUDE THEORY WILL BE USED, SINCE THE NON-DIVERGENT
!     AUTOCOVARIANCE FUNCTIONS ARE THE ONLY ONES WHICH HAVE A
!     CHANCE OF USING THE LARGE AMPLITUDE SCATTERING THEORY,
!     IN WHICH CASE VZSIMX WOULD NOT BE UPDATED ELSEWHERE.)
!
!  OUTPUT VIA LABELED COMMON /PARAMS/ :
!    METARR (I) : I*4 - SCATTERING METHOD NUMBER
C
C  XR: SCTDEF
C
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DATA VZLIM /0.20D0/
C
C
C  LOOP OVER ALL THE SURFACES
!  (THIS LOOP HAS BEEN MADE TWO SEPARATE LOOPS TO ALLOW METARR
!  TO BE FOUND REGARDLESS OF WHETHER THE LARGE AMPLITUDE OR SMALL
!  AMPLITUDE APPROACH IS EVENTUALLY CHOSEN)
C
      DO 110 I = 1, NS
      KURF = I
C
C  DETERMINE WHICH USER SURFACE SPECIFICATION IS CALLED FOR
C
      CALL SCTDEF (METH)
      METARR (KURF) = METH
110   CONTINUE
!
!  LOOP OVER THE SURFACES AGAIN TO DECIDE ON THE OVERALL APPROACH
!  (LARGE AMPLITUDE OR SMALL AMPLITUDE)
!
      IGTLIM = 0
      DO 150 I = 1, NS
      KURF = I
      METH = METARR (KURF)
C
C  IF THIS SURFACE USES A DESCRIPTION OTHER THAN A NON-DIVERGENT
C  AUTOCOVARIANCE FUNCTION (OR PERFECT), THEN USE SMALL AMPLITUDE
!  (CHANGE THE BRANCHING IF METH = 0)
C
!     IF (METH .EQ. 0) GO TO 120
      IF (METH .EQ. 0) GO TO 150
      NSYS = SDEF (1, METH)
!
!  (ALLOW FOUR MORE MODELS)
!      IF (NSYS .NE. 5 .AND. NSYS .NE. 6) GO TO 200
      IF (NSYS .NE. 5 .AND. NSYS .NE. 6 .AND.
     *  NSYS .NE. 9 .AND. NSYS .NE. 10 .AND. NSYS .NE. 11 .AND.
     *  NSYS .NE. 12) GO TO 200
C
C  DETERMINE VZ**2*SIGMA**2, AND SET THE FLAG IF > VZLIM
C
120   ZKSQ = ZK * ZK
      CTH = DP0 (KURF)
      CTHSQ = CTH * CTH
      VZSSQ = 4. * ZKSQ * CTHSQ *
     1  (SIGSQ (1, METH) + SIGSQ (2, METH) + SIGSQ (3, METH))
      IF (VZSSQ .GT. VZLIM) IGTLIM = 1
C
C  UPDATE THE MAX VALUE OF VZ**2*SIGMA**2
C
      VZSIMX (METH, KURF) = DMAX1 (VZSIMX (METH, KURF), VZSSQ)
150   CONTINUE
C
C  IF THE LOOP IS COMPLETED BUT THERE ARE NO SURFACES
C  WITH VZ**2*SIGMA**2 > VZLIM, THEN USE SMALL AMPLITUDE
C
      IF (IGTLIM .EQ. 0) GO TO 200
C
C  ELSE USE LARGE AMPLITUDE SCATTERING THEORY
C
      IAMPL = 1
      GO TO 250
C
C  USE SMALL AMPLITUDE SCATTERING THEORY
C
200   IAMPL = 0
C
250   RETURN
      END
