!+
!KWIC mmult.f
!
!$Id: mmult.f,v 1.2 2004/03/17 21:23:38 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-
      SUBROUTINE MMULT (JV, KV, LV)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    MMULT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/05/81
C    *
C    *    UPDATE:   05/05/81
C    *    TIME:     15:11:25
C    *
C    ******************************************/
C
C  PURPOSE :  TO MATRIX MULTIPLY TWO MATRICES
C
C  INPUT ARGUMENTS :
C     JV :  V# OF START OF FIRST MATRIX
C     KV :  V# OF START OF SECOND MATRIX
C     LV :  V# OF START OF RESULTANT MATRIX
C
C  OUTPUT :
C     VIA V# (LV, LV + 1, LV + 2) :  (MATRIX JV) * (MATRIX KV)
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER JV, KV, LV
      INTEGER J
C
C
C  PERFORM ALL CALCULATIONS
      DO 100 J = 1, 3
      XV (LV + J - 1) = XV (JV + J - 1) * XV (KV)
     1                + YV (JV + J - 1) * XV (KV + 1)
     2                + ZV (JV + J - 1) * XV (KV + 2)
      YV (LV + J - 1) = XV (JV + J - 1) * YV (KV)
     1                + YV (JV + J - 1) * YV (KV + 1)
     2                + ZV (JV + J - 1) * YV (KV + 2)
      ZV (LV + J - 1) = XV (JV + J - 1) * ZV (KV)
     1                + YV (JV + J - 1) * ZV (KV + 1)
     2                + ZV (JV + J - 1) * ZV (KV + 2)
100   CONTINUE
      RETURN
      END
