!+
!KWIC mtvmul.f
!
!$Id: mtvmul.f,v 1.2 2004/03/17 21:23:38 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-

      SUBROUTINE MTVMUL (JV, KV, LV)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    MTVMUL FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/7/88
C    *
C   /******************************************/
C
C  PURPOSE : TO MULTIPLY A VECTOR BY THE TRANSPOSE OF A MATRIX
C
C  INPUT ARGUMENTS :
C     JV :  V# OF START OF MATRIX
C     KV :  V# OF VECTOR
C     LV :  V# OF RESULTANT VECTOR
C
C  OUTPUT :
C     VIA V# (LV) :  (MATRIX JV)(TRANSPOSE) * (VECTOR KV)
C
C
      IMPLICIT NONE

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER JV, KV, LV
C
C
C  PERFORM ALL CALCULATIONS
C
      XV (LV) = XV (JV    ) * XV (KV)
     1        + XV (JV + 1) * YV (KV)
     2        + XV (JV + 2) * ZV (KV)
      YV (LV) = YV (JV    ) * XV (KV)
     1        + YV (JV + 1) * YV (KV)
     2        + YV (JV + 2) * ZV (KV)
      ZV (LV) = ZV (JV    ) * XV (KV)
     1        + ZV (JV + 1) * YV (KV)
     2        + ZV (JV + 2) * ZV (KV)
      RETURN
      END
