!+
!KWIC newton.f
!
!$Id: newton.f,v 1.1 2004/03/16 15:49:58 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 2/12/93 TO EXIT (WITHOUT FLAGGING A WARNING) AT THE
!        !  CURRENT X-POSITION IF THE DERIVATIVE IS SMALLER THAN 10^-37
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE NEWTON (METH, X, YTARG, EPS, XBAR, Y0)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    NEWTON FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/14/81
C    *
C    *    UPDATE:   10/13/81
C    *    TIME:     13:15:45
C    *
C    ******************************************/
C
C  USE NEWTON'S METHOD TO FIND A FUNCTION ARG THAT GIVES DESIRED VALUE
C
C  INPUT PARAMETERS :
C    METH  : I*4 - SDEF ARRAY INDEX TO BE PASSED TO EEVAL FOR METHOD #
C    X     : R*4 - INITIAL GUESS OF FUNCTION ARGUMENT
C    YTARG : R*4 - DESIRED FUNCTION VALUE
C    EPS   : R*4 - AMOUNT BY WHICH FINAL VALUE MAY MISS TARGET VALUE
C
C  OUTPUT PARAMETERS :
C    XBAR  : R*4 - FUNCTION ARGUMENT
C    Y0    : R*4 - FUNCTION VALUE
C
C    XR : EEVAL, INCLIN
C
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      X0 = X
      IFLG = -1
C
100   IF (IFLG .EQ. -1) GO TO 200
C  (NOT THE INITIALIZATION RUN)
      IF ((Y0 - YTARG) * YPRM .GT. 0.) GO TO 160
C  (X0 IS TOO LOW)
      IF (XBAR .LT. XL) GO TO 120
      XL = XBAR
      X0 = XBAR
      GO TO 190
120   X0 = 0.5 * (XL + XH)
      GO TO 190
C  (X0 IS TOO HIGH)
160   IF (XBAR .GT. XH) GO TO 180
      XH = XBAR
      X0 = XBAR
      GO TO 190
180   X0 = 0.5 * (XL + XH)
190   CALL EEVAL (METH, X0, 1, YPRM, DUM1, DUM2, DUM3)
				!*** was dum,dum,dum
!
!  BAG IT NOW IF THE DERIVATIVE IS NEAR ZERO
!  (QUIT WITHOUT DISPLAYING ANY ERROR)
!
      IF (DABS (YPRM) .LT. 1.D-37) GO TO 340
!
      ICNT = ICNT + 1
      GO TO 300
C  (INITIALIZATION RUN)
200   CALL EEVAL (METH, X0, 0, Y0, DUM1, DUM2, DUM3)
				!*** was dum,dum,dum
      IF (ABS (Y0 - YTARG) .LT. EPS) GO TO 400
      IFLG = 0
      ICNT = 1
      CALL EEVAL (METH, X0, 1, YPRM, DUM1, DUM2, DUM3)
				!*** was dum,dum,dum
!
!  BAG IT NOW IF THE DERIVATIVE IS NEAR ZERO
!  (QUIT WITHOUT DISPLAYING ANY ERROR)
!
      IF (DABS (YPRM) .LT. 1.D-37) GO TO 400
!
      IF ((Y0 - YTARG) * YPRM .GT. 0.) GO TO 220
      XL = X0
      XH = 1.D38   !*** CHANGED D60 TO D38  
      GO TO 300
220   XH = X0
      XL = -1.D38  !*** CHANGED D60 TO D38
C
300   XBAR = X0 + (YTARG - Y0) / YPRM
      CALL EEVAL (METH, XBAR, 0, Y0, DUM1, DUM2, DUM3)
				!*** was dum,dum,dum
      IF (ABS (Y0 - YTARG) .LT. EPS) GO TO 340
      IF (ICNT .EQ. 15) GO TO 320
      GO TO 500
C  (TOO MANY ITERATIONS)
320   CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8000) METH, YTARG, XBAR, Y0
      IFLG = 2
      GO TO 500
C  (ACCURACY CRITERION MET)
340   IFLG = 1
      GO TO 500
C  (ACCURACY CRITERION MET AT INITIAL GUESS)
400   IFLG = 1
      XBAR = X0
C
500   IF (IFLG .EQ. 0) GO TO 100
      RETURN
C
8000  FORMAT ('  NEWTON WARNING - 15 CYCLE LIMIT REACHED' /
     1  '  (METH, YTARG, XBAR, Y0) :', I6, 1P,3E12.4)
      END
