!+
!KWIC obscur.f
!
!$Id: obscur.f,v 1.2 2004/03/17 21:23:39 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-27[T. Gaetz]
!      . change dimension of LSW to (10, 21) for consistency w/ other routines
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . eliminate VDOT, RNRM - not used
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE OBSCUR (KP, LP, H, NORM, KX, LX, KKODE)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    OBSCUR FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 01/21/88
C    *
C   /******************************************/
C
C  PASSAGE OF A RAY THROUGH AN OBSCURATION
C
C  INPUT ARGUMENTS:
C    KP   : I*4 - IV# OF POSITION OF ENTERING RAY IN BCS
C    LP   : I*4 - IV# OF DIRECTION OF ENTERING RAY IN BCS
C    KX   : I*4 - IV# DESIRED FOR POSITION OF EXITING RAY IN BCS
C    LX   : I*4 - IV# DESIRED FOR DIRECTION OF EXITING RAY IN BCS
C    NORM : I*4 - IV# DESIRED FOR THE NORMAL TO THE OBSC IN BCS
C    KKODE : I*4 - RAY STATUS CODE:
C                 2 - INTERNAL REFLECTION
C
C  INPUT VIA LABELED COMMON /AXOFF/:
C    CB : R*8 - COS (ZROT8), WHERE ZROT8 IS THE RECT OBSC ROT ANGLE
C    SB : R*8 - SIN (ZROT8)
C
C  INPUT VIA LABELED COMMON /PARM/:
C    SURF (4,J) : INNER RADIUS OR X-WIDTH OF OBSCURATION
C    SURF (5,J) : OUTER RADIUS OR Y-WIDTH OF OBSCURATION
C    SURF (6,J) : ANGLE ABOUT Z OF RECTANGULAR OBSCURATION
C
C  INPUT VIA LABELED COMMON /PARX/:
C    KURF : I*4 - SURFACE NUMBER
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    SWITCH FOR SURFACE #J:
C    LSW (5, J) : F - NOT AN ANNULAR OBSCURATION, T - ANNULAR OBSC
C    LSW (6, J) : F - NOT A RECTANGULAR OBSC, T - RECTANGULAR OBSC
C    LSW (7, J) : F - "OBSC" IS AN OPENING, T - "OBSC" IS OPAQUE
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#S KP, LP
C
C  OUTPUT ARGUMENTS:
C    H    : R*8 - DISTANCE FROM V# KP TO V# KX
C    KKODE : I*4 - RAY STATUS CODE:
C                 0 - INCONSISTENT OR TAUTOLOGICAL EQUATION
C                 2 - INTERNAL REFLECTION
C                 6 - RAY WAS OBSCURED
C                 7 - NEGATIVE DISTANCE
C                 11 - UNDETERMINED ERROR ON INPUT
C                 12 - UNDETERMINED ERROR
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#S KX, LX, NORM
C
C  EXTERNAL REFERENCES: NONE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /AXOFF/ CB, CE, SB, SE, YEP
      DOUBLE PRECISION H
C
      IF (KKODE .LT. 1 .OR. KKODE .GT. 4) GO TO 500
C
      IF (ZV (LP) .EQ. 0.0D0) GO TO 550
C
C  FIND H, DISTANCE OF POINT ON INPUT RAY TO FLAT SURFACE
      H = - ZV (KP) / ZV (LP)
C
C  IS H NEGATIVE ?
      IF (H .LT. 0.0D0) GO TO 570
C
C  FIND POSITION VECTOR OF INTERSECTION OF RAY WITH FLAT SURFACE
      XV (KX) = XV (KP) + H * XV (LP)
      YV (KX) = YV (KP) + H * YV (LP)
      ZV (KX) = ZV (KP) + H * ZV (LP)
C
C  CHECK FOR THE RAY BEING OBSCURED - ROTATE (X,Y) (KX) ABOUT Z
      XCHECK =   XV (KX) * CB + YV (KX) * SB
      YCHECK = - XV (KX) * SB + YV (KX) * CB
      INSIDE = 0
      IF (LSW (6, KURF)) GO TO 200
C
C  OBSCURATION IS ANNULAR - CHECK FOR POINT INSIDE THE ANNULUS
      RCHECK = DSQRT (XCHECK * XCHECK + YCHECK * YCHECK)
      IF (RCHECK .GE. SURF (4, KURF) .AND. RCHECK .LE. SURF (5, KURF))
     *    INSIDE = 1
      GO TO 250
C
C  OBSCURATION IS RECTANGULAR - CHECK FOR POINT INSIDE THE RECTANGLE
200   IF ((DABS (XCHECK) .LE. SURF (4, KURF) / 2.D0) .AND.
     *    (DABS (YCHECK) .LE. SURF (5, KURF) / 2.D0))
     *    INSIDE = 1
C
C  RAY IS OBSCURED IF IT HIT THE OPAQUE AREA
250   IF ((INSIDE .EQ. 1 .AND. LSW (7, KURF)) .OR.
     *    (INSIDE .EQ. 0 .AND. (.NOT. LSW (7, KURF))))
     *    GO TO 300
C
C  SET THE NORMAL VECTOR
      XV (NORM) = 0.0D0
      YV (NORM) = 0.0D0
      ZV (NORM) = 1.0D0
C
C  TRANSMIT THE RAY STRAIGHT THROUGH
      XV (LX) = XV (LP)
      YV (LX) = YV (LP)
      ZV (LX) = ZV (LP)
      GO TO 600
C
C  RAY WAS OBSCURED
300   KKODE = 6
      GO TO 600
C
C  UNDETERMINED ERROR ON INPUT
500   KKODE = 11
      WRITE (8, 1010)
      GO TO 600
C
C  INCONSISTENT OR TAUTOLOGICAL EQUATION
550   KKODE = 0
      WRITE (8, 1020)
      GO TO 600
C
C  NEGATIVE PATH LENGTH
570   KKODE = 7
C
600   RETURN
1010  FORMAT ('-OBSCUR ERROR: UNDETERMINED ERROR ON INPUT')
1020  FORMAT ('-OBSCUR ERROR: INCONSISTENT OR TAUTOLOGICAL EQUATION')
      END
