#ifndef OSACBPIPE_H
#define OSACBPIPE_H

/****************************************************************************
 *
 * Source     : osacbpipe.h
 * Author     : Terry Gaetz
 *
 * Description: encapsulate bpipe stuff
 *
 */

#include "mst_fortran_charlen_t.h"
#include <bpipe/datatypes.h>

/*
 * Fortran interface
 */
#define ATTACH_BPIPE_F77 F77_FUNC_(attach_bpipe,ATTACH_BPIPE)
void  ATTACH_BPIPE_F77(char *in, char *out, int *db_extend,
		       int *fgoodrays,
                       mst_fortran_charlen_t ln_in,
                       mst_fortran_charlen_t ln_out );

#define DETACH_BPIPE_F77 F77_FUNC_(detach_bpipe,DETACH_BPIPE)
void DETACH_BPIPE_F77(void);

#define BPIPE_HEADER_INFO_F77 F77_FUNC_(bpipe_header_info,BPIPE_HEADER_INFO)
void BPIPE_HEADER_INFO_F77(char *idstring, int *surfno, int *goodrays_flag,
			   mst_fortran_charlen_t ln_idstring);

#define GET_RAY_F77 F77_FUNC_(get_ray,GET_RAY)
void  GET_RAY_F77(double   *r,            /* ray position  vector (3-vector)      */
		  double   *v,            /* ray direction vector (unit 3-vector) */
		  double   *wt,           /* ray weight                           */
		  double   *energy,       /* ray energy                           */
		  DComplex *c2,           /* polarization amplitude ("cosine")    */
		  DComplex *s2,           /* polarization amplitude ("sine")      */
		  int      *id,           /* ray identifier                       */
		  int      *raycode,      /* ray success code                     */
		  int      *err           /* 0 for success, nonzero for error     */
		  );

#define PUT_RAY_F77 F77_FUNC_(put_ray,PUT_RAY)
void PUT_RAY_F77(double   *r,            /* ray position  vector (3-vector)      */
		 double   *v,            /* ray direction vector (unit 3-vector) */
		 double   *norm,         /* surface normal at intercept          */
		 double   *intersect_bcs,/* intersection at BCS optics           */
		 double   *wt,           /* ray weight                           */
		 double   *energy,       /* ray energy                           */
		 double   *g_ang,        /* graze angle 9/19/97                  */
		 DComplex *c2,           /* polarization amplitude ("cosine")    */
		 DComplex *s2,           /* polarization amplitude ("sine")      */
		 int      *id,           /* ray identifier                       */
		 int      *raycode,      /* ray success code                     */
		 int      *ray_missed    /* surface hit code:  0 = hit, 1 = miss */
		 );

#endif /* OSACBPIPE_H */








