!+
!KWIC pchk1.f
!
!$Id: pchk1.f,v 1.1 2004/03/16 15:50:00 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO ADD EXPONENTIAL-EXPONENTIAL, EXPONENTIAL-
!        !  GAUSSIAN, AND GAUSSIAN-GAUSSIAN AUTOCOVARIANCE FUNCTIONS, WITH
!        !  EVERY TERM BEING MULTIPLIED BY A COSINE.
!        !  ALSO, PREVIOUS COSINE TERMS ARE IMPROVED BY CHECKING THAT THE
!        !  CONSTANT MULTIPLYING THE COSINE ARGUMENT IS SUFFICIENTLY SMALL.
!        !  (THIS ASSURES A POSITIVE G(V**2) AND ITS DERIVATIVE.)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!        !  LORENTZIAN PSD (METHOD 110)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE PCHK1 (J)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    PCHK1 FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/14/81
C    *
C    *    UPDATE:   03/08/82
C    *    TIME:     01:58:46
C    *
C    ******************************************/
C
C   CHECK SDEF PARAMETERS FOR DEFINITION # J
C
C  INPUT PARAMETER :
C    J : I*4 - EXPECTED DEFINITION NUMBER FOR SDEF DEFINITION
C
C  INPUT VIA LABELED COMMON /LIMITS/ :
C    NDTOT : I*4 - NUMBER OF ALLOWABLE USER METHOD NUMBERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    ACCG : R*4 - DESIRED ACCURACY OF G(V**2) LOOK-UP TABLE
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    METSYS (I) : I*4 - TABLE OF USER METHOD NUMBERS
C
C  OUTPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - PARAMETER # I FOR DEFINITION # J
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      COMMON /LIMITS/ NAREA, NDEFN, NDTOT, NGRID, NTABG, NTABR, NTABF
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DOUBLE PRECISION FOGR
C
C  READ DEFINITION NUMBER AND USER METHOD NUMBER
      READ (3, * ) NDTHIS, NMETH !*** changed to free format input
      IF (NDTHIS .NE. J) GO TO 7000
C  (SEE IF USER HAS USED A VALID USER NUMBER)
      NSYS = 0
      DO 120 K = 1, NDTOT
      IF (NMETH .NE. METSYS (K)) GO TO 110
      NSYS = K
      SDEF (1, J) = K
110   IF (NSYS .GT. 0) GO TO 140
120   CONTINUE
C
140   IF (NSYS .EQ. 0) GO TO 7100
!
!  ALLOW FOUR MORE USER METHODS
!      GO TO (1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800), NSYS
!
      GO TO (1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800,
     *       1900, 2000, 2100, 2200), NSYS
 
C
C  CASE: NSYS = 1 (USER METHOD # 101)
1100  READ (3, * ) (SDEF (K, J), K = 2, 5) !*** changed to free format
      DO 1110 K = 2, 5
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
1110  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) SDEF (3, J) = 1.
      IF (SDEF (4, J) .EQ. 0.) SDEF (5, J) = 1.
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (5, J) .LE. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (4, J) .EQ. 0.) GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 2 (USER METHOD # 102)
1200  READ (3, * ) (SDEF(K, J), K = 2, 5) !*** changed to free format input
      DO 1210 K = 2, 5
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
1210  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) SDEF (3, J) = 1.
      IF (SDEF (4, J) .EQ. 0.) SDEF (5, J) = 1.
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (5, J) .LE. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (4, J) .EQ. 0.) GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 3 (USER METHOD # 103)
1300  READ (3, * ) (SDEF (K, J), K = 2, 7) !*** changed to free format input
      DO 1310 K = 2, 7
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
1310  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) SDEF (3, J) = 1.
!
!  MAKE THE DEFAULT COSINE ARGUMENT MULTIPLIER ZERO
!      IF (SDEF (6, J) .EQ. 0.) SDEF (7, J) = 1.
      IF (SDEF (6, J) .EQ. 0.) SDEF (7, J) = 0.
      IF (SDEF (4, J) .EQ. 0. .AND. SDEF (6, J) .EQ. 0.)
     1  SDEF (5, J) = 1.
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (5, J) .LE. 0. .OR.
     1  SDEF (7, J) .LT. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (4, J) .EQ. 0. .AND.
     1  SDEF (6, J) .EQ. 0.) GO TO 7200
!  CHECK FOR NOT-TOO-LARGE COSINE ARGUMENT MULTIPLIER
      IF (SDEF (6, J) .GT. 0. .AND.
     *    SDEF (7, J) .GT. 0.414213D0 * SDEF (5, J)) GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 4 (USER METHOD # 104)
1400  READ (3, * ) (SDEF (K, J), K = 2, 7) !*** changed to free format input
      DO 1410 K = 2, 7
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
1410  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) SDEF (3, J) = 1.
!
!  MAKE THE DEFAULT COSINE ARGUMENT MULTIPLIER ZERO
!      IF (SDEF (6, J) .EQ. 0.) SDEF (7, J) = 1.
      IF (SDEF (6, J) .EQ. 0.) SDEF (7, J) = 0.
      IF (SDEF (4, J) .EQ. 0. .AND. SDEF (6, J) .EQ. 0.)
     1  SDEF (5, J) = 1.
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (5, J) .LE. 0. .OR.
     1  SDEF (7, J) .LT. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (4, J) .EQ. 0. .AND.
     1  SDEF (6, J) .EQ. 0.) GO TO 7200
!  CHECK FOR NOT-TOO-LARGE COSINE ARGUMENT MULTIPLIER
      IF (SDEF (6, J) .GT. 0. .AND.
     *    SDEF (7, J) .GT. 0.414213D0 * SDEF (5, J)) GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 5 (USER METHOD # 105)
1500  READ (3, * ) (SDEF (K, J), K = 2, 5) !*** changed to free format input
      DO 1510 K = 2, 5
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
1510  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) SDEF (3, J) = 1.
      IF (SDEF (4, J) .EQ. 0.) SDEF (5, J) = 1.
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (5, J) .LE. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (4, J) .EQ. 0.) GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 6 (USER METHOD # 106)
1600  READ (3, * ) (SDEF (K, J), K = 2, 3) !*** changed to free format input
      IF (SDEF (2, J) .LE. 0. .OR. SDEF (3, J) .LE. 0.) GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 7 (USER METHOD # 201)
1700  READ (3, * ) NSEGS !*** changed to free format input
      IF (NSEGS .LT. 1 .OR. NSEGS .GT. 5) GO TO 7200
      V0PRE = 0.
      SDEF (2, J) = NSEGS
C  (LOOP THROUGH EACH SEGMENT DEFINITION)
      DO 1780 K = 1, NSEGS
      NDX = 3 * K
      READ (3, * ) SDEF (NDX, J), SDEF (NDX + 1, J), SDEF (NDX + 2, J)
                        !*** changed to free format input
      IF (SDEF (NDX, J) .LE. V0PRE) GO TO 7200
      V0PRE = SDEF (NDX, J)
      IF (SDEF (NDX + 1, J) .LE. 0. .OR. SDEF (NDX + 2, J) .LE. 0.)
     1  GO TO 7200
      IF (K .GT. 1) GO TO 1760
      GOLD = SDEF (4, J) * SDEF (3, J) ** (- SDEF (5, J))
      GO TO 1770
1760  GOLD = SDEF (NDX - 2, J) * SDEF (NDX, J) ** (- SDEF (NDX - 1, J))
1770  GNEW = SDEF (NDX + 1, J) * SDEF (NDX, J) ** (- SDEF (NDX + 2, J))
      RELERR = ABS (GNEW - GOLD) / GOLD
      IF (RELERR .GT. ACCG) GO TO 7200
1780  CONTINUE
      SDEF (NDX + 3, J) = 1.D30   !*** CHANGED D60 TO D30
      GO TO 3000
C
C  CASE: NSYS = 8 (USER METHOD # 301)
1800  READ (3, * ) (SDEF (K, J), K = 2, 6), NU, NV !*** changed to free format
      IF (ABS (SDEF (6, J)) .GE. 90.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0.) SDEF (3, J) = 1.
      IF (SDEF (4, J) .EQ. 0.) SDEF (5, J) = 1.
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (5, J) .LE. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (4, J) .EQ. 0.) GO TO 7200
      IF (NU .LT. 1) NU = 3
      IF (NV .LT. 1) NV = 3
      IF (NU .GT. 50 .OR. NV .GT. 50) GO TO 7200
      SDEF (7, J) = NU
      SDEF (8, J) = NV
      GO TO 3000
C
C  CASE: NSYS = 9 (USER METHOD # 107)
1900  READ (3, * ) (SDEF (K, J), K = 2, 7)
      DO 1910 K = 2, 7
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
1910  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) THEN
          SDEF (3, J) = 1.
          SDEF (4, J) = 0.
      ENDIF
      IF (SDEF (5, J) .EQ. 0.) THEN
          SDEF (6, J) = 1.
          SDEF (7, J) = 0.
      ENDIF
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (4, J) .LT. 0. .OR.
     1    SDEF (6, J) .LE. 0. .OR. SDEF (7, J) .LT. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (5, J) .EQ. 0.) GO TO 7200
      IF (SDEF (2, J) .GT. 0. .AND.
     *    SDEF (4, J) .GT. 0.414213D0 * SDEF (3, J)) GO TO 7200
      IF (SDEF (5, J) .GT. 0. .AND.
     *    SDEF (7, J) .GT. 0.414213D0 * SDEF (6, J)) GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 10 (USER METHOD # 108)
2000  READ (3, * ) (SDEF (K, J), K = 2, 7)
      DO 2010 K = 2, 7
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
2010  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) THEN
          SDEF (3, J) = 1.
          SDEF (4, J) = 0.
      ENDIF
      IF (SDEF (5, J) .EQ. 0.) THEN
          SDEF (6, J) = 1.
          SDEF (7, J) = 0.
      ENDIF
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (4, J) .LT. 0. .OR.
     1    SDEF (6, J) .LE. 0. .OR. SDEF (7, J) .LT. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (5, J) .EQ. 0.) GO TO 7200
      IF (SDEF (2, J) .GT. 0. .AND.
     *    SDEF (4, J) .GT. 0.414213D0 * SDEF (3, J)) GO TO 7200
      IF (SDEF (5, J) .GT. 0. .AND.
     *    SDEF (7, J) .GT. 1.19135D0 * DSQRT (SDEF (6, J)))
     *   GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 11 (USER METHOD # 109)
2100  READ (3, * ) (SDEF (K, J), K = 2, 7)
      DO 2110 K = 2, 7
      IF (SDEF (K, J) .LT. 0.) GO TO 7200
2110  CONTINUE
      IF (SDEF (2, J) .EQ. 0.) THEN
          SDEF (3, J) = 1.
          SDEF (4, J) = 0.
      ENDIF
      IF (SDEF (5, J) .EQ. 0.) THEN
          SDEF (6, J) = 1.
          SDEF (7, J) = 0.
      ENDIF
      IF (SDEF (3, J) .LE. 0. .OR. SDEF (4, J) .LT. 0. .OR.
     1    SDEF (6, J) .LE. 0. .OR. SDEF (7, J) .LT. 0.) GO TO 7200
      IF (SDEF (2, J) .EQ. 0. .AND. SDEF (5, J) .EQ. 0.) GO TO 7200
      IF (SDEF (2, J) .GT. 0. .AND.
     *    SDEF (4, J) .GT. 1.19135D0 * DSQRT (SDEF (3, J)))
     *   GO TO 7200
      IF (SDEF (5, J) .GT. 0. .AND.
     *    SDEF (7, J) .GT. 1.19135D0 * DSQRT (SDEF (6, J)))
     *   GO TO 7200
      GO TO 3000
C
C  CASE: NSYS = 12 (USER METHOD # 110)
2200  READ (3, * ) (SDEF (K, J), K = 2, 4)
      IF (SDEF (2, J) .LE. 0.D0 .OR. SDEF (4, J) .LE. 0.D0) GO TO 7200
      IF (SDEF (3, J) .LE. 2.D0 .OR. SDEF (3, J) .GT. 10.D0) GO TO 7200
C
3000  RETURN
C
7000  WRITE (8, 8020) NDTHIS, J
      STOP 8
7100  WRITE (8, 8030) NMETH
      STOP 8
7200  WRITE (8, 8040) J, NSYS, (SDEF (K, J), K = 2, 20)
      STOP 8
C
C !*** changed input to free format
C   8000  FORMAT (2I6)
C   8010  FORMAT (19E12.4)
C   8015  FORMAT (5E12.4, 2I12)
C
8020  FORMAT ('  PCHK1 ERROR - DEFINITION (SPECIFIED, EXPECTED) =',
     1  2I5)
8030  FORMAT ('  PCHK1 ERROR - USER METHOD ', I4, ' DOES NOT EXIST')
8040  FORMAT ('  PCHK1 ERROR - ILLEGAL PARAMETER(S) FOR ',
     1  '(DEFINITION, METHOD) =', 2I6 /
     2  '    ****  PARAMETERS  ****' / 19 (1P,E12.4 /))
      END
