!+
!KWIC pchk2.f
!
!$Id: pchk2.f,v 1.2 2004/03/17 21:23:39 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 2/26/88 TO CHANGE COMMON /AMNMX/
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE PCHK2 (IER)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    PCHK2 FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/15/81
C    *
C    *    UPDATE:   10/19/81
C    *    TIME:     11:30:23
C    *
C    ******************************************/
C
C  READ AND CHECK SCATTER AREA DEFINITIONS FOR A SURFACE
C
C  INPUT VIA # 3 : FILE 'SCAT' = SCATTER DEFINITION FILE
C    NSURF               : I*4 - # OF SURFACE TO BE SPECIFIED
C    NAREAS (NSURF)      : I*4 - # OF SCATTER AREAS ON SURFACE
C    SCLIM (K, NSURF, J) : R*4 - AREA LIMIT PARAMETERS
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /AMNMX/ :
C    NDEFS : I*4 - NUMBER OF SCATTER DEFINITIONS IN SYSTEM
C
C  INPUT VIA LABELED COMMON /LIMITS/ :
C    NAREA : I*4 - NUMBER OF AREAS ALLOWED PER SURFACE
C
C  OUTPUT PARAMETER :
C    IER : 0  = LEGITIMATE AREA DEFINITION
C          -1 = NO SCATTER AREAS LEFT TO BE DEFINED
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    NAREAS (NSURF) : I*4 - NUMBER OF SCATTER AREAS ON THIS SURFACE
C
C  OUTPUT VIA LABELED COMMON /SCLICO/ :
C    SCLIM (K, NSURF, J) : R*4 - AREA LIMIT PARAMETERS
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /LIMITS/ NAREA, NDEFN, NDTOT, NGRID, NTABG, NTABR, NTABF
      COMMON /SCLICO/ SCLIM (5, 21, 1)
C
C
      READ (3, * ) NSURF !*** changed input to free format
      IF (NSURF .EQ. -1) GO TO 500
C  (CHECK TO SEE IF SURFACE NUMBER IN BOUNDS)
      IF (NSURF .LT. 1 .OR. NSURF .GT. NS) GO TO 7000
C  (READ NUMBER OF AREA DEFINITIONS)
      READ (3, * ) NAREAS (NSURF) !*** changed input to free formatd
      IF (NAREAS (NSURF) .LT. 1 .OR. NAREAS (NSURF) .GT. NAREA)
     1  GO TO 7100
C  (LOOP THROUGH EACH AREA DEFINITION)
      IER = 0
      JTOP = NAREAS (NSURF)
      DO 150 J = 1, JTOP
      READ (3, * ) NDEF, (SCLIM (K, NSURF, J), K = 2, 5) !*** changed to free
                                                         !*** format input
      SCLIM (1, NSURF, J) = NDEF
      IF (IABS (NDEF) .LT. 1 .OR. IABS (NDEF) .GT. NDEFS) GO TO 7200
150   CONTINUE
      GO TO 600
C
500   IER = -1
C
600   RETURN
C
7000  CONTINUE
      WRITE (8, 8020) NSURF, NS
      STOP 8
7100  CONTINUE
      WRITE (8, 8030) NAREAS (NSURF), NAREA
      STOP 8
7200  CONTINUE
      WRITE (8, 8040) NDEF, NDEFS
      STOP 8
C
C !*** changed to free format input
C   8000  FORMAT (I6)
C   8010  FORMAT (I12, 4E12.4)
C
8020  FORMAT ('  PCHK2 ERROR - SURFACE NUMBER (INPUT, LIMIT) =', 2I6)
8030  FORMAT ('  PCHK2 ERROR - # OF AREAS (INPUT, LIMIT) =', 2I6)
8040  FORMAT ('  PCHK2 ERROR - DEFINITION # (INPUT, LIMIT) =', 2I6)
      END
