!+
!KWIC pixlpr.f
!
!$Id: pixlpr.f,v 1.1 2004/03/16 15:50:01 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO GO FROM 101x101 TO 1001x1001 PIXELS
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE PIXLPR (FPIN, IUNIT, ZLOUT, ITOUT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    PIXLPR FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/10/82
C    *
C    *    UPDATE:   02/23/82
C    *    TIME:     10:54:03
C    *
C    ******************************************/
C
C  PURPOSE : TO GATHER AND PRINT SUMMARY INFORMATION FOR
C            EACH FOCAL PLANE PIXEL ARRAY INPUT FILE
C
C  INPUT PARAMETERS :
C    FPIN  : R*4 - SCRATCH ARRAY FOR INPUT PIXEL ARRAY
C    IUNIT : I*4 - FILE NUMBER OF INPUT FILE
C    ZLOUT : R*4 - RUNNING AVERAGE VALUE FOR WAVELENGTH PARAMETER
C                  -1.   = WAVELENGTHS DISAGREE BY MORE THAN 0.001
C                  -2.   = SPECULAR FILE ONLY, SO NO WAVELENGTH
C                  OTHER = WAVELENGTH
C    ITOUT : I*4 - RUNNING SUM VALUE OF FILE TYPE PARAMETER
C                = 30     * NRAY +
C                  900    * NARAY +
C                  27000  * NFPSCA +
C                  810000 * NFPDFR
C
C  OUTPUT PARAMETERS :
C    ZLOUT : R*4 - UPDATED WAVELENGTH PARAMETER
C    ITOUT : I*4 - UPDATED FILE TYPE PARAMETER
C
C  INPUT VIA # IUNIT :
C    INPUT FPSCA, FPDFR, OR FPCOM FILE
C
C  OUTPUT VIA # 6 AND # 8 :
C    SUMMARY INFORMATION ABOUT INPUT FILE
C
C  XR : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

!     DIMENSION FPIN (101, 101), FID1 (16), FID2 (16)
      DIMENSION FPIN (1001, 1001), FID1 (16), FID2 (16)

C
C**************************************************************
C        THE FOLLOWING LINES WERE MODIFIED BY M. WILSON,
C        CODE 717.4, GSFC, ON NOVERMBER 11, 1986
C
C OLD:
C     DOUBLE PRECISION FOGIN (6), FDATE1, FTIME1, FDATE2, FTIME2
C
C NEW:
      DOUBLE PRECISION      FOGIN(6)
      CHARACTER*8 FDATE1,FDATE2, FTIME1, FTIME2
      CHARACTER*4 FID1,FID2
C**************************************************************
C
C  READ HEADER, UPDATE WAVELENGTH AND FILE TYPE
      READ (IUNIT, ERR = 2000, END = 2100) FID1, FDATE1, FTIME1
      READ (IUNIT, ERR = 2000, END = 2100) FID2, FDATE2, FTIME2
      READ (IUNIT, ERR = 2000, END = 2100) FOGIN, ZLAM, ITYPE
      IF (ZLAM .EQ. -1. .OR. ZLOUT .EQ. -1.) GO TO 160
      IF (ZLOUT .EQ. -2.) GO TO 180
      IF (ZLAM .EQ. -2.) GO TO 200
C  (BOTH RUNNING AVERAGE AND CURRENT VALUE ARE LEGITIMATE)
      IF (ABS ((ZLAM - ZLOUT) / ZLOUT) .GT. 0.001) GO TO 160
      GO TO 200
C  (OUTPUT NEEDS TO BE -1. FOR DISAGREEMENT)
160   ZLOUT = -1.
      GO TO 200
C  (OUTPUT NEEDS TO BE SAME AS CURRENT VALUE)
180   ZLOUT = ZLAM
C  (ZLOUT IS SET - DO ITYPE PARAMETER)
200   IF (ITYPE .GT. 29) GO TO 250
      IF (ITYPE .EQ. 1) ITOUT = ITOUT + 27000
      IF (ITYPE .EQ. 2) ITOUT = ITOUT + 810000
      GO TO 300
250   ITOUT = ITOUT + ITYPE
      NRAY = MOD (ITOUT, 900) / 30
      NARAY = MOD (ITOUT - 30 * NRAY, 27000) / 900
      NFPSCA = MOD (ITOUT - 30 * NRAY - 900 * NARAY, 810000) / 27000
      NFPDFR = MOD (ITOUT - 30* NRAY - 900 * NARAY - 27000 * NFPSCA,
     1              24300000) / 810000
C
C  CALCULATE TOTAL ENERGY
300   NXIN = FOGIN (5)
      NYIN = FOGIN (6)
      DO 350 J = 1, NYIN
      READ (IUNIT, ERR = 2000, END = 2100) (FPIN (I, J), I = 1, NXIN)
350   CONTINUE
      ETOT = 0.
      DO 370 I = 1, NXIN
      DO 360 J = 1, NYIN
      ETOT = ETOT + FPIN (I, J)
360   CONTINUE
370   CONTINUE
C
C  WRITE SUMMARY
      GO TO (410, 420), ITYPE
C  (FILE IS AN FPCOM FILE)
      CALL INCLIN (20)
      WRITE (8, 9000) FID1, FDATE1, FTIME1, FID2, FDATE2, FTIME2,
     1                ZLAM, ITYPE, NRAY, NARAY, NFPSCA, NFPDFR
      GO TO 450
C  (FILE IS AN FPSCA FILE)
410   CONTINUE
      CALL INCLIN (16)
      WRITE (8, 9010) FID1, FDATE1, FTIME1, FID2, FDATE2, FTIME2, ZLAM,
     1  ITYPE
      GO TO 450
C  (FILE IS AN FPDFR FILE)
420   CONTINUE
      CALL INCLIN (16)
      WRITE (8, 9020) FID1, FDATE1, FTIME1, FID2, FDATE2, FTIME2, ZLAM,
     1  ITYPE
C  (WRITE REMAINDER OF SUMMARY)
450   CONTINUE
      WRITE (8, 9030) (FOGIN (I), I = 1, 4), NXIN, NYIN, ETOT
      REWIND IUNIT
      READ (IUNIT) FID1, FDATE1, FTIME1
      READ (IUNIT) FID2, FDATE2, FTIME2
      RETURN
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000) IUNIT
      STOP 8
2100  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8100) IUNIT
      STOP 8
C
8000  FORMAT ('  PIXLPR FATAL ERR READING ON FILE', I3)
8100  FORMAT ('  PIXLPR FATAL EOF READING ON FILE', I3)
9000  FORMAT (// T18, 'SUMMARY INFORMATION FOR FPLOOK ''FPCOM'' FILE'
     1         / T18, '-------------------------------------------'
     2         // 2 (1X, 15A4, A1, 1X, A8, 1X, A8 /),
     3         '  WAVELENGTH PARAMETER :', T40, 1P,D12.5 /
     4         '  FILE TYPE PARAMETER :', T40, 0P,I12 /
     5         '    IMPLIES NRAY   =', T40, 0P,I12 /
     6         '            NARAY  =', T40, 0P,I12 /
     7         '            NFPSCA =', T40, 0P,I12 /
     8         '            NFPDFR =', T40, 0P,I12)
9010  FORMAT (// T18, 'SUMMARY INFORMATION FOR DEDRIQ ''FPSCA'' FILE'
     1         / T18, '-------------------------------------------'
     2         // 2 (1X, 15A4, A1, 1X, A8, 1X, A8 /),
     3         '  WAVELENGTH :', T40, 1P,D12.5 /
     4         '  FILE TYPE NUMBER :', T40, 0P,I12)
9020  FORMAT (// T19, 'SUMMARY INFORMATION FOR PSF ''FPDFR'' FILE'
     1         / T19, '----------------------------------------'
     2         // 2 (1X, 15A4, A1, 1X, A8, 1X, A8 /),
     3         '  WAVELENGTH :', T40, 1P,D12.5 /
     4         '  FILE TYPE NUMBER :', T40, 0P,I12)
9030  FORMAT ('  PIXEL ARRAY CENTER X COORD :', T40, 1P,D12.5 /
     1        '  PIXEL ARRAY CENTER Y COORD :', T40, 1P,D12.5 /
     2        '  PIXEL ARRAY X LENGTH :', T40, 1P,D12.5 /
     3        '  PIXEL ARRAY Y LENGTH :', T40, 1P,D12.5 /
     4        '  NUMBER OF PIXELS IN X DIRECTION :', T40, 0P,I12 /
     5        '  NUMBER OF PIXELS IN Y DIRECTION ', T40, 0P,I12 /
     6        '  TOTAL ENERGY IN ARRAY :', T40, 1P,D12.5)
      END
