      SUBROUTINE PXINCR (PXINP, IXAINP, IXINP, JYINP, X0INP, Y0INP,
     *                   DXINP, DYINP, PXOUT, IXAOUT, IXOUT, JYOUT,
     *                   X0OUT, Y0OUT, DXOUT, DYOUT, CON)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    PXINCR FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/15/88
C    *
C   /******************************************/
C
C  PURPOSE: INCREMENT A PIXEL ARRAY WITH THE VALUES FROM A SECOND
C           PIXEL ARRAY WITH POSSIBLY DIFFERENT SPACING AND
C           LOCATION.  THE ROUTINE USES SIMPLE FOUR POINT BIVARIATE
C           INTERPOLATION, AND ADDITIONALY MULTIPLIES THE RESULTING
C           INTERPOLATED VALUE BY A USER-DEFINED CONSTANT BEFORE
C           INCREMENTING THE OUTPUT ARRAY.
C
C  NOTE: THIS MODIFIED VERSION (3/20/88) USES DOUBLE PRECISION
C        EVERYWHERE, TO WORK WITH THE VERSION OF THE CMLIB ROUTINES
C        WHICH HAVE BEEN MODIFIED BY HARRY FRISCH AT NASA GSFC TO
C        WORK IN DOUBLE PRECISION.
C
C  INPUT PARAMETERS:
C    PXINP (IXAINP, JYINP): R*8 - INPUT ARRAY
C    IXAINP: I*4 - ACTUAL NUMBER OF ROWS (I.E., X-DIM) IN PXINP
C    IXINP: I*4 - NUMBER OF ROWS USED IN PXINP
C    JYINP: I*4 - NUMBER OF COLUMNS (I.E., Y-DIM) IN PXINP
C    X0INP: R*8 - X-COORDINATE OF PXINP (1, 1)
C    Y0INP: R*8 - Y-COORDINATE OF PXINP (1, 1)
C    DXINP: R*8 - X-SPACING BETWEEN PIXELS IN PXINP (> 0)
C    DYINP: R*8 - Y-SPACING BETWEEN PIXELS IN PXINP (> 0)
C    PXOUT (IXAOUT, JYOUT): R*8 - INPUT/OUTPUT ARRAY TO BE INCREMENTED
C    IXAOUT: I*4 - ACTUAL NUMBER OF ROWS (I.E., X-DIM) IN PXOUT
C    IXOUT: I*4 - NUMBER OF ROWS USED IN PXOUT
C    JYOUT: I*4 - NUMBER OF COLUMNS (I.E., Y-DIM) IN PXOUT
C    X0OUT: R*8 - X-COORDINATE OF PXOUT (1, 1)
C    Y0OUT: R*8 - Y-COORDINATE OF PXOUT (1, 1)
C    DXOUT: R*8 - X-SPACING BETWEEN PIXELS IN PXOUT (> 0)
C    DYOUT: R*8 - Y-SPACING BETWEEN PIXELS IN PXOUT (> 0)
C    CON: R*8 - A CONSTANT BY WHICH TO MULTIPLY THE INTERPOLATED
C               VALUE BEFORE INCREMENTING PXOUT
C
C  OUTPUT PARAMETERS:
C    PXOUT (IXAOUT, JYOUT): R*8 - INPUT/OUTPUT ARRAY TO BE INCREMENTED
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION PXINP (IXAINP, JYINP)
      DIMENSION PXOUT (IXAOUT, JYOUT)
C
C
C  FIND THE OUTPUT PIXEL RANGES COVERED BY THE INPUT ARRAY
C
      DISTRT = 1.D0 + (X0INP - X0OUT) / DXOUT
      DISTOP = 1.D0 + (X0INP + (IXINP - 1.D0) * DXINP - X0OUT) / DXOUT
      DJSTRT = 1.D0 + (Y0INP - Y0OUT) / DYOUT
      DJSTOP = 1.D0 + (Y0INP + (JYINP - 1.D0) * DYINP - Y0OUT) / DYOUT
C
C  RETURN IF THERE IS NO OVERLAP
C
      IF (DISTRT .GT. IXOUT .OR. DISTOP .LT. 1.D0 .OR.
     *    DJSTRT .GT. JYOUT .OR. DJSTOP .LT. 1.D0) RETURN
C
C  TRIM THE CALCULATED LIMITS TO FIT THE OUTPUT ARRAY
C
      IXSTRT = MAX0 (1, IDINT (DISTRT + 0.9999999D0))
      IXSTOP = MIN0 (IXOUT, IDINT (DISTOP))
      JYSTRT = MAX0 (1, IDINT (DJSTRT + 0.9999999D0))
      JYSTOP = MIN0 (JYOUT, IDINT (DJSTOP))
C
C  LOOP OVER THE TRIMMED LIMITS, AND DEFINE THE TARGET COORDINATES
C  IN TERMS OF THE INPUT PIXEL NUMBERS (UNROUNDED REAL NUMBERS)
C
      DXPXLS = DXOUT / DXINP
      DYPXLS = DYOUT / DYINP
      XPXLS = 1.D0 + (X0OUT + (IXSTRT - 1.D0) * DXOUT - X0INP) / DXINP
      DO 400 IX = IXSTRT, IXSTOP
      YPXLS = 1.D0 + (Y0OUT + (JYSTRT - 1.D0) * DYOUT - Y0INP) / DYINP
      DO 390 JY = JYSTRT, JYSTOP
C
C  DEFINE THE FOUR CORNER VALUES TO INTERPOLATE FROM,
C  AND THE INTERPOLATION FRACTIONS P (FOR X) AND Q (FOR Y)
C
      IX00 = IDINT (XPXLS)
      P = XPXLS - IX00
      JY00 = IDINT (YPXLS)
      Q = YPXLS - JY00
      F00 = PXINP (IX00, JY00)
      F01 = PXINP (IX00, JY00 + 1)
      F10 = PXINP (IX00 + 1, JY00)
      F11 = PXINP (IX00 + 1, JY00 + 1)
C
C  DO THE INTERPOLATION
C
      PXOUT (IX, JY) = PXOUT (IX, JY) + CON *
     *      ((1.D0 - P) * (1.D0 - Q) * F00 + P * (1.D0 - Q) * F10 +
     *       Q * (1.D0 - P) * F01 + P * Q * F11)
C
C  END THE LOOPS AND RETURN
C
      YPXLS = YPXLS + DYPXLS
390   CONTINUE
      XPXLS = XPXLS + DXPXLS
400   CONTINUE
      RETURN
      END
