!+
!KWIC pzrefl.f
!
!$Id: pzrefl.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

      SUBROUTINE PZREFL (IVS1, IVN, IVS2, RPLUS, RMINUS)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    PZREFL FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/4/88
C    *
C   /******************************************/
C
C  PURPOSE: MULTIPLY THE INCOMING COMPLEX POLARIZATION VECTORS
C           BY A COMPLEX MATRIX TO ACCOUNT FOR THE COMPLEX
C           REFLECTIVITY
C
C  INPUT PARAMETERS:
C    RPLUS: C*16 - AMPL REFLECTIVITY FOR PARALLEL (OR P) POLARIZATION
C    RMINUS: C*16 - DITTO, FOR PERPENDICULAR (OR S) POLARIZATION
C    IVS1: I*4 - IV# OF INCOMING UNIT VECTOR
C    IVN:  I*4 - IV# OF NORMAL
C    IVS2: I*4 - IV# OF REFLECTED UNIT VECTOR
C
C  INPUT/OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    IV#'S IVS1, IVN, AND IVS2
C    IV#'S 100-103: C AND S VECTORS IN BCS (INPUT AND OUTPUT)
C                   (ORDER: RE(C), IM(C), RE(S), IM(S)
C    IV#'S 104-150: RESERVED, DEFINED AS FOLLOWS:
C          104-107: PING PONG BUFFER "B" FOR C AND S
C          108-111: PING PONG BUFFER "C" FOR C AND S
C          112-113: X1 AND Y1 UNIT VECTORS (NOT USED HERE)
C          114-116: T-MATRIX (XY1-STD) (NOT USED HERE)
C          117: PERPENDICULAR UNIT VECTOR (OUTPUT)
C          118-119: PARALLEL UNIT VECTORS 1 AND 2 (OUTPUT)
C          120-122: (PERPENDICULAR o PERPENDICULAR)
C          123-125: (PARALLEL#2 o PARALLEL#1)
C          126-128: REAL PART OF T-MATRIX (REFL IN BCS)
C          129-131: IMAG PART OF T-MATRIX (REFL IN BCS)
C          132-134: T-MATRIX (STD-XY2) (NOT YET DEFINED, NOT USED)
C
C  XR: MOUT, MVMULT, PZPRPL
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMPLEX*16 RPLUS, RMINUS
C
C  BEGIN BY DEFINING THE PERPENDICULAR AND PARALLEL UNIT VECTORS
C
      CALL PZPRPL (IVS1, IVS2, IVN, 117, 118, 119)
C
C  DEFINE (PERP o PERP) AND (PRL2 o PRL1)
C
      CALL MOUT (117, 117, 120)
      CALL MOUT (119, 118, 123)
C
C  DEFINE THE REAL AND IMAGINARY PARTS OF T-MATRIX (REFL IN BCS)
C
      RPLURE = DREAL (RPLUS)
      RPLUIM = DIMAG (RPLUS)
      RMINRE = DREAL (RMINUS)
      RMINIM = DIMAG (RMINUS)
      DO 120 I = 1, 3
      XV (125 + I) = RMINRE * XV (119 + I) + RPLURE * XV (122 + I)
      XV (128 + I) = RMINIM * XV (119 + I) + RPLUIM * XV (122 + I)
      YV (125 + I) = RMINRE * YV (119 + I) + RPLURE * YV (122 + I)
      YV (128 + I) = RMINIM * YV (119 + I) + RPLUIM * YV (122 + I)
      ZV (125 + I) = RMINRE * ZV (119 + I) + RPLURE * ZV (122 + I)
      ZV (128 + I) = RMINIM * ZV (119 + I) + RPLUIM * ZV (122 + I)
120   CONTINUE
C
C  PUT T(REAL) (C,S) INTO BUFFER B, AND T(IMAG) (C,S) INTO BUFFER C
C
      DO 140 I = 1, 4
      CALL MVMULT (126, 99 + I, 103 + I)
      CALL MVMULT (129, 99 + I, 107 + I)
140   CONTINUE
C
C  COLLECT THE REAL AND IMAG PARTS AND REASSEMBLE THEM IN BUFFER A
C
      XV (100) = XV (104) - XV (109)
      XV (101) = XV (105) + XV (108)
      XV (102) = XV (106) - XV (111)
      XV (103) = XV (107) + XV (110)
      YV (100) = YV (104) - YV (109)
      YV (101) = YV (105) + YV (108)
      YV (102) = YV (106) - YV (111)
      YV (103) = YV (107) + YV (110)
      ZV (100) = ZV (104) - ZV (109)
      ZV (101) = ZV (105) + ZV (108)
      ZV (102) = ZV (106) - ZV (111)
      ZV (103) = ZV (107) + ZV (110)
      RETURN
      END
