!+
!KWIC pzxy.f
!
!$Id: pzxy.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

      SUBROUTINE PZXY (IVS, IVX, IVY)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    PZXY FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/7/88
C    *
C   /******************************************/
C
C  PURPOSE: CALCULATE THE "X" AND "Y" DIRECTION UNIT VECTORS FOR
C           DEFINING POLARIZATION COMPONENTS, GIVEN A PROPAGATION
C           DIRECTION UNIT VECTOR
C
C  INPUT PARAMETERS:
C    IVS: I*4 - IV# OF THE PROPAGATION VECTOR
C    IVX: I*4 - DESIRED IV# FOR THE "X" VECTOR
C    IVY: I*4 - DESIRED IV# FOR THE "Y" VECTOR
C
C  INPUT/OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    IV#'S IVS, IVX, AND IVY
C
C  XR: VCROSS, VUNIT
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

C
C  FORM THE "X" AND "Y" POLARIZATION UNIT VECTORS (IV#'S IVX & IVY)
C
      IF (DABS (YV (IVS)) .GT. 0.99999D0) GO TO 120
      XV (IVX) = ZV (IVS)
      YV (IVX) = 0.D0
      ZV (IVX) = - XV (IVS)
      CALL VUNIT (IVX, IVX, SIZE)
      GO TO 140
120   XV (IVX) = 1.D0
      YV (IVX) = 0.D0
      ZV (IVX) = 0.D0
140   CALL VCROSS (IVS, IVX, IVY)
      RETURN
      END
