!+
!KWIC rdrasc.f
!
!$Id: rdrasc.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

!
!  UPDATED 2/26/88 TO READ EXPANDED RAY FILES AND REDUCED
!  SCAL FILES, AND TO SKIP INPUT IF THE SURFACE IS AN OBSCURATION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE RDRASC (IER2)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    RDRASC FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/15/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:02:46
C    *
C    ******************************************/
C
C  READ INFORMATION FROM 'SCAL' AND FOCAL PLANE 'RAY' FILE,
C  AND CHECK VALIDITY OF EACH PREVIOUS 'RAY' FILE
C
C  INPUT VIA # 2  : FILE 'SCAL' = SUSEQ SCALE FACTOR FILE
C    ALL PARAMETERS FOR ONE RAY
C
C  INPUT VIA # 9 AND UP : DRAT 'RAY' FILES
C    1ST LINE FOR A SURFACE RAY FILE, AND
C    ALL LINES (FOR ONE RAY) FOR FOCAL PLANE RAY FILE
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW0 (1) : LOGICAL*1 - X-RAY SYSTEM SWITCH
C
C  OUTPUT VIA LABELED COMMON /RAIN/ :
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : I*4 - INTEGER    PORTION OF PATH LENGTH
C    JRAY : I*4 - CURRENT RAY NUMBER
C    JING : I*4 - CURRENT RING NUMBER
C    J2   : I*4 - CURRENT SPOKE NUMBER
C    KODE : I*4 - RAY STATUS CODE
C    Q3   : R*4 - NORMALIZED 2ND DERIVATIVE SURFACE MATRIX
C
C  OUTPUT PARAMETER :
C    IER2 : 0 = SUCCESSFUL RAY
C           1 = UNSUCCESSFUL RAY
C           2 = NO RAYS LEFT
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 5 : FOCAL PLANE INTERCEPT POSITION
C
C
C  OUTPUT VIA LABELED COMMON /PARAMS/ :
C    ZW (I) : R*4 - WEIGHT OF RAY AT SURFACE # I
C    DP0, DP1S, DP1T, SFX, SFY, TFX, TFY : R*4 - VARIOUS PARAMETERS
C                                                FROM 'SCAL' FILE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
C
C
C  READ SUMMARY PARAMETERS FROM 'SCAL' FILE
      READ (2, 8000) KRAY, JING, J2, KODE, IN10
      IF (KRAY .LT. 0) GO TO 500
C  (LOOP THROUGH EACH SURFACE)
      JTOP = NS + 1
      DO 200 J = 1, JTOP
      LU = J + 8
      READ (LU, 8000) JRAY, JING, J2, JODE, JN10
      IF (JRAY .NE. KRAY) GO TO 7000
C  (RAY SUCCESSFUL?)
      IF (KODE .LE. 4) GO TO 150
C  (NO, SKIP RECORDS IF SUCCESSFUL AT THIS PREVIOUS SURFACE)
      IF (JODE .GT. 4) GO TO 200
      READ (LU, 8010) DUM, DUM, DUM, DUM, DUM
      GO TO 200
C  (YES, BE SURE RAY ALSO SUCCESSFUL AT THIS PREVIOUS SURFACE)
150   IF (JODE .GT. 4) GO TO 7100
      IF (J .LT. JTOP) ZW (J) = JN10 * 1.E-8
200   CONTINUE
C
C  ALL SURFACES DONE - IF RAY SUCCESSFUL, READ SCAL AND FP INFO
      IF (KODE .GT. 4) GO TO 400
      IER2 = 0
C
C  READ 'SCAL' FILE
      DO 300 J = 1, NS
!
!  SKIP INPUT IF THE SURFACE IS AN OBSCURATION
!
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 300
!
C  (READ FIRST LINE FOR THIS SURFACE)
      READ (2, 8050) SFX (J), SFY (J), TFX (J), TFY (J), DP0 (J)
!
!C  (IF X-RAY SYSTEM, READ DERIVATIVES OF SINS OF GRAZING ANGLES)
!      IF (.NOT. LSW0 (1)) GO TO 300
!C  (SET NUMBER OF GRAZING ANGLE SCALE FACTORS)
!      NFACT = NS - J
!      IF (NFACT .EQ. 0) GO TO 300
!C  (SET BASE INDEX INTO ARRAYS)
!      KBAS = (J - 1) * NS - ((J + 2) * (J - 1)) / 2
!C  (SET NUMBER OF LINES TO READ)
!      NLINE = INT ((NFACT + 2.) / 3.)
!C  (LOOP FOR EACH LINE)
!      DO 250 N = 1, NLINE
!      KBOT = 3 * N + J - 3
!      KTOP = KBOT + 2
!      IF (KTOP .GT. NS - 1) KTOP = NS - 1
!      KBOT = KBOT + KBAS
!      KTOP = KTOP + KBAS
!      READ (2, 8060) (DP1S (K), DP1T (K), K = KBOT, KTOP)
!250   CONTINUE
!
300   CONTINUE
C
C  READ FOCAL PLANE 'RAY' FILE
      LU = NS + 9
      READ (LU, 8020) XV (5), YV (5), ZV (5),
     1                XV (6), YV (6), ZV (6), IOP, FOP, Q3,
     *                C2COMP, S2COMP
      GO TO 600
C
400   IER2 = 1
      GO TO 600
C
500   IER2 = 2
C
600   RETURN
C
7000  continue
      WRITE (8, 8030) J, JRAY, KRAY
      STOP 8
7100  continue
      WRITE (8, 8040) J
      STOP 8
C
8000  FORMAT (5(I9,1X))
8020  FORMAT (3(1P,D25.17,1X) / 3(F19.16,1X), I5, 1X, F15.12, /
     1        3(F12.9,1X), 4X,
     1        3(F12.9,1X), /
     1        4(F15.9,1X) / 4(F15.9,1X))
!  (READ TWO MORE USELESS LINES FROM A GOOD RAY FILE)
!  8010  FORMAT (A4 / A4 / A4)
8010  FORMAT (A4 / A4 / A4 / A4 / A4)
8030  FORMAT ('  RDRASC ERROR - AT SURF', I3, ', RAY (IN, EXPECTED) =',
     1  2I6)
8040  FORMAT ('  RDRASC ERROR - ''SUCCESSFUL'' RAY FAILED AT SURF', I3)
8050  FORMAT (1P,5E13.5)
8060  FORMAT (1P,6E13.5)
      END
