!+
!KWIC rinit.f
!
!$Id: rinit.f,v 1.2 2004/03/17 21:23:41 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

      SUBROUTINE RINIT
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    RINIT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/05/81
C    *
C    *    UPDATE:   09/26/81
C    *    TIME:     16:04:49
C    *
C    ******************************************/
C
C  PURPOSE :
C     READ, CHECK, AND DISCARD ALL RAY FILE HEADERS
C     FIND DIRECTION COSINES OF INCOMING BUNDLE
C     SET NORMAL VECTOR AT FOCAL PLANE
C
C  INPUT :
C     VIA /PARM/ :
C       GEN (7) :  AZIMUTHAL ANGLE OF INCOMING BUNDLE
C       GEN (8) :  ELEVATION ANGLE OF INCOMING BUNDLE
C     VIA /PARX/ :
C       NS :  NUMBER OF SURFACES
C       NDIM :  NUMBER OF SURFACES ALLOWED FOR
C
C  OUTPUT :
C     VIA V# 32 :  DIRECTION COSINES OF INCOMING BUNDLE
C     VIA V# (2 * NDIM + NS + 34) :
C       DIRECTION COSINES OF NORMAL VECTOR OF FOCAL PLANE
C
C  XR :  REHEAD, VAZELD
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

C
C
C  LOOP FOR EACH SURFACE, INCLUDING FOCAL PLANE
      JTOP = NS + 1
      DO 200 J = 1, JTOP
C
C  READ CURRENT SURFACE HEADER, CHECK FOR (FATAL) ERROR
      KURF = J + 1
      ND = J + 8
      CALL REHEAD (ND, 1, IER)
      IF (IER .EQ. 0) GO TO 200
      WRITE (8, 9000) J
      STOP 8
200   CONTINUE
C
C  SET VECTOR QUANTITIES
      AZ = GEN (7)
      EL = GEN (8)
      CALL VAZELD (AZ, EL, NDIM + 32)
      NNORM = NDIM + NDIM + NS + 34
      XV (NNORM) = 0.D0
      YV (NNORM) = 0.D0
      ZV (NNORM) = 1.D0
      RETURN
C
9000  FORMAT ('  RINIT - FATAL ERROR READING HEADER OF SURF #', I4)
      END
