!+
!KWIC rlroot.f
!
!$Id: rlroot.f,v 1.1 2004/03/16 15:50:06 dtn Exp $
!
!Revisions:
!   95-Jan-27[T. Gaetz]
!      . make PCOEF into assumed size array; allows
!        bounds-checking compiler option to be used.
!-

      SUBROUTINE RLROOT (NORD, PCOEF, RZERO, IFLG)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    RLROOT FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/16/89
C    *
C   /******************************************/
C
C  PURPOSE: SOLVE A 1ST, 2ND, 3RD, OR 4TH ORDER EQUATION
C           INVOLVING REAL COEFFICIENTS.
C           (THIS IS A CLOSED FORM SOLUTION ONLY, WHICH MEANS
C           THAT ITERATING MAY BE APPROPRIATE AFTERWARDS.)
C
C  INPUT PARAMETERS:
C    NORD: I * 4 - ORDER OF THE EQUATION (1 TO 4)
C    PCOEF (NORD + 1): R * 8 - COEFFICIENTS IN DESCENDING ORDER
C
C  OUTPUT PARAMETERS:
C    RZERO (NORD): C * 16 - ZEROES OF THE EQUATION
C    IFLG: I * 4 - ERROR FLAG
C                  0 = ALL OK
C                  1 = FIRST COEFFICIENT = 0
C                  2 = WRONG ORDER (NOT 1 TO 4)
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      COMPLEX * 16 RZERO (4), CDSQ, ABIG, BBIG, YROOT, RBIG
      COMPLEX * 16 CARG, CARGA, CARGB, DBIG, EBIG

      external     cdcbrt
      COMPLEX * 16 CDCBRT

      DIMENSION PCOEF (*)
      DATA SQRT3 /1.73205 08075 68877 00000D0/
C
C
C  SELECT THE ORDER
C
      IF (PCOEF (1) .EQ. 0.D0) GO TO 510
      GO TO (100, 200, 300, 400), NORD
      GO TO 520
C
C  FIRST ORDER
C
100   RZERO (1) = DCMPLX (- PCOEF (2) / PCOEF (1), 0.D0)
      GO TO 600
C
C  SECOND ORDER
C
200   ARG = PCOEF (2) ** 2 - 4.D0 * PCOEF (1) * PCOEF (3)
      CDSQ = CDSQRT (DCMPLX (ARG, 0.D0))
      RZERO (1) = (- PCOEF (2) + CDSQ) / (2.D0 * PCOEF (1))
      RZERO (2) = (- PCOEF (2) - CDSQ) / (2.D0 * PCOEF (1))
      GO TO 600
C
C  THIRD ORDER (SEE CRC STANDARD MATH TABLES FOR CONVENTIONS)
C
C   DEFINE LITTLE P, Q, AND R
300   P = PCOEF (2) / PCOEF (1)
      Q = PCOEF (3) / PCOEF (1)
      R = PCOEF (4) / PCOEF (1)
C   DEFINE LITTLE A AND LITTLE B FOR THE EQUATION IN X
      ALIT = (3.D0 * Q - P * P) / 3.D0
      BLIT = (2.D0 * P ** 3 - 9.D0 * P * Q + 27.D0 * R) / 27.D0
C   DEFINE BIG A AND BIG B
      ARG = BLIT * BLIT / 4.D0 + ALIT ** 3 / 27.D0
      CDSQ = CDSQRT (DCMPLX (ARG, 0.D0))
      CARGA = - (BLIT / 2.D0) + CDSQ
      CARGB = - (BLIT / 2.D0) - CDSQ
C   (DO DIFFERENT ROTATIONAL BIASES, DEPENDING ON ANGLE VALUES)
      IF (DIMAG (CARGA) .GT. 0.D0) GO TO 320
      IF (DREAL (CARGB) .GT. 0.D0) GO TO 320
      IF (DREAL (CARGA) .GT. 0.D0) GO TO 330
      GO TO 340
C
320   ABIG = CDCBRT (CARGA, 0)
      BBIG = CDCBRT (CARGB, 0)
      GO TO 360
C
330   ABIG = CDCBRT (CARGA, 0)
      BBIG = CDCBRT (CARGB, 1)
      GO TO 360
C
340   ABIG = CDCBRT (CARGA, 0)
      BBIG = CDCBRT (CARGB, 2)
C   DEFINE THE ROOTS FOR X
360   RZERO (1) = ABIG + BBIG
      RZERO (2) = - (ABIG + BBIG) / 2.D0 +
     *              (ABIG - BBIG) * DCMPLX (0.D0, SQRT3) / 2.D0
      RZERO (3) = - (ABIG + BBIG) / 2.D0 -
     *              (ABIG - BBIG) * DCMPLX (0.D0, SQRT3) / 2.D0
C   SHIFT BY P/3 TO GET BACK TO Y
      P3 = P / 3.D0
      DO 390 I = 1, 3
      RZERO (I) = RZERO (I) - P3
390   CONTINUE
      GO TO 600
C
C  FOURTH ORDER (SEE CRC STANDARD MATH TABLES FOR CONVENTIONS)
C
C   DEFINE LITTLE A, B, C, AND D
400   ALIT = PCOEF (2) / PCOEF (1)
      BLIT = PCOEF (3) / PCOEF (1)
      CLIT = PCOEF (4) / PCOEF (1)
      DLIT = PCOEF (5) / PCOEF (1)
C   SET UP THE RESOLVENT CUBIC EQUATION
      P = - BLIT
      Q = ALIT * CLIT - 4.D0 * DLIT
      R = - ALIT * ALIT * DLIT + 4.D0 * BLIT * DLIT - CLIT * CLIT
C   GET ONE ROOT OF THIS EQUATION
      ALIT2 = (3.D0 * Q - P * P) / 3.D0
      BLIT2 = (2.D0 * P ** 3 - 9.D0 * P * Q + 27.D0 * R) / 27.D0
      ARG = BLIT2 * BLIT2 / 4.D0 + ALIT2 ** 3 / 27.D0
      CDSQ = CDSQRT (DCMPLX (ARG, 0.D0))
      CARGA = - (BLIT2 / 2.D0) + CDSQ
      CARGB = - (BLIT2 / 2.D0) - CDSQ
      IF (DIMAG (CARGA) .GT. 0.D0) GO TO 420
      IF (DREAL (CARGB) .GT. 0.D0) GO TO 420
      IF (DREAL (CARGA) .GT. 0.D0) GO TO 430
      GO TO 440
420   ABIG = CDCBRT (CARGA, 0)
      BBIG = CDCBRT (CARGB, 0)
      GO TO 460
430   ABIG = CDCBRT (CARGA, 0)
      BBIG = CDCBRT (CARGB, 1)
      GO TO 460
440   ABIG = CDCBRT (CARGA, 0)
      BBIG = CDCBRT (CARGB, 2)
460   YROOT = ABIG + BBIG - P / 3.D0
C   DEFINE BIG R
      CARG = ALIT * ALIT / 4.D0 - BLIT + YROOT
      RBIG = CDSQRT (CARG)
      IF (RBIG .EQ. DCMPLX (0.D0, 0.D0)) GO TO 480
C   BIG R <> 0: DEFINE BIG D AND E
      DBIG = CDSQRT (0.75D0 * ALIT * ALIT - RBIG * RBIG - 2.D0 * BLIT +
     *       (ALIT * BLIT - 2.D0 * CLIT - 0.25D0 * ALIT ** 3) / RBIG)
      EBIG = CDSQRT (0.75D0 * ALIT * ALIT - RBIG * RBIG - 2.D0 * BLIT -
     *       (ALIT * BLIT - 2.D0 * CLIT - 0.25D0 * ALIT ** 3) / RBIG)
      GO TO 490
C   BIG R = 0: DEFINE BIG D AND E
480   DBIG = CDSQRT (0.75D0 * ALIT * ALIT - 2.D0 * BLIT +
     *       2.D0 * CDSQRT (YROOT * YROOT - 4.D0 * DLIT))
      EBIG = CDSQRT (0.75D0 * ALIT * ALIT - 2.D0 * BLIT -
     *       2.D0 * CDSQRT (YROOT * YROOT - 4.D0 * DLIT))
C   FINALLY DEFINE THE ROOTS
490   RZERO (1) = - ALIT / 4.D0 + RBIG / 2.D0 + DBIG / 2.D0
      RZERO (2) = - ALIT / 4.D0 + RBIG / 2.D0 - DBIG / 2.D0
      RZERO (3) = - ALIT / 4.D0 - RBIG / 2.D0 + EBIG / 2.D0
      RZERO (4) = - ALIT / 4.D0 - RBIG / 2.D0 - EBIG / 2.D0
      GO TO 600
C
C  FIRST COEFFICIENT IS ZERO
C
510   IFLG = 1
      GO TO 600
C
C  WRONG ORDER
C
520   IFLG = 2
      GO TO 600
C
C  RETURN
C
600   RETURN
      END
