!
!+
!KWIC rowcol.f
!
!$Id: rowcol.f,v 1.1 2004/03/16 15:50:06 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . eliminate output to unit 6; see unit 8 for info
!-
!  UPDATED 5/9/88 TO MAKE THE OUTPUT PIXEL ARRAY DOUBLE PRECISION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 4/1/91 TO GO FROM 101x101 TO 1001x1001 PIXELS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE ROWCOL (IBOT, ITOP, JBOT, JTOP, FPOUT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    ROWCOL FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/10/82
C    *
C    *    UPDATE:   02/23/82
C    *    TIME:     10:54:50
C    *
C    ******************************************/
C
C  PURPOSE : TO OUTPUT THE ENERGY IN A SUBSET OF PIXELS
C
C  INPUT PARAMETERS :
C    IBOT  : I*4 - LOWER X INDEX
C    ITOP  : I*4 - UPPER X INDEX
C    JBOT  : I*4 - LOWER Y INDEX
C    JTOP  : I*4 - UPPER Y INDEX
C    FPOUT : R*4 - ARRAY OF PIXEL ENERGIES
C
C  OUTPUT VIA # 6 AND # 8 :
C    PIXEL ENERGIES
C
C  XR : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
!
!     REAL*4 FPOUT (101, 101)
!     DIMENSION FPOUT (101, 101)
      DIMENSION FPOUT (1001, 1001)
!
C
C
C  OUTPUT HEADER LINES
      CALL INCLIN (4)
      WRITE (8, 9000)
C
C  LOOP OVER ROWS
      DO 200 JPRE = JBOT, JTOP
      J = JBOT + JTOP - JPRE
      NLINE = (ITOP - IBOT) / 6 + 3
      CALL INCLIN (NLINE)
      WRITE (8, 9010) IBOT, ITOP, J
      WRITE (8, 9020) (FPOUT (I, J), I = IBOT, ITOP)
200   CONTINUE
      RETURN
C
9000  FORMAT (// T28, 'SPECIFIC PIXEL ENERGIES' /
     1          T28, '-----------------------')
9010  FORMAT (/ '  PIXEL ENERGIES IN COLUMN #''S (', I3, '-', I3,
     1        ')  FOR ROW #', I3)
9020  FORMAT (1P,6E12.4)
      END
