!+
!KWIC saonexray.f
!
!$Id: saonexray.f,v 1.3 2004/05/18 20:25:28 dtn Exp $
!
!Revisions:
!   98-Feb-09 [T. Gaetz]
!      . remove handy(3) local variable declaration (no longer used)
!   97-Oct-27 [D. Grumm]
!      . change call to c_read to call to the bpipe routine get_ray in 
!        osacbpipe.c
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   96-Apr-02[T. Gaetz]
!      . bug fix: JRAY = KRAY line deleted after c_read call;
!        add check for jray=0 when setting ier for error return
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-16[T. Gaetz]
!      . change c_read to omit norm[] and singraze
!   93-Nov-16[T. Gaetz]
!      . change c_read to get norm[] and singraze; need these for saofocus
!        passthrough (see saowrad_foc.f)
!   93-Nov-15[T. Gaetz]
!      . rework logic for handling error code; if (ier...) needed to include
!        transfer of c_read results into osac variables.
!   93-Nov-12[T. Gaetz]
!      . move /raystuff/ to include file
!      . adapt to new c_read argument list
!      . posdir broken into pos, dir
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-28[T. Gaetz]
!      . fgoodrays added to /raystuff/; if fgoodrays is false, store
!        original pos, dir cosine in posdir_old
!   93-Oct-20[T. Gaetz]
!      . change c_read argument list; argument ga removed.
!      . /raystuff/:  g_ang(2) --> g_ang
!        (g_ang's arrayness now handled in c_read/c_write)
!   93-Sep-29[T. Gaetz]
!      . renamed to saonexray; change i/o messages to conform
!   93-Apr-05[T. Gaetz]
!      . change over to implicit none;
!      . use new getray routine
!      . strip out commented-out statements
!      . eliminate dead code
!      . convert spaghetti goto construct with equivalent if - else block
!   93-Apr-14[T. Gaetz]
!      . simplified too far in debugging; reinstate code in 
!        if ( ier .eq 0 ) block.
!      . clean up debris from debugging.
!   93-Apr-15[T. Gaetz]
!      . rename common /graze/ to /raystuff/; add energy, norm to common
!-
!
!  UPDATED 2/4/88 TO READ THE POLARIZATION DATA
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE SAONEXRAY( pos, dir, w_c, energy_c, 
     +     c2comp_c, s2comp_c, kray, kode_c, IER )
C   /******************************************/
C    *
C    *   PERKIN-ELMER CORPORATE COMPUTING
C    *     SOFTWARE ENGINEERING SECTION
C    *
C    *   NEXRAY FORTRAN
C    *   WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *           ON 07/01/80
C    *
C    *   UPDATE:    11/30/81
C    *   TIME:      13:41:28
C    *
C    ******************************************/
C
C  Locate the next ray and determine its characteristics
C
C  INPUT VIA /PARX/ : KURF = I*4 SURFACE # , WHEN KURF > 1
C
C  INPUT VIA D#23  : data records of the input ray file and path length
C
C  NOTE : When KURF = 1 the position and path length of the ray is found
C        by NEXRAP, and the remaining characteristics are constants.
C
C  OUTPUT via labeled COMMON /RAIN/:
C    FOP  : fractional portion of path length
C    IOP  : integer portion of path length
C    JRAY : current ray number
C    JING : current ring number
C    J2   : current spoke number
C    KODE : ray status code (see CHEX output)
C    W    : relative intensity of ray
C
C  OUTPUT via labeled COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#1 : ray starting position
C    V#2 : ray starting direction
C
C  OUTPUT via labeled COMMON /SUMRY/:
C    WF1   : R*8 - sum of weights of rays failing at surface #1
C    WS1   : R*8 - sum of weights of successful rays at surfacE #1
C    JAIL1 : I*4 - number of rays failing at surface #1
C    LEFT1 : I*4 - number of rays leaving s #1 or preceeding surface
C
C  OUTPUT ARGUMENT :
C    IER : I*4 ERROR CODE
C        IER = 0  : no error
C        IER = 1  : EOF
C        IER = 2  : read error
C        IER = 3  : mismatch in ray#
C        IER < 0  : no more rays - the trailer record has been read and
C                   processed. IER = -# of rays in the file.
C
C  External references : NEXRAP
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

!---  global variables...

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/raystuff.h'  ! info needed for binary pipeline
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION CPSI, SPSI, SQRE
      COMMON /PLRZ/    CPSI, SPSI, SQRE

!---  local variables...

      double precision w_c, energy_c
      integer          kode_c
      complex*16       c2comp_c( 2 ), s2comp_c( 2 )

      DOUBLE PRECISION path, pos(3), dir(3)
      INTEGER          kray, in10, ier

!CODE saonexray --------------------------------------------------------
!
! get_ray was called from C, so the incoming ier is legit.
! no need to init ier.
!
!      ier = 0  ! reset error flag before call...

! *****************************************************************
! get_ray - read next ray from BPipe...
!
!    void
!    get_ray_(double   *r,         /* ray position  vector (3-vector)      */
!             double   *v,         /* ray direction vector (unit 3-vector) */
!             double   *wt,        /* ray weight                           */
!             double   *energy,    /* ray energy                           */
!             dcomplex *c2,        /* polarization amplitude ("cosine")    */
!             dcomplex *s2,        /* polarization amplitude ("sine")      */
!             int      *id,        /* ray identifier                       */
!             int      *raycode,   /* ray sucess code                      */
!             int      *err        /* 0 for success, nonzero for error     */
!            )
!
!   get_ray will be called from C, part of the plan to minimize
!   fortran calling C functions.
!                                                                 dtn
!
!      call get_ray( pos, dir, w, energy, c2comp_c, s2comp_c, 
!     &              kray, kode, ier)
!
! get_ray was called from a C-function, the values returned from get_ray
! are set (the non-common block vars) here to let fortran do its thing.
!                                                                 dtn
!
      w           = w_c
      energy      = energy_c
      c2comp( 1 ) = c2comp_c( 1 )
      c2comp( 2 ) = c2comp_c( 2 )
      s2comp( 1 ) = s2comp_c( 1 )
      s2comp( 2 ) = s2comp_c( 2 )
      kode        = kode_c

      path = 0.d0   ! NOTE!!! - hardwire path to zero

      if ( ier .ne. 0 ) then

!---     unsuccessful read of ray; set error flag and return...
         if ( jray .eq. 0 ) then
            ier = -1
         else
            ier = -jray
         endif

      else
         
!---     successful read of ray; extract quantities we need...

         xv(1) = pos(1)
         yv(1) = pos(2)
         zv(1) = pos(3)
         xv(2) = dir(1)
         yv(2) = dir(2)
         zv(2) = dir(3)

         jing  = 1        ! NOTE!!! - hardwire jing to one
         j2    = 1        ! NOTE!!! - hardwire j2   to one
         kode  = 2        ! init to 2 so ray will be handled
         iop  = path
         fop  = path - iop
         in10 = w * 1.0d8

!tjg-diagnostic-output-begin
!xxx  write ( 70+kurf , * ) 'saonexray __a_ ' , ier, kray 
!xxx  write ( 70+kurf , * ) 'saonexray __b_ ' , jing, j2, kode , in10
!xxx  write ( 70+kurf , * ) 'saonexray __c_ ' , xv(1),yv(1),zv(1)
!xxx  write ( 70+kurf , * ) 'saonexray __d_ ' , xv(2),yv(2),zv(2)
!xxx  write ( 70+kurf , * ) 'saonexray __e_ ' , g_ang
!$$$  write ( 70+kurf , * ) 'saonexray __a_ ' , kray, kode, g_ang
!$$$  write ( 70+kurf , * ) 'saonexray __b_ ' , xv(1),yv(1),zv(1)
!$$$  write ( 70+kurf , * ) 'saonexray __c_ ' , xv(2),yv(2),zv(2)
!tjg-diagnostic-output-end

!dmg-diagnostic-output-begin
!      write ( 0, * ) 'saonexray __a_ ' , ier, kray 
!     write ( 0, * ) 'saonexray __b_ ' , jing, j2, kode , in10
!      write ( 0, * ) 'saonexray __c_ ' , xv(1),yv(1),zv(1)
!      write ( 0, * ) 'saonexray __d_ ' , xv(2),yv(2),zv(2)
!      write ( 0, * ) 'saonexray __e_ ' , g_ang
!      write ( 0, * ) 'saonexray __e_ ' , gflag
!dmg-diagnostic-output-end

         JRAY = KRAY
         IER  = 0
         W    = 1.d-8 * in10

         IF (KODE .LE. 4) THEN
   
!---        update weight and count of successful rays
            LEFT1 = LEFT1 + 1
            WS1 = WS1 + W
   
         ELSE
   
!---        ray failed at previous surface
            JAIL1 = JAIL1 + 1
            WF1 = WF1 + W

         END IF

      END IF

      RETURN
 
!---  format statements...

      END
