!+
!KWIC saowrad_foc.f
!
!$Id: saowrad_foc.f,v 1.2 2004/03/17 21:23:42 dtn Exp $
! 
!Revisions:
!   97-Oct-27 [D. Grumm]
!      . change call to c_write to call to the bpipe routine put_ray in 
!        osacbpipe.c
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-12[T. Gaetz]
!      . move /raystuff/ to include file; evaluation of norm is now in
!        saotrader (and a derotation to STD is applied.)
!      . adapt to new c_read argument list
!      . posdir broken into pos, dir
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-20[T. Gaetz]
!      . change c_write argument list; argument energy removed.
!        argument g_ang now a scalar.
!      . /raystuff/:  g_ang(2) --> g_ang
!        (g_ang's arrayness now handled in c_read/c_write)
!   93-Sep-29[T. Gaetz]
!      . renamed to saowrad_foc; change error messages to conform
!   93-Apr-09[T. Gaetz]
!      . change over to fixed version of c_write; clean up debugging
!        debris.
!   93-Apr-05[T. Gaetz]
!      . change over to implicit none;
!      . strip out commented-out statements
!   93-Apr-15[T. Gaetz]
!      . rename common /graze/ to /raystuff/; add energy, norm to common
!-
!
!  UPDATED 2/7/88 TO WRITE THE POLARIZATIOND DATA
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO CURE FORMAT PROBLEM FOR RAY ALONG (0,0,-1)
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  Updated 11-22-91 WAP to change output to E format to fix
!  bug in PV-WAVE
!
      SUBROUTINE SAOWRAD_FOC
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    WRAD FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:08:52
C    *
C    ******************************************/
C
C  WRITE DATA RECORDS OF RAY FILES FOR DRAT
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (3) : ZOFF - Z OFFSET OF FOCAL PLANE
C
C  INPUT VIA LABELED COMMON /PARX/:
C    KURF : I*4 - SURFACE NUMBER
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    FOP  : FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : INTEGER PORTION OF PATH LENGTH
C    JRAY : CURRENT RAY NUMBER
C    JING : CURRENT RING NUMBER
C    J2   : CURRENT SPOKE NUMBER
C    KODE : RAY STATUS CODE (SEE CHEX OUTPUT)
C    W    : RELATIVE INTENSITY OF RAY
C    Q3   : 2ND DERIVATIVE MATRIX OF SURFACE
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW (3, KURF) : FLAT SURFACE SWITCH
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#5 : POSITION OF RAY INTERSECTION
C    V#6 : DIRECTION OF RAY AFTER REFLECTION
C
C  OUTPUT VIA D#24: RAY001, VIA D#26: RAY002
C
C  XR : VFOCUS, VLINE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION

      IMPLICIT NONE

!---  /raystuff/
!     energy     -- ray energy
!     norm       -- surface normal
!     g_ang      -- graze angle for ray-surface intercept
!     posdir_old -- old values of ray position/direction cosine;
!                   restored in the event the ray misses the surface.
!     fgoodrays  -- 'good rays only' flag; if true, consider only
!                   rays which reflect once from each surface.

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/raystuff.h'  ! info needed for binary pipeline
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

!---  local variables...

      DOUBLE PRECISION H, pos(3), dir(3), incept(3), path
      INTEGER          I

!CODE saowrad_foc ------------------------------------------------------

      IF (KODE .GE. 5) GO TO 20
      IF (KODE .LT. 0) GO TO 30
      IF (KODE .EQ. 0) GO TO 50

C *********************************************
C  INTERSECT RAY WITH FOCAL PLANE
      IF (ZV(6) .EQ. 0.0D0) GO TO 10
      H = (GEN (3) + GFOC - ZV (5)) / ZV (6)
      CALL VLINE (5, H, 6, 7)

C  UPDATE PATH LENGTH
      FOP = FOP + H
      I   = FOP + 0.5D0
      IOP = IOP + I
      FOP = FOP - I

      path = 0.d0     ! NOTE!!!  path hardwired to zero

      pos(1) = XV(7)
      pos(2) = YV(7)
      pos(3) = ZV(7)
      dir(1) = XV(6)
      dir(2) = YV(6)
      dir(3) = ZV(6)

      incept(1) = x_incept
      incept(2) = y_incept
      incept(3) = z_incept

      ZV (7) = GEN (3)


!  (INCLUDE THE NEWLY DEFINED POLARIZATION CARD AT THE END)
!  DON'T LET P (6) BE -1.000...
!     WRITE (24, 300) P, IOP, FOP, Q3, C2COMP, S2COMP
!
      IF (dir(3) .EQ. -1.D0) dir(3) = -.99999999999999

      call put_ray(pos, dir, norm, incept, w, energy, g_ang, c2comp,
     &             s2comp, jray, kode, 0)

C  UPDATE RAY SUMMARY FOR SUCCESSFUL RAY
      WS2 = WS2 + W
      LEFT2 = LEFT2 + 1

CBUG  CALL VWRITE ('FOCU', JING, J2, 7, 6, KODE)

C  UPDATE COEFFICIENTS OF QUADRATIC FOCUS FUNCTION
      CALL VFOCUS (7, 6, W, AQ)
      XMIN = MIN (XMIN, XV (7))
      YMIN = MIN (YMIN, YV (7))
      XMAX = MAX (XMAX, XV (7))
      YMAX = MAX (YMAX, YV (7))
CBUG  CALL WRIT8 ('-QUADCOF', 8, 10, AQ)
      GO TO 100
C
10    CONTINUE
C  RAY PARALLEL TO FOCAL PLANE
      KODE = -KURF - 1
      WRITE (8, 400)
      GO TO 100

20    CONTINUE
      IF (KODE .LT. 10*KURF) GO TO 70
      GO TO 40

30    CONTINUE
      IF (KODE .NE. -KURF) GO TO 70

40    CONTINUE
C  RAY FAILED AT CURRENT SURFACE
      JAIL2 = JAIL2 + 1
      WF2 = WF2 + W
      GO TO 70

50    CONTINUE
      WRITE (8, 500)

70    CONTINUE
CBUG  WRITE (8, 800) IOP, H, W

100   RETURN

!---  format statements...

200   FORMAT (5I10, 3F10.6)
300   FORMAT( 3E25.17 / 3E25.17, I5, F15.12, /
     1        3(F12.9,1X), 4X,
     1        3(F12.9,1X), /
     1        4(F15.9,1X) / 4(F15.9,1X))
400   FORMAT ('- RAY PARALLEL TO THE FOCAL PLANE ')
500   FORMAT ('- KODE = 0 : UNDETERMINED ERROR ')
CBUG800   FORMAT ('-SAOWRADB, IOP=', I6, 'H=',F12.6, 'W=',F10.6)
      END
