!+
!KWIC scsum.f
!
!$Id: scsum.f,v 1.2 2004/03/17 21:23:42 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO ELIMINATE MENTION OF SINE-OF-GRAZING-ANGLE
!  SCALE FACTORS, SINCE THEY ARE BEING ELIMINATED
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 12/22/88 TO ALLOW FOR OBSCURATION SURFACES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE SCSUM
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    SCSUM FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/08/81
C    *
C    *    UPDATE:   01/22/82
C    *    TIME:     14:08:11
C    *
C    ******************************************/
C
C  PURPOSE :  WRITE SUMMARY REPORT TO D # 6 AND D # 8
C
C  INPUT VIA /PARX/ :
C     NS   :  NUMBER OF SURFACES
C     MING :  NUMBER OF RINGS IN FIRST SPOKE
C     M2   :  NUMBER OF SPOKES
C
C  INPUT VIA /SUMRY/ :
C     JAIL2 :  NUMBER OF RAYS FAILING SYSTEM
C     LEFT2 :  NUMBER OF RAYS PASSING SYSTEM
C     STAV (1, J) :  SUM OF MAGNITUDES OF SAGITTAL SCALE FACTORS
C     STAV (2, J) :  DITTO FOR TANGENTIAL SCALE FACTORS
C
C  INPUT VIA /RAIN/ :
C     JRAY :  CURRENT (TOTAL NUMBER OF RAYS) RAY NUMBER
C
C  INPUT VIA /SWITCH/ :
C     LSW0 (1) :  X-RAY SYSTEM SWITCH
C     LSW (5, J) :  ANNULAR OBSCURATION SWITCH
C     LSW (6, J) :  RECTANGULAR OBSCURATION SWITCH
C
C  OUTPUT VIA #6 AND #8 :
C     SCALE FACTOR RUN SUMMARY REPORT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      ! fop, iop, jray, jing, mr, ...

      COMMON /SUMRY/ AQ (10), WF1, WF2, WS1, WS2, JAIL1, JAIL2,
     1               LEFT1, LEFT2, XMIN, XMAX, YMIN, YMAX,
     2               WX, WY, WR, WXSQ, WYSQ, STAV (2, 21)
      COMMON /SWITCH/ LSW0 (10), LSW (10, 21)
      DOUBLE PRECISION AQ, WF1, WF2, WS1, WS2
      DOUBLE PRECISION WX, WY, WR, WXSQ, WYSQ
      LOGICAL * 1 LSW0, LSW
      DIMENSION SFDIS (21), SFANG (21), TFDIS (21), TFANG (21)
      DATA RADSEC /4.84814E-06/
C
C
C  OUTPUT SYSTEM PARAMETERS FOR ANY KIND OF SYSTEM
      CALL INCLIN (11)
      WRITE (8, 900) NS, MING, M2, JRAY, LEFT2, JAIL2
!
!C
!C  TELL WHAT TYPE OF SYSTEM
!      IF (LSW0 (1)) GO TO 520
!      CALL INCLIN (4)
!      WRITE (8, 910)
!      GO TO 600
!520   continue
!      CALL INCLIN (4)
!      WRITE (8, 920)
!
C
C  CALCULATE AND OUTPUT AVERAGE SCALE FACTORS AT EACH SURFACE
600   DO 650 J = 1, NS
      SFDIS (J) = RADSEC * STAV (1, J) / LEFT2
      TFDIS (J) = RADSEC * STAV (2, J) / LEFT2
650   CONTINUE
!
!  DEFINE THE NUMBER OF THE FIRST NON-OBSCURATION SURFACE
!
      DO 652 J = 1, NS
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 652
      NFIRST = J
      GO TO 654
652   CONTINUE
!
!  SCALE BY THE VALUES FOR THE FIRST NON-OBSCURATION SURFACE,
!  RATHER THAN BY THOSE OF THE FIRST SURFACE
!
654   DO 660 J = 1, NS
      SFANG (J) = SFDIS (J) / SFDIS (NFIRST)
      TFANG (J) = TFDIS (J) / TFDIS (NFIRST)
660   CONTINUE
!
!  RATHER THAN WRITING THE WHOLE ARRAY AT ONCE, DO IT ONE
!  SURFACE AT A TIME SO THAT THE OBSCURATIONS CAN BE FLAGGED
!  SEPARATELY
!
!     CALL INCLIN (8 + NS)
!     WRITE (8, 930) (J, SFDIS (J), TFDIS (J),
!    1                SFANG (J), TFANG (J), J = 1, NS)
!
      CALL INCLIN (8)
      WRITE (8, 940)
      DO 690 J = 1,NS
!
!  TREAT SEPARATELY FOR AN OBSCURATION
!
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 680
!  (NON-OBSCURATION)
      CALL INCLIN (1)
      WRITE (8, 950) J, SFDIS (J), TFDIS (J),
     1               SFANG (J), TFANG (J)
      GO TO 690
!  (OBSCURATION)
680   continue
      CALL INCLIN (1)
      WRITE (8, 960) J
690   CONTINUE
      RETURN
C
900   FORMAT (/ 25X, 'SCALE FACTOR RUN SUMMARY REPORT' /
     1  25X, 31(1H-) //
     2  10X, 'NUMBER OF SURFACES            :', I6 /
     3  10X, 'NUMBER OF RINGS OF RAYS       :', I6 /
     4  10X, 'NUMBER OF RAYS PER RING       :', I6 /
     5  10X, 'TOTAL NUMBER OF RAYS TRACED   :', I6 //
     6  10X, 'NUMBER OF SUCCESSFUL RAYS     :', I6 /
     7  10X, 'NUMBER OF FAILED RAYS         :', I6 )
910   FORMAT (// T20, '**  SYSTEM WAS NOT AN X-RAY SYSTEM, SO' /
     1  T24, 'GRAZING ANGLE SCALE FACTORS HAVE NOT BEEN INCLUDED  **')
920   FORMAT (// T20,'**  SYSTEM WAS AN X-RAY SYSTEM, SO' /
     1  T24, 'GRAZING ANGLE SCALE FACTORS HAVE BEEN INCLUDED  **')
!
!  REARRANGE FORMAT 930 TO OUTPUT ONE SURFACE AT A TIME
!
!930   FORMAT (// '  AVERAGE SCALE FACTORS FOR 1-ARC-SEC ',
!    1           'SAGITTAL AND TANGENTIAL SCATTERING ANGLES'/
!    2           '  ------------------------------------',
!    3           '----------------------------------------'//
!    4  T5,'SURFACE', T20, 'SAGITTAL', T35, 'TANGENTIAL',
!    5  T50, 'SAGITTAL', T65, 'TANGENTIAL'/
!    6  T5, 'NUMBER', T20, '(DISTANCE)', T35, '(DISTANCE)',
!    7  T50, '(ANGLE)', T65, '(ANGLE)'//
!    8  21 (I7, 1P,E21.3, 3E15.3/))
940   FORMAT (// '  AVERAGE SCALE FACTORS FOR 1-ARC-SEC ',
     1           'SAGITTAL AND TANGENTIAL SCATTERING ANGLES'/
     2           '  ------------------------------------',
     3           '----------------------------------------'//
     4  T5,'SURFACE', T20, 'SAGITTAL', T35, 'TANGENTIAL',
     5  T50, 'SAGITTAL', T65, 'TANGENTIAL'/
     6  T5, 'NUMBER', T20, '(DISTANCE)', T35, '(DISTANCE)',
     7  T50, '(ANGLE)', T65, '(ANGLE)'/)
950   FORMAT (I7, 1P,E21.3, 3E15.3)
960   FORMAT (I7, '      (NO FACTORS - SURFACE IS AN OBSCURATION)')
      END
