!+
!KWIC sctdef.f
!
!$Id: sctdef.f,v 1.2 2004/03/17 21:23:42 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO READ EXPANDED RAY FILES AND GIVE
!  METH=0 IF THE SURFACE IS AN OBSCURATION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE SCTDEF (METH)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    SCTDEF FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/15/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:03:27
C    *
C    ******************************************/
C
C  DETERMINE WHICH SCATTER DEFINITION TO USE AT RAY INTERSECTION
C  AND UPDATE GRAZMN AND GRAZMX IF KURF = 1
C
C  INPUT VIA # (KURF + 8) : DRAT 'RAY' FILE
C    SURFACE INTERSECTION COORDINATES
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    KURF : I*4 - CURRENT SURFACE NUMBER
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW (9, KURF) : LOGICAL*1 - TRUE = X-RAY SURFACE
C
C  INPUT VIA LABELED COMMON /AMNMX/ :
C    NAREAS (KURF) : I*4 - NUMBER OF SCATTER AREAS ON SURF # KURF
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    DP0 (I) : R*4 - ARRAY OF SINS OF GRAZING ANGLES
C
C  INPUT VIA LABELED COMMON /SCLICO/ :
C    SCLIM (I, KURF, J) : R*4 - SCATTER AREA LIMIT PARAMETERS FOR SURF #
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 14 : DIRECTION OF OLD REFLECTED RAY
C    V # 15 : DIRECTION OF INCOMING BUNDLE
C
C  OUTPUT PARAMTER :
C    METH : I*4 - SCATTER DEFINITION NUMBER TO USE
C                 (ZERO MEANS NO SCATTER AT ALL)
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    GRAZMX (I) : R*4 - ARRAY OF MAX VALUES OF SIN-GRAZ-ANG
C    GRAZMN (I) : R*4 - ARRAY OF MIN VALUES OF SIN-GRAZ-ANG
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 10, 11, 12, 13, 14 : SURFACE INTERSECTION INFORMATION :
C                             POSITION (STD)
C                             DIRECTION (STD)
C                             POSITION (BCS)
C                             DIRECTION (BCS) (INCOMING RAY)
C                             DIRECTION (BCS) (REFLECTED RAY)
C
C  XR : VROT8, VSTOR
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SCLICO/ SCLIM (5, 21, 1)
      DATA DEG /57.2958/
C
C
C  GET STD AND BCS INTERSECTION INFORMATION
      NOLD = 14
      IF (KURF .EQ. 1) NOLD = 15
      CALL VSTOR (13, XV (NOLD), YV (NOLD), ZV (NOLD))
      LU = KURF + 8
      READ (LU, 8000) XV (10), YV (10), ZV (10),
     1                XV (11), YV (11), ZV (11), DUM, DUM, DUM
      NDX = 4 * KURF + 26
      CALL VROT8 (10, 11, NDX, NDX + 1, NDX + 2, NDX + 3, 12, 14)
C  (INITIALIZE METHOD TO NO SCATTER)
      METH = 0
      IF (NAREAS (KURF) .EQ. 0) GO TO 950
!
!  ALLOW FOR A NON-SCATTERING OBSCURATION
!
      IF (LSW (5, KURF) .OR. LSW (6, KURF)) GO TO 950
!
C  (SET A AND B - SEE IF X-RAY SURFACE)
      IF (LSW (9, KURF)) GO TO 150
C  (CONVENTIONAL SYSTEM - A,B MEANS X,Y)
      A = XV (12)
      B = YV (12)
      GO TO 200
C  (X-RAY SURFACE - A,B MEANS Z,THETA)
150   A = ZV (12)
      B = DATAN2 (YV (12), XV (12)) * DEG
C  (LOOP THROUGH ALL SCATTER DEFINITION AREAS)
200   KTOP = NAREAS (KURF)
      DO 500 K = 1, KTOP
      IF (SCLIM (1, KURF, K) .LT. 0.) GO TO 450
C  (DEFINE SCATTER AREA LIMITS)
      AMIN = SCLIM (2, KURF, K)
      AMAX = SCLIM (3, KURF, K)
      BMIN = SCLIM (4, KURF, K)
      BMAX = SCLIM (5, KURF, K)
C  (IF X-RAY SURFACE, TAKE CARE OF 360 DEGREE MODULUS ON BMIN-MAX)
      IF (.NOT. LSW (9, KURF)) GO TO 210
      IF (BMIN .EQ. BMAX ) GO TO 210
      IF (B .GE. BMIN) GO TO 210
      BMIN = BMIN - 360.
      BMAX = BMAX - 360.
C  (DETERMINE IF A AND B IN LIMITS OF THIS AREA)
210   IF (AMIN .NE. AMAX) GO TO 220
      IFLGA = 1
      GO TO 260
220   IF (A .LT. AMIN .OR. A .GT. AMAX) GO TO 240
      IFLGA = 1
      GO TO 260
240   IFLGA = -1
260   IF (BMIN .NE. BMAX) GO TO 280
      IFLGB = 1
      GO TO 320
280   IF (B .LT. BMIN .OR. B .GT. BMAX) GO TO 300
      IFLGB = 1
      GO TO 320
300   IFLGB = -1
C  (FLAGS SET - DEFINE METH IF POINT IS IN THE AREA)
320   IF (IFLGA .EQ. -1 .OR. IFLGB .EQ. -1) GO TO 500
      METH = SCLIM (1, KURF, K)
      GO TO 500
C  (ENTRY HERE MEANS WHOLE SURFACE IS DEFINED BY ONE DEFINITION)
450   METH = - SCLIM (1, KURF, K)
500   CONTINUE
C  (UPDATE MIN-MAX OF SIN-GRAZ-ANG, EXIT)
      IF (METH .EQ. 0) GO TO 950
      GRAZMX (KURF) = MAX (GRAZMX (KURF), DP0 (KURF))
      GRAZMN (KURF) = MIN (GRAZMN (KURF), DP0 (KURF))
950   RETURN
C
!  (READ TWO EXTRA LINES)
!  8000  FORMAT (1P,3D25.17 / 3D20.17 / A4)
8000  FORMAT (1P,3D25.17 / 3D20.17 / A4 / A4 / A4)
      END
