!+
!KWIC specpr.f
!
!$Id: specpr.f,v 1.1 2004/03/16 15:50:09 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!-
!
!  UPDATED 2/26/88 TO USE EXPANDED RAY FILES
!  PAUL GLENN, BUAER ASSOCIATES, INC.
!
      SUBROUTINE SPECPR (IUNIT, ITOUT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    SPECPR FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/10/82
C    *
C    *    UPDATE:   02/11/82
C    *    TIME:     11:20:15
C    *
C    ******************************************/
C
C  PURPOSE : TO GATHER AND PRINT SUMMARY INFORMATION FOR
C            EACH SPECULAR RAY INPUT FILE
C
C  INPUT PARAMETERS :
C    IUNIT : I*4 - FILE NUMBER OF INPUT FILE
C    ITOUT : I*4 - RUNNING SUM VALUE OF FILE TYPE PARAMETER
C
C  OUTPUT PARAMETER :
C    ITOUT : I*4 - UPDATED VALUE OF FILE TYPE PARAMETER
C
C  INPUT VIA # IUNIT :
C    INPUT RAY OR ARAY FILE
C
C  OUTPUT VIA # 6 AND # 8 :
C    SUMMARY INFORMATION ABOUT INPUT FILE
C
C  XR : FOVEL, INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      DOUBLE PRECISION AC (10), P (3), XXMIN, XXMAX, YYMIN, YYMAX, XX, YY, ZZ
      DOUBLE PRECISION FDATE1, FDATE2, FTIME1, FTIME2
      DIMENSION FID1 (16), FID2 (16)
C
C
C  READ HEADER, CHECK SURFACE NUMBER, UPDATE FILE TYPE
      READ (IUNIT, 9000, ERR = 2000, END = 2100)
     1  FID1, FDATE1, FTIME1, FID2, FDATE2, FTIME2, MS, LURF
      IF (LURF .NE. -1 .AND. LURF .NE. MS + 1) GO TO 2200
      IF (LURF .EQ. -1) GO TO 120
      ITOUT = ITOUT + 30
      GO TO 130
120   ITOUT = ITOUT + 900
C
C  CALCULATE MIN/MAX INFORMATION
130   XXMIN = 1.D30   !*** WAS D60
      XXMAX = -1.D30  !*** WAS D60
      YYMIN = 1.D30   !*** WAS D60
      YYMAX = -1.D30  !*** WAS D60
150   READ (IUNIT, 9010, ERR = 2000, END = 2100) JRAY, KING, K2,
     1                                           JODE, JN10
      IF (JRAY .LT. 0) GO TO 300
      IF (JODE .GT. 4) GO TO 150
!  (READ TWO ADDITIONAL RECORDS)
      READ (IUNIT, 9020, ERR = 2000, END = 2100) XX, YY, ZZ
      XXMIN = DMIN1 (XXMIN, XX)
      XXMAX = DMAX1 (XXMAX, XX)
      YYMIN = DMIN1 (YYMIN, YY)
      YYMAX = DMAX1 (YYMAX, YY)
      GO TO 150
C
C  CALULATE FOCUS INFORMATION, WRITE SUMMARY
300   CALL INCLIN (11)
      IF (LURF .EQ. -1) GO TO 320
      WRITE (8, 9030)
      GO TO 340
320   continue
      WRITE (8, 9040)
C
340   continue
      WRITE (8, 9045) FID1, FDATE1, FTIME1, FID2, FDATE2, FTIME2,
     1                XXMIN, YYMIN, XXMAX, YYMAX
      READ (IUNIT, 9050, ERR = 2000, END = 2100) WTOT, AC
      CALL FOVEL (AC, P, SPOT)
      REWIND IUNIT
      READ (IUNIT, 9000)
     1  FID1, FDATE1, FTIME1, FID2, FDATE2, FTIME2, MS, LURF
      RETURN
C
2000  continue
      CALL INCLIN (1)
      WRITE (8, 8000) IUNIT
      STOP 8
2100  continue
      CALL INCLIN (1)
      WRITE (8, 8100) IUNIT
      STOP 8
2200  continue
      CALL INCLIN (2)
      WRITE (8, 8200) IUNIT, MS, LURF
      STOP 8
2300  continue
      CALL INCLIN (1)
      WRITE (8, 8300) IER, IUNIT
      STOP 8
C
8000  FORMAT ('  SPECPR FATAL ERR READING ON FILE', I3)
8100  FORMAT ('  SPECPR FATAL EOF READING ON FILE', I3)
8200  FORMAT ('  SPECPR ERROR - NON-FOCAL-PLANE SPECULAR RAY ',
     1        'FILE ON UNIT', I3 / '  (NS, KURF) :', 2I6)
8300  FORMAT ('  SPECPR FATAL ERR', I3, ' FROM REHEAD ON FILE', I3)
9000  FORMAT (2 (1X, 15A4, A1, 1X, A8, 1X, A8 /), 2I5)
9010  FORMAT (5I10)
!  (READ TWO ADDITIONAL RECORDS)
9020  FORMAT (3D25.17 // //)
9030  FORMAT (// T15, 'SUMMARY INFORMATION FOR NABRAT OR DRAT ''RAY'' ',
     1                'FILE' /
     2           T15, '---------------------------------------------',
     3                '----' /)
9040  FORMAT (// T18, 'SUMMARY INFORMATION FOR DEDRIQ ''ARAY'' FILE' /
     1           T18, '------------------------------------------' /)
9045  FORMAT (2 (1X, 15A4, A1, 1X, A8, 1X, A8 /),
     1        / 14X, 'MINIMUM', 26X, 'MAXIMUM',
     2        /, 8X, 'X', 16X, 'Y', 15X, 'X', 16X, 'Y', /,
     3        4 (1P,E16.8, 1X))
9050  FORMAT (20X, D20.12 / 2 (4D20.12 /), 2D20.12)
      END
