!+
!KWIC ssdef.f
!
!$Id: ssdef.f,v 1.2 2004/03/17 21:23:42 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!      . convert PI2 to real*8; initialize as parameter
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!-
!
!  UPDATED 2/26/88 TO IGNORE REFLECTIVITY VARIATIONS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!      SUBROUTINE SSDEF (IRFLG)
!
      SUBROUTINE SSDEF
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    SSDEF FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/15/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:02:17
C    *
C    ******************************************/
C
C  READ AND CHECK THE 'SCAT' FILE, INITIALIZE ARRAYS
C
C  INPUT VIA # 3 : 'SCAT' FILE
C    ALL SCATTER RUN DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW0 (1) : LOGICAL*1 - XRAY SYSTEM SWITCH
C
C  INPUT VIA LABELED COMMON /LIMITS/ :
C    NDEFN : I*4 - NUMBER OF ALLOWED ENTRIES IN SCATTER DEFINITION TABLE
C    NGRID : I*4 - NUMBER OF X OR Y PIXELS ALLOWED IN FOCAL PLANE ARRAY
C
C  OUTPUT PARAMETER :
C    IFFLG : LOGICAL*1 - .TRUE. = REFLECTIVITY LOOK-UP MUST BE USED
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    NDEFS      : I*4 - NUMBER OF SCATTER DEFINITIONS
C    NAREAS (I) : I*4 - NUMBER OF SCATTER AREAS ON EACH SURFACE
C
C  OUTPUT VIA LABELED COMMON /FPGRCO/ :
C    FPGRID : R*4 - FOCAL PLANE ARRAY INITIALIZED TO ZERO
C
C  OUTPUT VIA LABELED COMMON /PARAMS/ :
C    ZLAM : R*4 - WAVELENGTH OF TRACED RAYS
C    ZK   : R*4 - WAVENUMBER OF TRACED RAYS
C
C  OUTPUT VIA LABELED COMMON /SCLICO/ :
C    SCLIM (I, J, K) : R*4 - SCATTER AREA LIMIT DEFINITIONS
C                      I=1 : SATTER DEFINITION NUMBER
C                      I=2 : (X OR R) MIN
C                      I=3 : (X OR R) MAX
C                      I=4 : (Y OR THETA) MIN
C                      I=5 : (Y OR THETA) MAX
C                      J = SURFACE NUMBER
C                      K = SCATTER DEFINITION NUMBER
C
C  OUTPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - SCATTER DEFINITIONS
C                  I INDEX COVERS PARAMETERS FOR THE DEFINITIONS
C                          (I=1 MEANS SDEF (I, J) IS THE METHOD #)
C                  J = SCATTER DEFINITION NUMBER
C
C  OUTPUT VIA LABELED COMMON /TABLES/ :
C    V2TAB, GTAB, G1TAB, G2TAB, AND G3TAB :
C                        PSD LOOK-UP TABLES (SEE TABGEN)
C    ACCG : R*4 - ACCURACY OF PSD LOOK-UP TABLES
C    ACCR : R*4 - ACCURACY OF REFLECTIVITY LOOK-UP TABLE
C    FOGR : R*4 - ARRAY OF FOCAL PLANE DEFINITION PARAMETERS
C
C  XR : PCHK1, PCHK2, TABGEN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /FPGRCO/ FPGRID (1)
      COMMON /LIMITS/ NAREA, NDEFN, NDTOT, NGRID, NTABG, NTABR, NTABF
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DOUBLE PRECISION FOGR
!      LOGICAL * 1 IRFLG, ITRUE, IFALSE
      DOUBLE PRECISION    PI2
      PARAMETER ( PI2 = 6.283185307179586476925287D0 )
!      DATA ITRUE, IFALSE /.TRUE., .FALSE./
C
C
C  READ FOCAL PLANE DEFINITION PARAMETERS
      READ (3, * ) (FOGR (J), J = 1, 4), NX, NY !*** changed to 
                                                !*** free form input
      FOGR (5) = NX
      FOGR (6) = NY
      IF (DABS (FOGR (1)) .GT. 1000.D0) GO TO 7000
      IF (DABS (FOGR (2)) .GT. 1000.D0) GO TO 7000
      IF (FOGR (3) .LE. 0.D0 .OR. FOGR (3) .GT. 1000.D0) GO TO 7000
      IF (FOGR (4) .LE. 0.D0 .OR. FOGR (4) .GT. 1000.D0) GO TO 7000
      IF (NX .LT. 1 .OR. NX .GT. NGRID) GO TO 7000
      IF (NY .LT. 1 .OR. NY .GT. NGRID) GO TO 7000
C  (FOCAL PLANE PARAMS OK - READ AND CHECK SYSTEM PARAMS)
      READ (3, * ) ZLAM   !*** changed to free form input
      IF (ZLAM .LE. 0.) GO TO 7100
      ZK = PI2 / ZLAM
      READ (3, * ) ACCG, ACCF, ACCR !*** changed to free form input
      IF (ACCG .LE. 0. .OR. ACCG .GE. 1.) GO TO 7150
      IF (ACCF .LE. 0. .OR. ACCF .GE. 1.) GO TO 7150
!
!  DON'T DO ANYTHING WITH IRFLG, AND DON'T CHECK ACCR, SINCE
!  IT WON'T BE USED
!
!      IRFLG = IFALSE
!      IF (GEN (5) .EQ. -1.D0 .AND. GEN (6) .EQ. 0.D0) GO TO 140
!      IF (.NOT. LSW0 (1)) GO TO 140
!      IRFLG = ITRUE
!      IF (ACCR .LE. 0. .OR. ACCR .GE. 1.) GO TO 7150
!
140   READ (3, * ) NDEFS  !*** changed to free form input
      IF (NDEFS .LT. 1 .OR. NDEFS .GT. NDEFN) GO TO 7200
C  (LOOP THROUGH ALL SCATTER DEFINITIONS)
      DO 150 J = 1, NDEFS
      CALL PCHK1 (J)
150   CONTINUE
C  (LOOP THROUGH ALL SCATTER AREA DEFINITIONS)
200   CALL PCHK2 (IER)
      IF (IER .NE. -1) GO TO 200
C  (CREATE PSD LOOK-UP TABLES)
      CALL TABGEN
C  (CLEAR OUT FOCAL PLANE ARRAY)
      NCLEAR = NX * NY
      DO 300 NC = 1, NCLEAR
      FPGRID (NC) = 0.
300   CONTINUE
      RETURN
C
7000  continue
      WRITE (8, 8040) FOGR
      STOP 8
7100  continue
      WRITE (8, 8050) ZLAM
      STOP 8
7150  continue
      WRITE (8, 8055) ACCG, ACCF, ACCR
      STOP 8
7200  continue
      WRITE (8, 8060) NDEFS, NDEFN
      STOP 8
C
C !*** input was changed to free format
C
C  8010  FORMAT (4D15.0, 2I6)
C  8020  FORMAT (E15.0)
C  8025  FORMAT (3E15.0)
C  8030  FORMAT (I6)
C
8040  FORMAT ('  SSDEF ERROR - ILLEGAL FOCAL PLANE PARAMETER(S) :'/
     1  1P,6D12.5)
8050  FORMAT ('  SSDEF ERROR - LAMBDA =', 1P,E10.4, '  (.LE. 0.)')
8055  FORMAT ('  SSDEF ERROR - ACCURACY (G, F, R) =', 1P,3E10.3)
8060  FORMAT ('  SSDEF ERROR - # OF SCATTER DEF''S (INPUT, LIMIT) =',
     1  2I6)
      END
