!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!
!  UPDATED 1/22/88 TO ADD OBSCURATION-TYPE SURFACES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE STUFF (SF, LS)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    STUFF FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 09/05/80
C    *
C    *    UPDATE:   09/25/80
C    *    TIME:     10:22:57
C    *
C    ******************************************/
C
C  CONDENSE THE ARRAY OF SURFACE GEOMETRY PARAMETERS
C  FOR OUTPUT TO THE GX FILE
C
C  INPUT AND OUTPUT ARGUMENTS:
C    SF : 13*R*8 - SURFACE PARAMETERS
C    LS : 10*L*1 - SURFACE SWITCHES
C
C  EXTERNAL REFERENCES : NONE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      DOUBLE PRECISION SF (13), A, B, C, D, S, ZP
      LOGICAL * 1 LS (10)
C
C  IS THE SURFACE FLAT?
      IF (LS (3)) GO TO 150
!
!  IS THE SURFACE AN OBSCURATION?
      IF (LS (5) .OR. LS (6)) GO TO 200
C
C  IS THE SURFACE OFF-AXIS?
      IF (.NOT. LS (4)) GO TO 300
C
C  OFF-AXIS SURFACE:
C  TRANSFORM FROM BODY CENTERED SYSTEM TO PARENT CENTERED SYSTEM
C  SOLVE EQUATION OF THE FORM A*ZP**2 + 2*B*ZP + C = 0
C  WHERE A = P
C        B = K
C        C = YEP**2 - RO**2
C
      A = SF (4)
      B = -SF (5)
      C = SF (9) ** 2 - SF (6) ** 2
C
C  IS THE EQUATION DEGENERATE?
      IF (ABS (DBLE (A * C)) .GT. .004 * DBLE (B * B)) GO TO 50
C
C  YES. TAKE THE MACLAURIN APPROXIMATION OF THE NEAR ROOT
      S = 0.25D0 / B
      C = C * S
      D = C + C
      S = S + S
      S = D * A * (S + S)
      ZP = -(D + C * (S + S * (S + S ** 2 * (1.25 + 1.75 * DBLE (S)))))
      GO TO 100
C
C  EQUATION IS NOT DEGENERATE
50    D = DSQRT (B * B - A * C)
      ZP = (DSIGN (D, B) - B) / A
C
C  NEW RO = YEP:
100   SF (6) = SF (9)
C  NEW K:
      SF (5) = SF (5) - SF (4) * ZP
C  NEW Z0:
      SF (3) = SF (3) + ZP
C  BORESIGHT ANGLE:
      SF (9) = SF (11)
      GO TO 300
C
C  FLAT SURFACE: REARRANGE AZF, ELF, ZFOLD
C  AZF:
150   SF (4) = SF (11)
C  ELF:
      SF (5) = SF (12)
C  ZFOLD:
      SF (6) = SF (13)
      GO TO 300
!
!  OBSCURATION-TYPE SURFACE: REARRANGE DIM1, DIM2, ZROT8
!  DIM1:
200   SF (4) = SF (9)
!  DIM2:
      SF (5) = SF (10)
!  ZROT8:
      SF (6) = SF (13)
C
300   RETURN
      END
