!
!+
!KWIC tabgen.f
!
!$Id: tabgen.f,v 1.1 2004/03/16 15:50:12 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Jan-20[T. Gaetz]
!      . OSAC V7.0 version of routine
!-
!  UPDATED 2/20/88 TO CREATE THE TABLES ONLY AS FAR AS THE
!  MACHINE'S SMALLEST NUMBER (10**-37) JUSTIFIES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 2/26/88 TO CHANGE COMMON /AMNMX/
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 12/3/88 TO FIX BUG IN 2/20/88 FIX ABOVE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/17/89 TO ADD EXPONENTIAL-EXPONENTIAL, EXPONENTIAL-
!  GAUSSIAN, AND GAUSSIAN-GAUSSIAN AUTOCOVARIANCE FUNCTIONS, WITH
!  EVERY TERM BEING MULTIPLIED BY A COSINE.
!  ALSO, CHANGED SINGLE PRECISION CONSTANTS (0., ETC.) TO DOUBLE
!  PRECISION TO PROVIDE FUTURE COMPATIBILITY WITH OTHER COMPILERS
!  AND SYSTEMS.
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 2/19/90 TO CORRECT THE NORMALIZATION OF THE
!  NUMERICAL INTEGRATION OF SIGMA**2 WHEN USING
!  METHODS 102 AND 104 (EXP(BR)/SQRT(BR))
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!  LORENTZIAN PSD (METHOD 110), AND TO MAKE EPS=1.D-8 FOR ALL
!  CALLS TO EEVAL FOR [r g(r)] 1ST AND 2ND DERIVATIVES, SINCE
!  EEVAL SCALES THE 1ST DERIVATIVES TO BE DIMENSIONLESS, WHICH
!  MEANS THAT THE EPS VALUES SHOULD ALSO BE DIMENSIONLESS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE TABGEN
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    TABGEN FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/18/81
C    *
C    *    UPDATE:   02/08/82
C    *    TIME:     09:32:00
C    *
C    ******************************************/
C
C  CREATE LOOK-UP TABLES FOR V**2 AND G (V**2);
C  EVALUATE SIGMA**2, AND FIND (ACV (R0)) .ST. (R0 * ACV (R0)) IS MAX;
C  CREATE LOOK-UP TABLE FOR (VZ**2 * SIGMA**2) (CALL THAT 'ARG') AND
C                           ((1. - EXP (- ARG)) / ARG)
C
C  INPUT VIA LABELED COMMON /AMNMX/ :
C    NDEFS : I*4 - NUMBER OF SCATTER DEFINITIONS
C
C  INPUT VIA LABELED COMMON /LIMITS/ :
C    NTABG : I*4 - NUMBER OF ENTRIES IN G (V**2) LOOK-UP TABLE
C    NTABR : I*4 - NUMBER OF ENTRIES IN REFL (SIN THETA) TABLE
C    NTABF : I*4 - NUMBER OF ENTRIES IN F (VZ**2 * SIGMA**2) TABLE
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    ACCG : R*4 - DESIRED ACCURACY OF G (V**2) LOOK-UP TABLES
C    ACCR : R*4 - DESIRED ACCURACY OF REFL (SIN THETA) TABLE
C    ACCF : R*4 - DESIRED ACCURACY OF F (VZ**2 * SIGMA**2) TABLE
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZK : R*4 - SYSTEM WAVENUMBER
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - ARRAY OF SCATTER DEFINITION PARAMETERS
C
C  OUTPUT VIA LABELED COMMON /TABLES/ :
C    V2TAB (I, J) : R*4 - ARRAY OF VALUES OF V**2
C    GTAB (I, J)  : R*4 - ARRAY OF VALUES OF G (V**2)
C    GTAB1 (I, J) : R*4 - PROCESS #1 COMPONENT OF GTAB
C    GTAB2 (I, J) : R*4 - PROCESS #2 COMPONENT OF GTAB
C    GTAB3 (I, J) : R*4 - PROCESS #3 COMPONENT OF GTAB
C    SIGSQ (I, J) : R*4 - ARRAY OF VALUES OF SIGMA ** 2
C    G0R (I, J)   : R*4 - ARRAY OF VALUES OF ACV (R0)
C
C  XR : DCADRE, EEVAL, INCLIN, NEWTON, SIGINI (WITH ENTRY POINT DCSIG)
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
      EXTERNAL DCSIG
 
      DIMENSION BK (8)
      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /LIMITS/ NAREA, NDEFN, NDTOT, NGRID, NTABG, NTABR, NTABF
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DOUBLE PRECISION FOGR
      DOUBLE PRECISION ZKD, ERR
      DOUBLE PRECISION DUMMY, SIGINI, DCSIG, DCADRE
      DATA PI2 / 6.28318 53071 79586 47692D0/
      DATA PI4 /12.56637 06143 59172 95384D0/
C
C
C  LOOP THROUGH EACH SCATTER DEFINITION
      DO 4000 I = 1, NDEFS
C
C  FIND METHOD #, AND THEN EVALUATE SIGMA ** 2 AND ACV (R0)
      NSYS = SDEF (1, I)
!
!  ALLOW FOUR MORE USER METHODS
!      GO TO (1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800), NSYS
!
      GO TO (1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800,
     *       1900, 2000, 2100, 2200), NSYS
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #1
C
1100  ARG = (ZK / SDEF (3, I)) ** 2
      SIGSQ (1, I) = 0.5D0 * SDEF (2, I) * LOG (1.D0 + ARG)
      SIGSQ (2, I) = SDEF (4, I)
      SIGSQ (3, I) = 0.D0
      GR0 (1, I) = SDEF (2, I) * 0.7841D0
      GR0 (2, I) = SDEF (4, I) * 0.3679D0
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #2
C
1200  CONTINUE
      DUMMY = SIGINI (I)
      ZKD = ZK
!
!  DIVIDE BY THE PROPER 2 PI NORMALIZING FACTOR
!
!      SIGSQ (1, I) = DCADRE (DCSIG, 0.D0, ZKD, 0.D0, 0.01D0, ERR, IER)
!
      SIGSQ (1, I) = DCADRE (DCSIG, 0.D0, ZKD, 0.D0, 0.01D0, ERR, IER)
     *             / PI2
!
      IF (IER .LT. 66) GO TO 1220
      CALL INCLIN (2)
      WRITE (8, 8000) I, IER, (SDEF (J, I), J = 2, 5)
1220  SIGSQ (2, I) = SDEF (4, I)
      SIGSQ (3, I) = 0.D0
      GR0 (1, I) = SDEF (2, I) * 0.8578D0
      GR0 (2, I) = SDEF (4, I) * 0.3679D0
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #3
C
1300  ARG = (ZK / SDEF (3, I)) ** 2
      SIGSQ (1, I) = 0.5D0 * SDEF (2, I) * LOG (1.D0 + ARG)
      SIGSQ (2, I) = SDEF (4, I)
      SIGSQ (3, I) = SDEF (6, I)
      GR0 (1, I) = SDEF (2, I) * 0.7841D0
      GR0 (2, I) = SDEF (4, I) * 0.3679D0
      RGUESS = 1.D0 / SDEF (5, I)
!      EPS = .001D0 * SDEF (5, I)
      EPS = 1.D-8
!
!  CALL NEWTON WITH THE CORRECT PARAMETER FOR R*G(R) !
!      CALL NEWTON (I, RGUESS, 0.D0, EPS, R0, SLOPE)
      CALL NEWTON (100 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (3, I) = SDEF (6, I) * EXP (- SDEF (5, I) * R0) *
     1                           COS (SDEF (7, I) * R0)
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #4
C
1400  DUMMY = SIGINI (I)
      ZKD = ZK
!
!  DIVIDE BY THE PROPER 2 PI NORMALIZING FACTOR
!
!      SIGSQ (1, I) = DCADRE (DCSIG, 0.D0, ZKD, 0.D0, 0.01D0, ERR, IER)
!
      SIGSQ (1, I) = DCADRE (DCSIG, 0.D0, ZKD, 0.D0, 0.01D0, ERR, IER)
     *             / PI2
!
      IF (IER .LT. 66) GO TO 1420
      CALL INCLIN (2)
      WRITE (8, 8000) I, IER, (SDEF (J, I), J = 2, 7)
1420  SIGSQ (2, I) = SDEF (4, I)
      SIGSQ (3, I) = SDEF (6, I)
      GR0 (1, I) = SDEF (2, I) * 0.8578D0
      GR0 (2, I) = SDEF (4, I) * 0.3679D0
      RGUESS = 1.D0 / SDEF (5, I)
!      EPS = .001D0 * SDEF (5, I)
      EPS = 1.D-8
!
!  CALL NEWTON WITH THE CORRECT PARAMETER FOR R*G(R) !
!      CALL NEWTON (I, RGUESS, 0.D0, EPS, R0, SLOPE)
      CALL NEWTON (100 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (3, I) = SDEF (6, I) * EXP (- SDEF (5, I) * R0) *
     1                           COS (SDEF (7, I) * R0)
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #5
C
1500  SIGSQ (1, I) = SDEF (2, I)
      SIGSQ (2, I) = SDEF (4, I)
      SIGSQ (3, I) = 0.D0
      GR0 (1, I) = SDEF (2, I) * 0.3679D0
      GR0 (2, I) = SDEF (4, I) * 0.3679D0
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #6
C
1600  SIGSQ (1, I) = SDEF (2, I)
      SIGSQ (2, I) = 0.D0
      SIGSQ (3, I) = 0.D0
      GR0 (1, I) = SDEF (2, I) * 0.6065D0
      GR0 (2, I) = 0.D0
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 FOR METHOD #7) (ACV (R0) NOT TO BE DONE
C
1700  SIGSQ (1, I) = SDEF (4, I) * SDEF (3, I) ** (2.D0 - SDEF (5, I))
     1                           / PI4
      NSEGS = SDEF (2, I)
      DO 1770 J = 1, NSEGS
      NDX = 3 * J
      ZKBOT = SDEF (NDX, I)
      IF (ZKBOT .GT. ZK) GO TO 1770
      ZKTOP = SDEF (NDX + 3, I)
      IF (ZKTOP .GT. ZK) ZKTOP = ZK
      B2 = 2.D0 - SDEF (NDX + 2, I)
      IF (B2 .EQ. 0.D0) GO TO 1720
      SIGSQ (1, I) = SIGSQ (1, I) + SDEF (NDX + 1, I) *
     1  (ZKTOP ** B2 - ZKBOT ** B2) / (B2 * PI2)
      GO TO 1770
1720  SIGSQ (1, I) = SIGSQ (1, I) + SDEF (NDX + 1, I) *
     1  LOG (ZKTOP / ZKBOT) / PI2
1770  CONTINUE
      SIGSQ (2, I) = 0.D0
      SIGSQ (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 FOR METHOD #8 (ACV (R0) NOT TO BE DONE)
C  (FOR METHOD #8 (GRATING PSD), DON'T DO V**2 -- G (V**2) TABLE)
C
1800  SIGSQ (1, I) = 0.5D0 * SDEF (2, I) ** 2
      SIGSQ (2, I) = 0.5D0 * SDEF (4, I) ** 2
      SIGSQ (3, I) = 0.D0
      GO TO 4000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #9
C
1900  SIGSQ (1, I) = SDEF (2, I)
      SIGSQ (2, I) = SDEF (5, I)
      SIGSQ (3, I) = 0.D0
      RGUESS = 1.D0 / SDEF (3, I)
!      EPS = .001D0 * SDEF (3, I)
      EPS = 1.D-8
      CALL NEWTON (100 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (1, I) = SDEF (2, I) * EXP (- SDEF (3, I) * R0) *
     1                           COS (SDEF (4, I) * R0)
      RGUESS = 1.D0 / SDEF (6, I)
!      EPS = .001D0 * SDEF (6, I)
      EPS = 1.D-8
      CALL NEWTON (200 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (2, I) = SDEF (5, I) * EXP (- SDEF (6, I) * R0) *
     1                           COS (SDEF (7, I) * R0)
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #10
C
2000  SIGSQ (1, I) = SDEF (2, I)
      SIGSQ (2, I) = SDEF (5, I)
      SIGSQ (3, I) = 0.D0
      RGUESS = 1.D0 / SDEF (3, I)
!      EPS = .001D0 * SDEF (3, I)
      EPS = 1.D-8
      CALL NEWTON (100 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (1, I) = SDEF (2, I) * EXP (- SDEF (3, I) * R0) *
     1                           COS (SDEF (4, I) * R0)
      RGUESS = 1.D0 / SDEF (6, I)
!      EPS = .001D0 * SDEF (6, I)
      EPS = 1.D-8
      CALL NEWTON (200 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (2, I) = SDEF (5, I) * EXP (- SDEF (6, I) * R0 * R0) *
     1                           COS (SDEF (7, I) * R0)
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #11
C
2100  SIGSQ (1, I) = SDEF (2, I)
      SIGSQ (2, I) = SDEF (5, I)
      SIGSQ (3, I) = 0.D0
      RGUESS = 1.D0 / SDEF (3, I)
!      EPS = .001D0 * SDEF (3, I)
      EPS = 1.D-8
      CALL NEWTON (100 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (1, I) = SDEF (2, I) * EXP (- SDEF (3, I) * R0 * R0) *
     1                           COS (SDEF (4, I) * R0)
      RGUESS = 1.D0 / SDEF (6, I)
!      EPS = .001D0 * SDEF (6, I)
      EPS = 1.D-8
      CALL NEWTON (200 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      GR0 (2, I) = SDEF (5, I) * EXP (- SDEF (6, I) * R0 * R0) *
     1                           COS (SDEF (7, I) * R0)
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  EVALUATE SIGMA ** 2 AND ACV (R0) FOR METHOD #12
C
2200  SIGSQ (1, I) = SDEF (2, I)
      SIGSQ (2, I) = 0.D0
      SIGSQ (3, I) = 0.D0
      B = SDEF (3, I)
      F0 = SDEF (4, I)
      RGUESS = (B / 20.D0) / F0
      EPS = 1.D-8
      CALL NEWTON (100 + I, RGUESS, 0.D0, EPS, R0, SLOPE)
      Z = PI2 * F0 * R0
      DNU = B / 2.D0 - 1.D0
      NIN = 1 + IDINT (DNU)
      XNU = DMOD (DNU, 1.D0)
      CALL DBESKS (XNU, Z, NIN, BK)
      GR0 (1, I) = SDEF (2, I) * 2.D0 ** (1.D0 - DNU) *
     *             Z ** DNU * BK (NIN) / DGAMMA (DNU)
      GR0 (2, I) = 0.D0
      GR0 (3, I) = 0.D0
      GO TO 3000
C
C  CREATE V**2 -- G (V**2) LOOK-UP TABLE FOR THIS DEFINITION
C
3000  CALL EEVAL (I, 0.D0, 0, GORIG, DUM1, DUM2, DUM3)
                                !*** was dum,dum,dum
      V2TAB (1, I) = 0.D0
      IF (NSYS .EQ. 7) GO TO 3500
C  (DO FIRST ENTRY FOR NON-PIECEWISE PSD)
      GTARG = GORIG * (1.D0 - ACCG)
      EPS = 0.01D0 * ACCG * GTARG
      CALL NEWTON (I, 0.D0, GTARG, EPS, V2TAB (2, I), GACT)
      VSQ = 0.5D0 * V2TAB (2, I)
      CALL EEVAL (I, VSQ, 0, GTAB (1, I), GTAB1 (1, I),
     1                       GTAB2 (1, I), GTAB3 (1, I))
C  (LOOP THROUGH EACH TABLE ENTRY)
      DO 3100 J = 2, NTABG
      GTARG = GTARG * (1.D0 - ACCG)
      EPS = 0.01D0 * ACCG * GTARG
      GUESS = 2.D0 * V2TAB (J, I) - V2TAB (J - 1, I)
      CALL NEWTON (I, GUESS, GTARG, EPS, V2TAB (J + 1, I), GACT)
      VSQ = 0.5D0 * (V2TAB (J, I) + V2TAB (J + 1, I))
      CALL EEVAL (I, VSQ, 0, GTAB (J, I), GTAB1 (J, I),
     1                       GTAB2 (J, I), GTAB3 (J, I))
!
!  CHECK FOR THE VALUE OR DERIVATIVE BEING SMALLER THAN 10**-37
!
      IF (DABS (GTAB (J, I)) .LT. 1.D-37) GO TO 3200
      DERIV = (GTAB (J, I) - GTAB (J - 1, I)) /
     *        (V2TAB (J + 1, I) - V2TAB (J, I))
      IF (DABS (DERIV) .LT. 1.D-37) GO TO 3200
!
3100  CONTINUE
      GO TO 3900
!
!  TOO-SMALL NUMBERS WERE ENCOUNTERED - FILL THE REST OF THE
!  TABLE WITH INCREASING V**2 AND REPEATED G (J WAS THE LAST
!  SUCCESSFUL INDEX)
!
3200  IF (J .EQ. NTABG) GO TO 3900
      DV2 = V2TAB (J + 1, I) - V2TAB (J, I)
      GLAST = GTAB (J, I)
      GLAST1 = GTAB1 (J, I)
      GLAST2 = GTAB2 (J, I)
      GLAST3 = GTAB3 (J, I)
      JJBOT = J + 1
      DO 3300 JJ = JJBOT, NTABG
      V2TAB (JJ + 1, I) = V2TAB (JJ, I) + DV2
      GTAB (JJ, I) = GLAST
      GTAB1 (JJ, I) = GLAST1
      GTAB2 (JJ, I) = GLAST2
      GTAB3 (JJ, I) = GLAST3
3300  CONTINUE
      GO TO 3900
!
C  (DO FIRST TWO ENTRIES FOR PIECEWISE PSD)
3500  GTAB (1, I) = GORIG
      V2TAB (2, I) = SDEF (3, I) * SDEF (3, I)
      NDX = 3
      GTARG = GORIG * (1.D0 - ACCG)
      GOVERA = GTARG / SDEF (NDX + 1, I)
      BINV = -1.D0 / SDEF (NDX + 2, I)
      V2TAB (3, I) = GOVERA ** (2.D0 * BINV)
      V2 = 0.5D0 * (V2TAB (2, I) + V2TAB (3, I))
      GTAB (2, I) = SDEF (NDX + 1, I) * V2 **
     *              (-0.5D0 * SDEF (NDX + 2, I))
C  (LOOP THROUGH EACH TABLE ENTRY)
      DO 3600 J = 3, NTABG
      GTARG = GTARG * (1.D0 - ACCG)
      GOVERA = GTARG / SDEF (NDX + 1, I)
      BINV = -1.D0 / SDEF (NDX + 2, I)
      V = GOVERA ** BINV
3520  CONTINUE
      IF (V .LT. SDEF (NDX + 3, I)) GO TO 3540
      NDX = NDX + 3
      GOVERA = GTARG / SDEF (NDX + 1, I)
      BINV = -1.D0 / SDEF (NDX + 2, I)
      V = GOVERA ** BINV
      GO TO 3520
3540  V2TAB (J + 1, I) = V * V
      V2FORG = 0.5D0 * (V2TAB (J, I) + V2TAB (J + 1, I))
      GTAB (J, I) = SDEF (NDX + 1, I) * V2FORG **
     1              (-0.5D0 * SDEF (NDX + 2, I))
3600  CONTINUE
C  (RESET FIRST AND LAST V**2 ENTRIES TO +/- INFINITY)
3900  V2TAB (1, I) = -1.D30   !*** CHANGED D60 TO D30H
      V2TAB (NTABG + 1, I) = 1.D30
4000  CONTINUE
C
C  CREATE LOOK-UP TABLE OF (VZ**2 * SIGMA ** 2) VS.
C  ((1. - EXP (-VZ**2 * SIGMA**2)) / (VZ**2 * SIGMA**2))
C
      VZSTAB (1) = 0.D0
C  (DO FIRST ENTRY)
      FVSTAR = 1.D0 - ACCF
      EPS = 0.01D0 * ACCF * FVSTAR
!
!  CHANGE NEWTON CALL
!      CALL NEWTON (201, 0.D0, FVSTAR, EPS, VZSTAB (2), FACT)
      CALL NEWTON (-2, 0.D0, FVSTAR, EPS, VZSTAB (2), FACT)
      VZSIG = 0.5D0 * VZSTAB (2)
!  CHANGE EEVAL CALL
!      CALL EEVAL (201, VZSIG, 0, FVSTAB (1), DUM1, DUM2, DUM3)
      CALL EEVAL (-2, VZSIG, 0, FVSTAB (1), DUM1, DUM2, DUM3)
C  (LOOP THROUGH EACH TABLE ENTRY)
      DO 4100 J = 2, NTABF
      FVSTAR = FVSTAR * (1.D0 - ACCF)
      EPS = 0.01D0 * ACCF * FVSTAR
      GUESS = 2.D0 * VZSTAB (J) - VZSTAB (J - 1)
!
!  CHANGE NEWTON CALL
!      CALL NEWTON (201, GUESS, FVSTAR, EPS, VZSTAB (J + 1), FACT)
      CALL NEWTON (-2, GUESS, FVSTAR, EPS, VZSTAB (J + 1), FACT)
      VZSIG = 0.5D0 * (VZSTAB (J) + VZSTAB (J + 1))
!
!  CHANGE EEVAL CALL
!      CALL EEVAL (201, VZSIG, 0, FVSTAB (J), DUM1, DUM2, DUM3)
      CALL EEVAL (-2, VZSIG, 0, FVSTAB (J), DUM1, DUM2, DUM3)
!
!  CHECK FOR THE VALUE OR DERIVATIVE BEING SMALLER THAN 10**-37
!
      IF (DABS (FVSTAB (J)) .LT. 1.D-37) GO TO 4200
      DERIV = (FVSTAB (J) - FVSTAB (J - 1)) /
     *        (VZSTAB (J + 1) - VZSTAB (J))
      IF (DABS (DERIV) .LT. 1.D-37) GO TO 4200
!
4100  CONTINUE
      GO TO 4900
!
!  TOO-SMALL NUMBERS WERE ENCOUNTERED - FILL THE REST OF THE
!  TABLE WITH INCREASING VZ**2*SIGMA**2 AND REPEATED FVS (J WAS
!  THE LAST SUCCESSFUL INDEX)
!
4200  IF (J .EQ. NTABF) GO TO 4900
      DVS = VZSTAB (J + 1) - VZSTAB (J)
      FLAST = FVSTAB (J)
      JJBOT = J + 1
      DO 4300 JJ = JJBOT, NTABF
      VZSTAB (JJ + 1) = VZSTAB (JJ) + DVS
      FVSTAB (JJ) = FLAST
4300  CONTINUE
4900  CONTINUE
!
C  (RESET FIRST AND LAST VZ**2*SIG**2 ENTRIES TO +/- INFINITY)
C
      VZSTAB (1) = -1.D30         !*** CHANGED D60 TO D30
      VZSTAB (NTABF + 1) = 1.D30  !*** CHANGED D60 TO D30
      RETURN
C
8000  FORMAT ('  TABGEN WARNING - FOR DEFINITION #', I3,
     1  ', DCADRE ERROR OF', I4, ' WAS FOUND' /
     2  '  SDEF PARAMS:', 1P,6E10.2)
      END
