!+
!KWIC torzer.f
!
!$Id: torzer.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /COMIC/:  add save statement; move to include file
!   95-Jan-26[T. Gaetz]
!      . comment out declarations of sdum, tdum; never used
!      . add declarations for:
!        i, iclose, iflg, iord, isreal, krap (4), nord, nord1, zplane, 
!        pcoef (5), ckrp2, cona, conb, conc, pcmax, difmin, stemp, 
!        difnow, tel, prod,
!        xd, yd, zd, xl, yl, zl, xg, yg, zg, phil, rtor, k, rtor, p, s, q0,
!        kp, lp, kx, lx, kode, norm
!   95-Jan-20[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . switch to implicit none
!      . eliminate output to unit 6
!-

      SUBROUTINE TORZER (RTOR, K, P, S, KP, LP, NORM, KX, LX, KODE, Q0)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    TORZER FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/16/89
C    *
C   /******************************************/
C
C  PURPOSE: REFLECTION OF RAY OFF A TORIC SURFACE, DEFINED AS
C           A CURVE IN THE Y-Z PLANE
C             Y ** 2 = 2K * Z - P * Z ** 2
C           WHICH HAS BEEN ROTATED ABOUT THE LINE
C             {X = 0; Z = R}
C           ZERNIKE DEFORMATIONS ARE ALSO ALLOWED, AND ARE
C           DEALT WITH ITERATIVELY
C
C  INPUT ARGUMENTS:
C  RTOR  : HEIGHT OF ROTATION AXIS ABOVE X-Y PLANE
C          (AN ABSOLUTE VALUE LARGER THAN 1.D15 MEANS INFINITY)
C  K     : 1/2 LINEAR TERM IN SURFACE EQUATION
C          (AN ABSOLUTE VALUE LARGER THAN 1.D15 MEANS INFINITY)
C  P     : CONIC CONSTANT = 1 - ECCENTRICITY ** 2
C  KP    : IV# A POINT ON THE ENTERING RAY
C  LP    : IV# DIRECTION OF ENTERING RAY
C  NORM  : IV# DESIRED FOR OUTER NORMAL AT INTERSECTION
C  KX    : IV# DESIRED FOR INTERSECTION OF RAY WITH TORIC
C  LX    : IV# DESIRED FOR DIRECTION OF REFLECTED RAY
C  KODE  : I*4 INDICATOR SHOWING HOW RAY IS TO INTERSECT SURFACE
C        KODE = 2  : INTERNAL REFLECTION
C        KODE = 4  : EXTERNAL REFLECTION
C                    (INTERNAL AND EXTERNAL REFER TO THE BASIC CONIC
C                    CURVE IN THE Y-Z PLANE, RATHER THAN TO THE
C                    CIRCLE IN THE X-Z PLANE.)
C
C  INPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    V# KP AND V# LP
C
C  OUTPUT ARGUMENTS:
C  S     : DISTANCE FROM V# KP TO V# KX
C  KODE  : INDICATOR SHOWING HOW RAY INTERSECTED SURFACE
C        KODE = 0  : INCONSISTENT OR TAUTOLOGICAL EQUATION
C        KODE = 1  : INTERNAL REFRACTION
C        KODE = 2  : INTERNAL REFLECTION
C        KODE = 3  : EXTERNAL REFRACTION
C        KODE = 4  : EXTERNAL REFLECTION
C        KODE = 7  : NEGATIVE DISTANCE
C        KODE = 8  : EXCESSIVE ROUND OFF ERROR
C        KODE = 9  : TOO MANY ITERATIONS
C        KODE = 10 : RAY MISSED SURFACE
C        KODE = 11 : UNDETERMINED ERROR ON INPUT TO TORZER
C        KODE = 12 : UNDETERMINED ERROR
C        Q0   : R*8 - NORMALIZED SURFACE SECOND DERIVATIVE MATRIX
C                     (SYMMETRIC STORAGE MODE; EVALUATED BY ITOZER;
C                     BUT, STILL IN THE BODY CENTERED COORDINATE SYSTEM)
C
C  OUTPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    V# NORM, V# KX, V# LX
C
C   XR : RPZERO, VFLECT
C
      implicit none

      double precision k, rtor, p, s, q0 (6)
      integer          kp, lp, norm, kx, lx, kode

!tjg  DIMENSION PCOEF (5), SDUM (4)
!tjg  COMPLEX * 16 RZERO (4), TDUM (30)
      COMPLEX * 16 RZERO (4)


      integer          i, iclose, iflg, iord, isreal, krap (4), 
     &                 nord, nord1
      double precision zplane, pcoef (5), ckrp2, cona, conb, conc, 
     &                 pcmax, difmin, stemp, difnow, tel, prod

      include 'saosacLib/comic.h'     ! xd,yd,zd,xl,yl,zl,xg,yg,zg,phil
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DATA KRAP /3, 4, 1, 2 /
C             
C
C  CHECK FOR UNDETERMINED ERROR ON ENTRY, AND PROPAGATION
C  PARALLEL TO Z=0 PLANE ERROR
C
      IF (KODE .LT. 1 .OR. KODE .GT. 4) GO TO 640
C
C  INITIALIZATION
C    XD, YD, ZD : CURRENT POINT ON LINE
C    XL, YL, ZL : DIRECTION OF RAY
C    ZPLANE = DISTANCE TO Z=0 PLANE IN BODY CENTERED COORD SYS
C
      XD = XV (KP)
      YD = YV (KP)
      ZD = ZV (KP)
      XL = XV (LP)
      YL = YV (LP)
      ZL = ZV (LP)
      IF (DABS (ZL) .LT. 1.D-16) GO TO 600
      ZPLANE = - ZD / ZL
C
C
C  SOLVE FOR THE SET OF PROPAGATION DISTANCES
C
C
      IF (DABS (K) .GE. 0.99999D15) GO TO 220
      IF (DABS (RTOR) .GE. 0.99999D15) GO TO 200
      IF (P .EQ. 0.D0) GO TO 150
C
C  RTOR FINITE, K FINITE, P NON-ZERO - SOLVE A 4TH ORDER POLY
C
      CKRP2 = (K / RTOR - P) ** 2
      CONA = 2.D0 * P * (P * ZD - K) + 2.D0 * K * K / RTOR -
     *       (P / RTOR) * (P * (XD * XD + ZD * ZD) + YD * YD)
      CONB = 2.D0 * P * P * ZL - 2.D0 * (P / RTOR) *
     *       (P * (XD * XL + ZD * ZL) + YD * YL)
      CONC = - (P / RTOR) * (P * (XL * XL + ZL * ZL) + YL * YL)
      PCOEF (1) = CONC * CONC
      PCOEF (2) = 2.D0 * CONB * CONC
      PCOEF (3) = CONB * CONB + 2.D0 * CONA * CONC + 4.D0 *
     *            CKRP2 * P * YL * YL
      PCOEF (4) = 2.D0 * CONA * CONB + 8.D0 *
     *            CKRP2 * P * YD * YL
      PCOEF (5) = CONA * CONA - 4.D0 * CKRP2 * (K * K - P * YD * YD)
      NORD = 4
      GO TO 250
C
C  RTOR FINITE, K FINITE, P ZERO - SOLVE A 4TH ORDER POLY
C  
150   PCOEF (1) = YL ** 4 / (8.D0 * RTOR * K * K)
      PCOEF (2) = YD * YL ** 3 / (2.D0 * RTOR * K * K)
      PCOEF (3) = - (1.D0 / (2.D0 * K)) * YL * YL -
     *              (1.D0 / (2.D0 * RTOR)) * (XL * XL + ZL * ZL) +
     *              (3.D0 / (4.D0 * RTOR * K * K)) * YD * YD * YL
      PCOEF (4) = ZL - (1.D0 / K) * (YD * YL) -
     *            (1.D0 / RTOR) * (XD * XL + ZD * ZL) +
     *            (1.D0 / (2.D0  * RTOR * K * K)) * YD ** 3 * YL
      PCOEF (5) = ZD - (1.D0 / (2.D0 * K)) * YD * YD -
     *            (1.D0 / (2.D0 * RTOR)) * (XD * XD + ZD * ZD) +
     *            (1.D0 / (8.D0 * RTOR * K * K)) * YD ** 4
      NORD = 4
      GO TO 250
C
C  RTOR INFINTE, K FINITE, P DOESN'T MATTER - SOLVE A 2ND ORDER POLY
C
200   PCOEF (1) = P * ZL * ZL + YL * YL
      PCOEF (2) = 2.D0 * (P * ZD - K) * ZL + 2.D0 * YD * YL
      PCOEF (3) = P * ZD * ZD + YD * YD - 2.D0 * ZD * K
      NORD = 2
      GO TO 250
C
C  K INFINITE, P DOESN'T MATTER - SOLVE A 1ST OR 2ND ORDER POLY
C
220   IF (DABS (RTOR) .GE. 0.99999D15) GO TO 230
      PCOEF (1) = (XL * XL + ZL * ZL) / (RTOR + RTOR)
      PCOEF (2) = (XD * XL + ZD * ZL) / RTOR - ZL
      PCOEF (3) = (XD * XD + ZD * ZD) / (RTOR + RTOR) - ZD
      NORD = 2
      GO TO 250
230   PCOEF (1) = - ZL
      PCOEF (2) = - ZD
      NORD = 1
C
C  REDUCE THE ORDER OF THE EQUATION IF NECESSARY
C
250   NORD1 = NORD + 1
      PCMAX = 0.D0
      DO 260 IORD = 1, NORD1
      PCMAX = DMAX1 (PCMAX, DABS (PCOEF (IORD)))
260   CONTINUE
      IF (PCMAX .EQ. 0.D0) GO TO 600
C
300   IF (DABS (PCOEF (1) / PCMAX) .GT. 1.D-16) GO TO 370
      NORD = NORD - 1
      IF (NORD .EQ. 0) GO TO 600
      NORD1 = NORD + 1
      DO 360 IORD = 1, NORD1
      PCOEF (IORD) = PCOEF (IORD + 1)
360   CONTINUE
      GO TO 300
C
C  SOLVE THE EQUATION, FIND THE REAL ZERO NEAREST ZPLANE
C
370   IFLG = 0
      CALL RLROOT (NORD, PCOEF, RZERO, IFLG)
      DIFMIN = 1.D30
      ICLOSE = 0
      ISREAL = 0
      DO 390 I = 1, NORD
      IF (DABS (DIMAG (RZERO (I))) .GT.
     *   1.D-10 * DABS (DREAL (RZERO (I)))) GO TO 390
      STEMP = DREAL (RZERO (I))
      ISREAL = 1
      IF (STEMP .LE. 0.D0) GO TO 390
      DIFNOW = DABS (ZPLANE - STEMP)
      IF (DIFNOW .GT. DIFMIN) GO TO 390
      ICLOSE = I
      DIFMIN = DIFNOW
390   CONTINUE
      IF (ICLOSE .GT. 0) GO TO 400
C
C  RAY MISSED, OR HAD NEGATIVE PATH LENGTH
C
      IF (ISREAL .EQ. 1) GO TO 620
      IF (ISREAL .EQ. 0) GO TO 630
C
C  S IS THE PROPER SOLUTION FOR DISTANCE TO THE UNDEFORMED SURFACE.
C  CORRECT FOR ZERNIKE SURFACE DEFORMATIONS AND REFLECT RAY.
C
400   S = DREAL (RZERO (ICLOSE))
C
C  XD, YD, ZD : CONIC INTERSECTION
C
      XD = XD + S * XV (LP)
      YD = YD + S * YV (LP)
      ZD = ZD + S * ZV (LP)
C
C  ITERATE TO GET TO THE EXACT DEFORMED SURFACE
C
      CALL ITOZER (RTOR, K, P, TEL, KODE, Q0)
      IF (KODE .GT. 4) GO TO 700
      S = S + TEL
      IF (S .LT. 0.0D0) GO TO 620
C
C  INTERSECTION WITH DEFORMED SURFACE FOUND.  TRANSFER TO (KX)
C
      XV (KX) = XD
      YV (KX) = YD
      ZV (KX) = ZD
C
C  CHECK FOR HITTING THE CORRECT SIDE OF THE SURFACE
C
      PROD = (XL * XG + YL * YG + ZL * ZG) * K
      IF (PROD .GT. 0.D0 .AND. KODE .GT. 2) GO TO 610
      IF (PROD .LT. 0.D0 .AND. KODE .LE. 2) GO TO 610
C
C  XG, YG, ZG : GRADIENT OF THE SURFACE AT (XD, YD, ZD)
C
      XV (NORM) = XG
      YV (NORM) = YG
      ZV (NORM) = ZG
      CALL VFLECT (LP, NORM, LX)
      XL = XV (LX)
      YL = YV (LX)
      ZL = ZV (LX)
      GO TO 700
C
C  SET KODE AND EXIT
C
600   CONTINUE
C  KODE = 0 : INCONSISTENT OR TAUTOLOGICAL EQUATION
      WRITE (8, 1200)
      XL = XV (LP)
      YL = YV (LP)
      ZL = ZV (LP)
      WRITE (8, 1600) KODE, XD, YD, ZD, XL, YL, ZL, RTOR, P, K
      KODE = 0
      GO TO 700
C
610   CONTINUE
C  KODE = KRAP(KODE) : WRONG SIDE OF THE SURFACE
      KODE = KRAP (KODE)
      GO TO 700
C
620   CONTINUE
C  KODE = 7 : NEGATIVE PATH LENGTH
      KODE = 7
      GO TO 700
C
630   CONTINUE
C  KODE = 10 : RAY MISSES THE SURFACE
      KODE = 10
      GO TO 700
C
640   CONTINUE
C  KODE = 11 : UNDETERMINED ERROR ON INPUT TO TORZER
      WRITE (8, 1000)
      WRITE (8, 1500) KODE, XD, YD, ZD, RTOR, P, K
      KODE = 11
C
700   CONTINUE
      RETURN
1000  FORMAT ('- UNDETERMINED ERROR ON INPUT TO TORZER ')
1200  FORMAT ('- TORZER ERROR : INCONSISTENT OR TAUTOLOGICAL EQUATION ')
1500  FORMAT ('- KODE = ',I10,' XD = ',1P,D15.6,' YD = ',1P,D15.6,
     1      ' ZD = ',1PD15.6,' RTOR = ',1P,D15.5,' P = ',1P,D15.6,/,
     2      ' K = ',1P,D15.6)
1600  FORMAT ('- KODE = ',I10,' XD = ',1P,D15.6,' YD = ',1P,D15.6,
     1      ' ZD = ',1P,D15.6,' XL = ',1P,D15.6,' YL = ',1P,D15.6,
     2      /,' ZL = ',1P,D15.6,' RTOR = ',1P,D15.5,' P = ',1P,D15.6,
     3      ' K = ',1P,D15.6)
      END
