!+
!KWIC tracer.f
!
!$Id: tracer.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-31[T. Gaetz]
!      . declare CSIN as external; sgi objects
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification: CCSIN --> CSIN
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/7/88 TO INCLUDE FULL POLARIZATION CALCULATIONS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE TRACER
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    TRACER FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   02/04/81 (PAUL GLENN)
C    *    TIME:     16:25:09
C    *
C    ******************************************/
C
C  TRACE A RAY THROUGH A 2 SURFACE OPTICAL SYSTEM FOR NABRAT
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN ( 3) : ZOFF - Z OFFSET OF FOCAL PLANE
C
C    IF J = SURFACE NUMBER THEN,
C    SURF (4, J) : P - CONIC CONSTANT = 1 - ECCEN ** 2
C    SURF (5, J) : VERTEX RADIUS OF CURV. OR K FACTOR OF XRAY SURFACE
C    SURF (6, J) : P0 - CENTER RADIUS  (USUALLY 0 FOR CONVENTIONAL)
C
C  INPUT VIA LABELED COMMON /PARX/:
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    SWITCH FOR SURFACE J:
C    LSW (1, J) : F - CONCAVE SURFACE, T - CONVEX SURFACE
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#1 = INITIAL POSITION
C    V#2 = DIRECTION
C    V#11, 12, 13 = ROTATION MATRIX FOR SURFACE #1
C    V#14 = TRANSLATION VECTOR FOR SURFACE #1
C    V#21, 22, 23 = ROTATION MATRIX FOR SURFACE #2
C    V#24 = TRANSLATION VECTOR FOR SURFACE #2
C
C  INPUT & OUTPUT VIA /SUMRY/:
C    AQ    : 10*R*8 - COEFFICIENTS OF QUADRATIC FOCUS FUNCTION
C    WF1   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE #1
C    WF2   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE #2
C    WS1   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE #1
C    WS2   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE #2
C    JAIL1 : I*4 - NUMBER OF RAYS FAILING AT SURFACE #1
C    JAIL2 : I*4 - NUMBER OF RAYS FAILING AT SURFACE #2
C    LEFT1 : I*4 - NUMBER OF RAYS LEAVING SURFACE # 1
C    LEFT2 : I*4 - NUMBER OF RAYS LEAVING SURFACE # 2
C    XMIN  : R*4 - MINIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    XMAX  : R*4 - MAXIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    YMIN  : R*4 - MINIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C    YMAX  : R*4 - MAXIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C
C  OUTPUT VIA D#24: RAY001, D#26: RAY002, D#28: RAY003
C
C  INPUT & OUTPUT VIA LABELED COMMON /RAIN/:
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : I*4 - INTEGER    PORTION OF PATH LENGTH
C    KODE : I*4 - RAY STATUS CODE (SEE CHEX OUTPUT)
C    W    : R*4 - RELATIVE INTENSITY OF RAY
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#7 = POSITION AT FOCAL PLANE
C    V#6 = DIRECTION AT FOCAL PLANE
C
C  XR : CHEX, CONCYL, CSIN, CSOUT, VDERO, VFOCUS, VLINE, VROT8, WRAN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      external csin

      DOUBLE PRECISION H
C
C  INITIALIZE WEIGHT AND KODE
      W = 1.0
      KODE = 2
      IF (LSW (1, 1)) KODE = 4
      MODE = KODE
C
CBUG  CALL VWRITE ('INPT', JING, J2, 1, 2, KODE)
C
C  REFLECT RAY FROM SURFACE #1
!  (BEGIN BY INITIALIZING THE POLARIZATION CALCULATIONS)
      KURF = 1
      CALL CSIN (2, 11)
      CALL VROT8 (1, 2, 14, 11, 12, 13, 15, 16)
CBUG  CALL VWRITE ('ROT1', JING, J2, 15, 16, KODE)
      CALL CONCYL (SURF (6, 1), SURF (5, 1), SURF (4, 1), H,
     1  15, 16, 19, 17, 18, KODE)
      CALL CHEX (1, 17, MODE, KODE)
CBUG  CALL VWRITE ('CON1', JING, J2, 17, 18, KODE)
      CALL VDERO (17, 18, 14, 11, 12, 13, 3, 4)
CBUG  CALL VWRITE ('DER1', JING, J2, 3, 4, KODE)
!  (IF RAY WAS SUCCESSFUL, FINISH THE POLARIZATION CALCULATIONS)
      IF (KODE .EQ. MODE) CALL CSOUT (4, 11)
C
C  UPDATE PATH LENGTH
      FOP = FOP + H
      I = FOP + 0.5
      FOP = FOP - I
      IOP = IOP + I
C
C  WRITE DATA RECORD
      CALL WRAN (1, 3, 4)
CBUG  WRITE (8, 800) I, IOP, H, W
      IF (KODE .GE. 5) GO TO 120
C
C  UPDATE RAY SUMMARY
      LEFT1 = LEFT1 + 1
      WS1 = WS1 + W
C
      KODE = 2
      IF (LSW (1, 2)) KODE = 4
      MODE = KODE
C
C  REFLECT RAY FROM SURFACE #2
!  (BEGIN BY INITIALIZING THE POLARIZATION CALCULATIONS)
      KURF = 2
      CALL CSIN (4, 21)
      CALL VROT8 (3, 4, 24, 21, 22, 23, 25, 26)
CBUG  CALL VWRITE ('ROT2', JING, J2, 25, 26, KODE)
      CALL CONCYL (SURF (6, 2), SURF (5, 2), SURF (4, 2), H,
     1 25, 26, 29, 27, 28, KODE)
      CALL CHEX (2, 27, MODE, KODE)
CBUG  CALL VWRITE ('CON2', JING, J2, 27, 28, KODE)
      CALL VDERO (27, 28, 24, 21, 22, 23, 5, 6)
CBUG  CALL VWRITE ('DER2', JING, J2, 5, 6, KODE)
!  (IF RAY WAS SUCCESSFUL, FINISH THE POLARIZATION CALCULATIONS)
      IF (KODE .EQ. MODE) CALL CSOUT (6, 21)
C
C  UPDATE PATH LENGTH
      FOP = FOP + H
      I = FOP + 0.5
      FOP = FOP - I
      IOP = IOP + I
C
C  WRITE DATA RECORD
      CALL WRAN (2, 5, 6)
CBUG  WRITE (8, 800) I, IOP, H, W
      IF ( KODE .GE. 5) GO TO 130
C
C  UPDATE RAY SUMMARY
      LEFT2 = LEFT2 + 1
      WS2 = WS2 + W
C
C  INTERSECT RAY WITH FOCAL PLANE
      H = (GEN (3) + GFOC - ZV (5)) / ZV (6)
      CALL VLINE (5, H, 6, 7)
CBUG  CALL VWRITE ('FOCU', JING, J2, 7, 6, KODE)
C
C  UPDATE PATH LENGTH
      FOP = FOP + H
      I = FOP + 0.5
      FOP = FOP - I
      IOP = IOP + I
C
      ZV (7) = GEN (3)
C  WRITE DATA RECORD
      CALL WRAN (3, 7, 6)
CBUG  WRITE (8, 800) I, IOP, H, W
C
C  UPDATE FOCAL PLANE EXTREMA
      XMIN = MIN (XMIN, XV (7))
      XMAX = MAX (XMAX, XV (7))
C
      YMIN = MIN (YMIN, YV (7))
      YMAX = MAX (YMAX, YV (7))
C
C  UPDATE COEFFICIENTS OF QUADRATIC FOCUS FUNCTION
      CALL VFOCUS (7, 6, W, AQ)
CBUG  CALL WRIT8 ('-QUADCOF', 8, 10, AQ)
      GO TO 200
C
C  RAY FAILED AT FIRST SURFACE
120   JAIL1 = JAIL1 + 1
      WF1 = WF1 + W
      GO TO 200
C
C  RAY FAILED AT SECOND SURFACE
130   JAIL2 = JAIL2 + 1
      WF2 = WF2 + W
C
200   RETURN
CBUG800   FORMAT ('-TRACEB, I=',I5,' IOP=',I6,' H=',F12.6,' W=',F10.6)
      END
