!KWIC tralay.f
!
!$Id: tralay.f,v 1.1 2004/03/16 15:50:12 dtn Exp $
!
!Revisions:
!   93-Aug-11[T. Gaetz]
!      . In FORMAT statements:  change floating point formats to E25.17
!

      SUBROUTINE TRALAY (JDEV, NRAY, JAIL, LEFT, WF, WS)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    TRALAY FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/23/80
C    *
C    *    UPDATE:   07/23/80
C    *    TIME:     10:41:16
C    *
C    ******************************************/
C
C   WRITES THE TRAILER RECORD OF A RAY FILE
C
C  INPUT ARGUMENTS :
C    JDEV : I*4 DEVICE NUMBER  (D#)
C    NRAY : I*4 NUMBER OF RAYS IN PATTERN
C    JAIL : I*4 NUMBER OF RAY FAILURES OCURRING AT CURRENT SURFACE
C    LEFT : I*4 NUMBER OF ACTIVE RAYS LEFT
C    WF   : R*8 TOTAL WEIGHT OF RAYS FAILING AT CURRENT SURFACE
C    WS   : R*8 TOTAL WEIGHT OF ACTIVE RAYS
C  OUTPUT VIA D# JDEV : TRAILER RECORD COMPRISING :
C   -NRAY : - # RAYS IN PATTERN
C    NAIL : TOTAL # RAY FAILURES THROUGH CURRENT SURFACE
C    LEFT : # ACTIVE RAYS
C    JAIL : # RAY FAILURES OCCURRING AT CURRENT SURFACE
C    JEFT : # ACTIVE RAYS AT PRECEEDING SURFACE
C    WF   : TOTAL WEIGHT OF RAYS FAILING AT CURRENT SURFACE
C    WS   : TOTAL WEIGHT OF ACTIVE RAYS
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      DOUBLE PRECISION  WF, WS
      INTEGER * 4 M(5)
      M (1) = -NRAY
      M (2) =  NRAY - LEFT
      M (3) =  LEFT
      M (4) =  JAIL
      M (5) = LEFT + JAIL
C
      WRITE (JDEV, 100) M, WF, WS
      RETURN
100   FORMAT (5(I9,1X)/ 1P,E25.17,1X,1P,E25.17)
      END
