!+
!KWIC vdero.f
!
!$Id: vdero.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . switch to IMPLICIT NONE
!-
      SUBROUTINE VDERO (IP, IDC, JO, IX, JY, KZ, JP, JDC)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VDERO FORTRAN
C    *    WRITTEN BY
C    *            ON 05/21/80
C    *
C    *    UPDATE:   08/19/80
C    *    TIME:     10:38:33
C    *
C    ******************************************/
C  PURPOSE :  DEROTATE ID AND IDC ACCORDING TO NEW COORDINATE AXES
C    IX JY KZ  THEN TRANSLATE IP BACK BY VECTOR JO
C   PUTTING THE RESULT IN JP JDC
C
C  INPUT ARGUMENTS:
C  IP  : VECTOR LOCATION FOR RAY POSITION
C  IDC : VECTOR LOCATION FOR RAY DIRECTION COSINES
C  JO  : VECTOR LOCATION FOR TRANSLATION
C  IX  : VECTOR LOCATION FOR X-AXIS DIRECTION COSINES
C  JY  : VECTOR LOCATION FOR Y-AXIS DIRECTION COSINES
C  KZ  : VECTOR LOCATION FOR Z-AXIS DIRECTION COSINES
C  JP  : VECTOR LOCATION FOR NEW RAY POSITION
C  JDC : VECTOR LOCATION FOR NEW RAY DIRECTION COSINES
C
C  INPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C  THE VECTORS IN LOCATIONS IP, IDC, JO, IX, IY, AND KZ
C
C  OUTPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C  THE VECTORS IN LOCATIONS: JP AND JDC
C
C  NOTE : IT IS PERMISSIBLE FOR JP = IP AND FOR JDC = IDC
C
      IMPLICIT DOUBLE PRECISION  (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER IP, IDC, JO, IX, JY, KZ, JP, JDC
      DOUBLE PRECISION X, Y, Z

C
C     TRANSFER POSITION VECTOR
C
      X = XV (IP)
      Y = YV (IP)
      Z = ZV (IP)
C
C  ROTATE AND TRANSLATE POSITION
C
      XV(JP) = XV(IX) * X + XV(JY) * Y + XV(KZ) * Z + XV(JO)
      YV(JP) = YV(IX) * X + YV(JY) * Y + YV(KZ) * Z + YV(JO)
      ZV(JP) = ZV(IX) * X + ZV(JY) * Y + ZV(KZ) * Z + ZV(JO)
C
C  TRANSFER DIRECTION
C
      X = XV(IDC)
      Y = YV(IDC)
      Z = ZV(IDC)
C
C   ROTATE DIRECTION
C
      XV(JDC) = XV(IX) * X + XV(JY) * Y + XV(KZ) * Z
      YV(JDC) = YV(IX) * X + YV(JY) * Y + YV(KZ) * Z
      ZV(JDC) = ZV(IX) * X + ZV(JY) * Y + ZV(KZ) * Z
C
      RETURN
      END
