!+
!KWIC verfoc.f
!
!$Id: verfoc.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO ALLOW TOROIDAL SURFACES
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . initialize DMAX with PARAMETER
!   93-Oct-05[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipeline and
!        should be clear of ascii output
!-
!
!  UPDATED 1/22/88 TO IGNORE OBSCURATION-TYPE SURFACES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO ALLOW FOR FINITE DISTANCE POINT SOURCE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 8/29/88 TO CLEAN UP TREATMENT OF NON-CONIC FIRST SURFACE
!  IN THE TREATMENT OF FOCUS INFORMATION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE VERFOC
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VERFOC FORTRAN
C    *    WRITTEN BY HAROLD JACKSON
C    *            ON 06/13/80
C    *
C    *    UPDATE:   01/25/82
C    *    TIME:     13:20:16
C    *
C    ******************************************/
C
C  PURPOSES: 1 - CALCULATE THE GEOMETRIC CENTER, RADIUS OF CURVATURE,
C                VERTICES, FOCI, AND ECCENTRICITY FOR THE SURFACES.
C            2 - CALCULATE THE CONFOCAL DELTA BETWEEN TWO CONSECUTIVE
C                SURFACES.
C            3 - FIND THE GEOMETRIC FOCUS OF THE SYSTEM.
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (3) : R*8 - ZOFF - Z OFFSET OF THE FOCAL PLANE
C    GEN (13) : R*8 - PTSRC - DISTANCE FROM PT SOURCE TO PUPIL CENTER
C    FOR SURFACE #J:
C    SURF (3, J) : R*8 - Z - Z COORD. AT SURFACE CENTER
C    SURF (4, J) : R*8 - P - CONIC CONSTANT = 1 - ECCEN. ** 2
C    SURF (5, J) : R*8 - VERTEX RADIUS OF CURV. OR K FACTOR OF XRAY SURF
C    SURF (6, J) : R*8 - P0 - CENTER RADIUS (USUALLY 0 FOR CONVEN), OR
C                        RTOR - TOROIDAL RADIUS
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    GENERAL SYSTEM SWITCH:
C    LSW0 (3) : T - ZOFF WRT STD
C               F - ZOFF WRT GFOC
C    SURFACE SWITCH:
C    LSW (3, J) : T - FLAT SURFACE, F - NOT FLAT
!    LSW (5, J) : F - NOT AN ANNULAR OBSCURATION, T - ANNULAR OBSC
!    LSW (6, J) : F - NOT A RECTANGULAR OBSC, T - RECTANGULAR OBSC
!    LSW (8, J) : F - NOT TOROIDAL, T - TOROIDAL
C
C  OUTPUT VIA #8:
C    FOR EACH SURFACE THE FOLLOWING PARAMETERS ARE REPORTED IN THE
C    BODY CENTERED COORD. SYSTEM AND STANDARD COORD. SYSTEM:
C    CEN : R*8 - GEOMETRIC CENTER
C    RC  : R*8 - RADIUS OF CURVATURE
C    VL  : R*8 - LEFT VERTEX
C    VR  : R*8 - RIGHT VERTEX
C    FL  : R*8 - LEFT FOCUS
C    FR  : R*8 - RIGHT FOCUS
C    E   : R*8 - ECCENTRICITY
C
C  OUTPUT VIA #6 AND #8:
C    DELT : R*8 - THE CONFOCAL DELTA BETWEEN CONSECUTIVE SURFACES
C    GFOC : R*8 - GEOMETRIC FOCUS OF THE SYSTEM
C
C  OUTPUT VIA LABELED COMMON /PARX/:
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      DOUBLE PRECISION DMAX
      PARAMETER      ( DMAX = 1.0D+30 )     !*** CHANGED D60 TO D30

CBUG  NAMELIST /VERFOB/ J, A, B, C, FUN
C
!
!  SET UP A PARALLEL COUNTER FOR CONIC SURFACES
      JCONIC = 0
      DO 200 J = 1, NS
!
!  ALLOW TORIC SURFACES TO BE TREATED EXACTLY LIKE CONIC SURFACES
!  BY TREATING THE P0 PARAMETER SEPARATELY, SINCE IT IS ALWAYS
!  ZERO FOR A TOROID
!
      SURF6J = SURF (6, J)
      IF (LSW (8, J)) SURF6J = 0.D0
C
C  IGNORE FLAT SURFACE
      IF (LSW (3, J)) GO TO 200
!
!  IGNORE OBSCURATION-TYPE SURFACE
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 200
C
!
!  YES, THIS IS A CONIC SURFACE - INCREMENT JCONIC
      JCONIC = JCONIC + 1
      IF (SURF (4, J) .NE. 0.0D0) GO TO 50
C
C  CASE WHEN P = 0:
      A = DMAX
      E = 1.0D0
      RC = SURF (5, J)
      IF (SURF (5, J)) 10, 30, 20
C
C  CASE WHEN K < 0:
10    VL = -A
      VR = -(SURF6J * SURF6J) / (SURF (5, J) + SURF (5, J))
!
!  (ASSUME P0 (I.E., SURF (J)) IS 0 FOR A TOROID)
!
      IF (LSW (8, J)) VR = 0.D0
!
      FL = VL
      FR = VR + 0.5 * SURF(5, J)
      CEN = -1.0D+6
      C = FR - CEN
      GO TO 90
C
C  CASE WHEN K > 0:
20    VL = -(SURF6J * SURF6J) / (SURF (5, J) + SURF (5, J))
!
!  (ASSUME P0 (I.E., SURF (J)) IS 0 FOR A TOROID)
!
      IF (LSW (8, J)) VL = 0.D0
!
      VR = A
      FL = VL + 0.5 * SURF (5, J)
      FR = A
      CEN = +1.0D+6
      C = CEN - FL
      GO TO 90
C
C  CASE WHEN K = 0:
30    VL = - DMAX
      VR = + DMAX
      FL = - DMAX
      FR = + DMAX
      CEN = 0.0D0
      GO TO 90
C
C  CASE WHEN P IS NOT 0:
50    CEN = SURF (5, J) / SURF (4, J)
      A2 = CEN * CEN + SURF6J * SURF6J / SURF (4, J)
!
!  (ASSUME P0 (I.E., SURF (J)) IS 0 FOR A TOROID)
!
      IF (LSW (8, J)) A2 = CEN * CEN
!
      A = DSQRT (A2)
      VL = CEN - A
      VR = CEN + A
      RC = A * SURF (4, J)
      IF (CEN .LT. 0.0D0) RC = -RC
C
      B2 = A * DABS (RC)
C  B : SEMIMINOR AXIS
      B = DSQRT (B2)
C  C : SEMIFOCAL DISTANCE
      C = DSQRT (DABS (A2 - DSIGN (B2, SURF (4, J))))
      FL = CEN - C
      FR = CEN + C
      E = C / A
C
90    CALL INCLIN (23)
      WRITE (8, 500) J, CEN, RC, VL, VR, FL, FR, E
C
C  TRANSFORM TO STD COORD. SYSTEM
      CEN = CEN + SURF (3, J)
      VL = VL + SURF (3, J)
      VR = VR + SURF (3, J)
      FL = FL + SURF (3, J)
      FR = FR + SURF (3, J)
C
      WRITE (8, 520) CEN, VL, VR, FL, FR
C
!
!  CHECK FOR FIRST CONIC SURFACE, RATHER THAN FOR FIRST SURFACE
!      IF (J .EQ. 1) GO TO 110
!
      IF (JCONIC .EQ. 1) GO TO 110
C
C  ** ADDITION **  CHECK TO SEE IF MATCHING TWO P=0 SURFS
      IF (DABS (FUN) .NE. DMAX) GO TO 98
C  OLD SURFACE WAS A P=0 SURF - CHECK NEW SURFACE
      IF (FL .EQ. - DMAX) GO TO 100
      IF (FR .EQ. + DMAX) GO TO 99
C  ** END OF ADDITION **
98    IF (CEN .GT. FUN) GO TO 100
99    DELT = FR - FUN
      FUN = FL
      GO TO 120
C
100   DELT = FL - FUN
      FUN = FR
      GO TO 120
C
110   FUN = CEN - DSIGN (C, CEN)
!
!  REVAMP THE CALCULATIONS FOR THE FIRST SURFACE.  DELTA IS THE
!  ELEMENT'S ORIGINAL FOCUS (IN STD C.S.), MINUS THE POINT SOURCE
!  COORDINATE.  IF THE FIRST SURFACE WAS A PARABOLA (P=0), USE
!  -DMAX RATHER THAN A TRUE FOCAL POINT.
!  (THE PREVIOUS ANSWER BELOW WAS NOT A CONFOCAL DELTA AT ALL...)
!     DELT = 1.D0 / A
      FP = CEN + DSIGN (C, CEN)
      IF (SURF (4, J) .EQ. 0.D0) FP = - DMAX
      DELT = FP + GEN (13)
C
120   continue
      WRITE (8, 540) DELT
CBUG  WRITE (8, VERFOB)
C
200   CONTINUE
C
      GFOC = 1.0D0
      IF (LSW0(3)) GO TO 210
      GFOC = FUN
      GO TO 220
210   GFOC = GEN (3)
      GEN (3) = 0.0D0
220   continue
      CALL INCLIN (2)
      WRITE (8, 560) GFOC
      RETURN
C
500   FORMAT (/ 1X, 'SURFACE NUMBER =', I5 //
     1 3X, 'IN BODY CENTERED COORDINATE SYSTEM:' //
     2 5X, 'GEOMETRIC CENTER    =', 1P,D22.14 /
     3 5X, 'RADIUS OF CURVATURE =', 1P,D22.14 /
     4 5X, 'LEFT VERTEX         =', 1P,D22.14 /
     5 5X, 'RIGHT VERTEX        =', 1P,D22.14 /
     6 5X, 'LEFT GEOM FOCUS     =', 1P,D22.14 /
     7 5X, 'RIGHT GEOM FOCUS    =', 1P,D22.14 /
     8 5X, 'ECCENTRICITY        =', 1P,D22.14)
520   FORMAT (// 3X, 'IN STANDARD COORDINATE SYSTEM:' //
     1 5X, 'GEOMETRIC CENTER    =', 1P,D22.14 /
     3 5X, 'LEFT VERTEX         =', 1P,D22.14 /
     4 5X, 'RIGHT VERTEX        =', 1P,D22.14 /
     5 5X, 'LEFT GEOM FOCUS     =', 1P,D22.14 /
     6 5X, 'RIGHT GEOM FOCUS    =', 1P,D22.14)
540   FORMAT (5X, 'CONFOCAL DELTA      =', 1P,D22.14 /)
560   FORMAT (/ 1X, 'GENERAL SYSTEM FOCUS    =', 1P,D22.14)
      END
